/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.northbound.filters.api.FilterParserException;
import org.eclipse.sensinact.northbound.filters.api.IFilterHandler;
import org.eclipse.sensinact.northbound.filters.api.IFilterParser;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={IFilterHandler.class})
public class FilterHandler
implements IFilterHandler {
    @Activate
    private BundleContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICriterion parseFilter(String filterLanguage, String filterQuery, Map<String, Object> parameters) throws FilterParserException {
        ServiceReference<IFilterParser> svcRef = this.findParser(filterLanguage);
        try {
            IFilterParser parser = (IFilterParser)this.context.getService(svcRef);
            ICriterion iCriterion = parser.parseFilter(filterQuery, filterLanguage, parameters);
            return iCriterion;
        }
        finally {
            this.context.ungetService(svcRef);
        }
    }

    private ServiceReference<IFilterParser> findParser(String filterLanguage) throws FilterParserException {
        Collection svcRefs;
        try {
            svcRefs = this.context.getServiceReferences(IFilterParser.class, String.format("(%s=%s)", "sensinact.filters.supported", filterLanguage));
        }
        catch (InvalidSyntaxException e) {
            throw new FilterParserException(String.format("Invalid filter language '%s': %s'", filterLanguage, e.getMessage()), e);
        }
        if (svcRefs == null || svcRefs.isEmpty()) {
            throw new FilterParserException(String.format("No parser for filter language '%s'", filterLanguage));
        }
        return (ServiceReference)svcRefs.stream().sorted(Comparator.naturalOrder()).findFirst().get();
    }
}

