/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.notification.ResourceMetaDataNotification;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.DatastreamsMapper;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.osgi.util.promise.Promise;

public class DatastreamMapper
extends DatastreamsMapper {
    private final String provider;
    private final String service;
    private final String resource;

    public DatastreamMapper(String topicFilter, String id, ObjectMapper mapper, GatewayThread thread) {
        super(topicFilter, mapper, thread);
        String[] segments = id.split("~");
        if (segments.length != 3) {
            throw new IllegalArgumentException("The Datastream id " + id + " is not valid");
        }
        this.provider = segments[0];
        this.service = segments[1];
        this.resource = segments[2];
    }

    @Override
    public Promise<Stream<Datastream>> toPayload(AbstractResourceNotification notification) {
        if (this.provider.equals(notification.provider)) {
            return super.toPayload(notification);
        }
        return this.emptyStream();
    }

    private boolean isOurResource(AbstractResourceNotification notification) {
        return this.service.equals(notification.service) && this.resource.equals(notification.resource);
    }

    @Override
    public Promise<Stream<Datastream>> toPayload(LifecycleNotification notification) {
        return this.isOurResource((AbstractResourceNotification)notification) && notification.status == LifecycleNotification.Status.RESOURCE_CREATED ? this.getDatastream(this.getResource(this.provider, this.service, this.resource)) : this.emptyStream();
    }

    @Override
    public Promise<Stream<Datastream>> toPayload(ResourceDataNotification notification) {
        return this.isRelevantAdminResource((AbstractResourceNotification)notification) ? this.getDatastream(this.getResource(this.provider, this.service, this.resource)) : this.emptyStream();
    }

    @Override
    public Promise<Stream<Datastream>> toPayload(ResourceMetaDataNotification notification) {
        return this.isOurResource((AbstractResourceNotification)notification) ? this.getDatastream(this.getResource(this.provider, this.service, this.resource)) : this.emptyStream();
    }
}

