/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.http.factory.integration;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.gateway.southbound.http.factory.integration.RequestHandler;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.ResourceDescription;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.annotation.bundle.Requirement;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
@Requirement(namespace="osgi.service", filter="(objectClass=org.eclipse.sensinact.northbound.session.SensiNactSessionManager)")
public class HttpDeviceFactoryAuthTest {
    static QueuedThreadPool threadPool;
    static Server server;
    static RequestHandler handler;
    static int httpPort;
    @InjectService
    SensiNactSessionManager sessionManager;
    SensiNactSession session;
    BlockingQueue<ResourceDataNotification> queue;
    @InjectService
    ConfigurationAdmin configAdmin;

    @BeforeAll
    static void setup() throws Exception {
        threadPool = new QueuedThreadPool();
        threadPool.setName("server");
        handler = new RequestHandler();
        server = new Server((ThreadPool)threadPool);
        ServerConnector conn = new ServerConnector(server);
        conn.setPort(0);
        server.addConnector((Connector)conn);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        security.setAuthenticator((Authenticator)new BasicAuthenticator());
        UserStore users = new UserStore();
        users.addUser("user1", (Credential)new Password("pass1"), new String[0]);
        users.addUser("user2", (Credential)new Password("pass2"), new String[0]);
        HashLoginService loginService = new HashLoginService();
        loginService.setUserStore(users);
        security.setLoginService((LoginService)loginService);
        security.setHandler((Handler)handler);
        server.setHandler((Handler)security);
        server.start();
        httpPort = conn.getLocalPort();
    }

    @AfterAll
    static void teardown() throws Exception {
        server.stop();
        server = null;
        threadPool.stop();
        threadPool = null;
    }

    @BeforeEach
    void start() throws InterruptedException {
        this.session = this.sessionManager.getDefaultSession(UserInfo.ANONYMOUS);
        this.queue = new ArrayBlockingQueue<ResourceDataNotification>(32);
    }

    @AfterEach
    void stop() {
        this.session.activeListeners().keySet().forEach(arg_0 -> ((SensiNactSession)this.session).removeListener(arg_0));
        this.session = null;
        handler.clear();
    }

    byte[] readFile(String filename) throws IOException {
        try (InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("/" + filename);){
            byte[] byArray = inStream.readAllBytes();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCombined() throws Exception {
        String providerBase = "auth-station";
        String provider1 = "auth-station1";
        String provider2 = "auth-station2";
        this.session.addListener(List.of("auth-station1/*"), (t, e) -> this.queue.offer(e), null, null, null);
        Assertions.assertNull((Object)this.session.describeProvider("auth-station1"));
        Assertions.assertNull((Object)this.session.describeProvider("auth-station2"));
        String staticInputFileName = "csv-station-static";
        handler.setData("/static", new String(this.readFile("csv-station-static.csv")).replace("station", "auth-station"));
        String staticMappingConfig = new String(this.readFile("csv-station-static-mapping.json"));
        String dynamicInputFileName = "csv-station-dynamic";
        String template = new String(this.readFile("csv-station-dynamic.csv")).replace("station", "auth-station");
        String dynamicMappingConfig = new String(this.readFile("csv-station-dynamic-mapping.json"));
        handler.setData("/dynamic", template.replace("$val1$", "21").replace("$val2$", "42"));
        HttpClient clt = new HttpClient();
        clt.start();
        try {
            Assertions.assertEquals((int)401, (int)clt.newRequest("http://localhost:" + httpPort + "/static").send().getStatus());
            Assertions.assertEquals((int)401, (int)clt.newRequest("http://localhost:" + httpPort + "/dynamic").send().getStatus());
        }
        finally {
            clt.stop();
        }
        Configuration config = this.configAdmin.createFactoryConfiguration("sensinact.http.device.factory", "?");
        try {
            Instant start = Instant.now();
            config.update(new Hashtable<String, CallSite>(Map.of("tasks.oneshot", "[{\"url\": \"http://localhost:" + httpPort + "/static\", \"mapping\": " + staticMappingConfig + ", \"auth.user\": \"user1\", \"auth.password\": \"pass1\"}]", "tasks.periodic", "[{\"period\": 2, \"period.unit\": \"SECONDS\", \"url\": \"http://localhost:" + httpPort + "/dynamic\", \"mapping\": " + dynamicMappingConfig + ", \"auth.user\": \"user2\", \"auth.password\": \"pass2\"}]")));
            boolean gotLocation = false;
            boolean gotValue = false;
            block14: while (!gotLocation || !gotValue) {
                ResourceDataNotification notif = this.queue.poll(2L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)notif);
                switch (notif.resource) {
                    case "value": {
                        gotValue = true;
                        continue block14;
                    }
                    case "location": {
                        gotLocation = true;
                        continue block14;
                    }
                }
                if (Duration.between(start, Instant.now()).toMillis() <= 1500L) continue;
                Assertions.fail((String)"Timeout waiting for updates");
            }
            Assertions.assertEquals((int)2, (int)handler.nbVisitedPaths());
            Assertions.assertEquals((int)1, (int)handler.nbVisits("/static"));
            Assertions.assertEquals((int)1, (int)handler.nbVisits("/dynamic"));
            Instant firstValueTimestamp = this.session.describeResource((String)"auth-station1", (String)"data", (String)"value").timestamp;
            Assertions.assertFalse((boolean)firstValueTimestamp.isBefore(start));
            Assertions.assertEquals((int)21, (Integer)((Integer)this.session.getResourceValue("auth-station1", "data", "value", Integer.class)));
            Assertions.assertEquals((int)42, (Integer)((Integer)this.session.getResourceValue("auth-station2", "data", "value", Integer.class)));
            ResourceDescription location1 = this.session.describeResource("auth-station1", "admin", "location");
            Instant firstLocationTimestamp = location1.timestamp;
            Assertions.assertNotNull((Object)location1.value);
            handler.setData("/dynamic", template.replace("$val1$", "38").replace("$val2$", "15"));
            this.queue.clear();
            Assertions.assertNotNull((Object)this.queue.poll(4L, TimeUnit.SECONDS));
            Instant secondTimestamp = this.session.describeResource((String)"auth-station1", (String)"data", (String)"value").timestamp;
            Assertions.assertTrue((boolean)secondTimestamp.isAfter(firstValueTimestamp.plus(1L, ChronoUnit.SECONDS)));
            Assertions.assertEquals((int)38, (Integer)((Integer)this.session.getResourceValue("auth-station1", "data", "value", Integer.class)));
            Assertions.assertEquals((int)15, (Integer)((Integer)this.session.getResourceValue("auth-station2", "data", "value", Integer.class)));
            Assertions.assertNotEquals((Object)firstLocationTimestamp, (Object)secondTimestamp);
            Assertions.assertEquals((Object)firstLocationTimestamp, (Object)this.session.describeResource((String)"auth-station1", (String)"admin", (String)"location").timestamp);
            Assertions.assertEquals((int)2, (int)handler.nbVisitedPaths());
            Assertions.assertEquals((int)1, (int)handler.nbVisits("/static"));
            Assertions.assertEquals((int)2, (int)handler.nbVisits("/dynamic"));
        }
        finally {
            config.delete();
        }
    }
}

