/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.sensinact.gateway.app.api.exception.ApplicationRuntimeException;
import org.eclipse.sensinact.gateway.app.api.exception.LifeCycleException;
import org.eclipse.sensinact.gateway.app.api.exception.ResourceNotFoundException;
import org.eclipse.sensinact.gateway.app.manager.application.AbstractSensiNactApplication;
import org.eclipse.sensinact.gateway.app.manager.application.ActionHookQueue;
import org.eclipse.sensinact.gateway.app.manager.application.ResourceSubscription;
import org.eclipse.sensinact.gateway.app.manager.component.Component;
import org.eclipse.sensinact.gateway.app.manager.component.DataProviderItf;
import org.eclipse.sensinact.gateway.app.manager.component.ResourceDataProvider;
import org.eclipse.sensinact.gateway.app.manager.json.AppContainer;
import org.eclipse.sensinact.gateway.app.manager.json.AppSnaMessage;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.app.manager.watchdog.AppExceptionWatchDog;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONObject;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application
extends AbstractSensiNactApplication {
    private static Logger LOG = LoggerFactory.getLogger(Application.class);
    private final List<ServiceRegistration<DataProviderItf>> serviceRegistrations;
    private final Map<ResourceDataProvider, Collection<ResourceSubscription>> resourceSubscriptions;
    private final Map<String, Component> components;
    private ExecutorService executor = Executors.newFixedThreadPool(1);
    private final LinkedBlockingQueue<SnaMessage<?>> waitingEvents;
    private final ActionHookQueue actionHookQueue;
    private final AppExceptionWatchDog watchDog;

    public Application(AppServiceMediator mediator, AppContainer container, String name, List<ServiceRegistration<DataProviderItf>> serviceRegistrations, Map<ResourceDataProvider, Collection<ResourceSubscription>> resourceSubscriptions, Map<String, Component> components, AppExceptionWatchDog watchDog) {
        this(mediator, container, name, null, serviceRegistrations, resourceSubscriptions, components, watchDog);
    }

    public Application(AppServiceMediator mediator, AppContainer container, String name, String identifier, List<ServiceRegistration<DataProviderItf>> serviceRegistrations, Map<ResourceDataProvider, Collection<ResourceSubscription>> resourceSubscriptions, Map<String, Component> components, AppExceptionWatchDog watchDog) {
        super(mediator, name, identifier);
        this.serviceRegistrations = serviceRegistrations;
        this.resourceSubscriptions = resourceSubscriptions;
        this.components = components;
        this.waitingEvents = new LinkedBlockingQueue();
        this.actionHookQueue = new ActionHookQueue(mediator);
        this.watchDog = watchDog;
    }

    @Override
    protected SnaErrorMessage doStart() {
        try {
            this.actionHookQueue.instantiate();
        }
        catch (LifeCycleException e) {
            return new AppSnaMessage("/AppManager/" + this.getName(), SnaErrorMessage.Error.SYSTEM_ERROR, "Unable to start the application " + this.getName() + " > " + e.getMessage());
        }
        for (Map.Entry<String, Component> entry : this.components.entrySet()) {
            try {
                entry.getValue().instantiate(super.getSession());
            }
            catch (LifeCycleException e) {
                return new AppSnaMessage("/AppManager/" + this.getName(), SnaErrorMessage.Error.SYSTEM_ERROR, "Unable to start the application " + this.getName() + " > " + e.getMessage());
            }
            catch (ApplicationRuntimeException e) {
                return new AppSnaMessage("/AppManager/" + this.getName(), SnaErrorMessage.Error.SYSTEM_ERROR, "Unable to start the application " + this.getName() + " > " + e.getMessage());
            }
        }
        try {
            for (Map.Entry<Object, Object> entry : this.resourceSubscriptions.entrySet()) {
                Collection resourceSubscriptions = (Collection)entry.getValue();
                for (ResourceSubscription resourceSubscription : resourceSubscriptions) {
                    String[] uriElements = UriUtils.getUriElements((String)resourceSubscription.getResourceUri());
                    if (uriElements.length != 3) continue;
                    String subscriptionId = super.getSession().subscribe(uriElements[0], uriElements[1], uriElements[2], (Recipient)this, resourceSubscription.getConditionsAsJSONArray(), new Object[0]).getSubscriptionId();
                    resourceSubscription.setSubscriptionId(subscriptionId);
                }
            }
        }
        catch (Exception e) {
            return new AppSnaMessage("/AppManager/" + this.getName(), SnaErrorMessage.Error.SYSTEM_ERROR, "Unable to start the application " + this.getName() + " > " + e.getMessage());
        }
        return new AppSnaMessage("/AppManager/" + this.getName(), SnaErrorMessage.Error.NO_ERROR, "Application " + this.getName() + " started");
    }

    @Override
    protected SnaErrorMessage doStop() {
        for (Map.Entry<ResourceDataProvider, Collection<ResourceSubscription>> entry : this.resourceSubscriptions.entrySet()) {
            Collection<ResourceSubscription> resourceSubscriptions = entry.getValue();
            for (ResourceSubscription resourceSubscription : resourceSubscriptions) {
                DescribeResponse response;
                String[] uriElements = UriUtils.getUriElements((String)resourceSubscription.getResourceUri());
                if (uriElements.length != 3 || (response = super.getSession().getResource(uriElements[0], uriElements[1], uriElements[2])).getStatusCode() != 200) continue;
                super.getSession().unsubscribe(uriElements[0], uriElements[1], uriElements[2], resourceSubscription.getSubscriptionId(), new Object[0]);
            }
        }
        for (Map.Entry<Object, Object> entry : this.components.entrySet()) {
            try {
                ((Component)entry.getValue()).uninstantiate();
            }
            catch (LifeCycleException e) {
                return new AppSnaMessage("/AppManager/" + this.getName(), SnaErrorMessage.Error.SYSTEM_ERROR, "Unable to stop the application " + this.getName() + " > " + e.getMessage());
            }
        }
        try {
            this.actionHookQueue.uninstantiate();
        }
        catch (LifeCycleException e) {
            return new AppSnaMessage("/AppManager/" + this.getName(), SnaErrorMessage.Error.SYSTEM_ERROR, "Unable to start the application " + this.getName() + " > " + e.getMessage());
        }
        return new AppSnaMessage("/AppManager/" + this.getName(), SnaErrorMessage.Error.NO_ERROR, "Application " + this.getName() + " stopped");
    }

    public SnaErrorMessage uninstall() {
        for (ServiceRegistration<DataProviderItf> serviceRegistration : this.serviceRegistrations) {
            serviceRegistration.unregister();
        }
        return new AppSnaMessage("/AppManager/" + this.getName(), SnaErrorMessage.Error.NO_ERROR, "Application " + this.getName() + " uninstalled");
    }

    public void callback(String callbackId, SnaMessage<?>[] messages) throws Exception {
        this.waitingEvents.put(messages[0]);
        this.triggerNextEvent();
    }

    private void triggerNextEvent() throws Exception {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SnaMessage message = (SnaMessage)Application.this.waitingEvents.poll();
                    if (message == null) {
                        return;
                    }
                    JSONObject messageJson = new JSONObject(message.getJSON());
                    System.out.println(message.getJSON());
                    LOG.debug("Processing message {}", (Object)message.getJSON());
                    String[] uri = message.getPath().split("/");
                    String resourceUri = "/" + uri[1] + "/" + uri[2] + "/" + uri[3];
                    Object value = messageJson.getJSONObject("notification").get("value");
                    ResourceDataProvider dataProvider = null;
                    for (Map.Entry subscription : Application.this.resourceSubscriptions.entrySet()) {
                        if (!resourceUri.equals(((ResourceDataProvider)subscription.getKey()).getUri())) continue;
                        dataProvider = (ResourceDataProvider)subscription.getKey();
                        break;
                    }
                    if (dataProvider == null) {
                        try {
                            throw new ResourceNotFoundException("Resource " + resourceUri + " not found while triggering a new event");
                        }
                        catch (ResourceNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    ArrayList<String> sources = new ArrayList<String>();
                    sources.add(resourceUri);
                    dataProvider.updateAndNotify(new UUID(System.currentTimeMillis(), System.currentTimeMillis()), value, sources);
                    Application.this.actionHookQueue.fireHooks();
                    if (!Application.this.waitingEvents.isEmpty()) {
                        Application.this.triggerNextEvent();
                    }
                }
                catch (Exception e) {
                    Application.this.watchDog.uncaughtException(Thread.currentThread(), e);
                }
            }
        });
    }

    public Map<ResourceDataProvider, Collection<ResourceSubscription>> getResourceSubscriptions() {
        return this.resourceSubscriptions;
    }

    public Map<String, Component> getComponents() {
        return Collections.unmodifiableMap(this.components);
    }
}

