/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.model.core.provider.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.model.core.provider.Admin;
import org.eclipse.sensinact.model.core.provider.DynamicProvider;
import org.eclipse.sensinact.model.core.provider.FeatureCustomMetadata;
import org.eclipse.sensinact.model.core.provider.Metadata;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.eclipse.sensinact.model.core.provider.ProviderFactory;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.model.core.provider.ResourceType;
import org.eclipse.sensinact.model.core.provider.Service;
import org.eclipse.sensinact.model.core.provider.ValueType;
import org.eclipse.sensinact.model.core.provider.impl.AdminImpl;
import org.eclipse.sensinact.model.core.provider.impl.DynamicProviderImpl;
import org.eclipse.sensinact.model.core.provider.impl.FeatureCustomMetadataImpl;
import org.eclipse.sensinact.model.core.provider.impl.FeatureMetadataImpl;
import org.eclipse.sensinact.model.core.provider.impl.MetadataImpl;
import org.eclipse.sensinact.model.core.provider.impl.ProviderImpl;
import org.eclipse.sensinact.model.core.provider.impl.ServiceImpl;
import org.eclipse.sensinact.model.core.provider.impl.ServiceMapImpl;

public class ProviderFactoryImpl
extends EFactoryImpl
implements ProviderFactory {
    public static ProviderFactory init() {
        try {
            ProviderFactory theProviderFactory = (ProviderFactory)EPackage.Registry.INSTANCE.getEFactory("https://eclipse.org/sensinact/core/provider/1.0");
            if (theProviderFactory != null) {
                return theProviderFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ProviderFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createProvider();
            }
            case 1: {
                return this.createAdmin();
            }
            case 2: {
                return this.createService();
            }
            case 3: {
                return this.createMetadata();
            }
            case 4: {
                return (EObject)this.createFeatureMetadata();
            }
            case 5: {
                return this.createFeatureCustomMetadata();
            }
            case 6: {
                return (EObject)this.createServiceMap();
            }
            case 7: {
                return this.createDynamicProvider();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createResourceTypeFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createValueTypeFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createEGeoJsonObjectFromString(eDataType, initialValue);
            }
            case 11: {
                return this.createEInstantFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertResourceTypeToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertValueTypeToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertEGeoJsonObjectToString(eDataType, instanceValue);
            }
            case 11: {
                return this.convertEInstantToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Provider createProvider() {
        ProviderImpl provider = new ProviderImpl();
        return provider;
    }

    @Override
    public Admin createAdmin() {
        AdminImpl admin = new AdminImpl();
        return admin;
    }

    @Override
    public Service createService() {
        ServiceImpl service = new ServiceImpl();
        return service;
    }

    @Override
    public Metadata createMetadata() {
        MetadataImpl metadata = new MetadataImpl();
        return metadata;
    }

    public Map.Entry<ETypedElement, Metadata> createFeatureMetadata() {
        FeatureMetadataImpl featureMetadata = new FeatureMetadataImpl();
        return featureMetadata;
    }

    @Override
    public FeatureCustomMetadata createFeatureCustomMetadata() {
        FeatureCustomMetadataImpl featureCustomMetadata = new FeatureCustomMetadataImpl();
        return featureCustomMetadata;
    }

    public Map.Entry<String, Service> createServiceMap() {
        ServiceMapImpl serviceMap = new ServiceMapImpl();
        return serviceMap;
    }

    @Override
    public DynamicProvider createDynamicProvider() {
        DynamicProviderImpl dynamicProvider = new DynamicProviderImpl();
        return dynamicProvider;
    }

    public ResourceType createResourceTypeFromString(EDataType eDataType, String initialValue) {
        ResourceType result = ResourceType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertResourceTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ValueType createValueTypeFromString(EDataType eDataType, String initialValue) {
        ValueType result = ValueType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertValueTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public GeoJsonObject createEGeoJsonObject(String it) {
        try {
            return (GeoJsonObject)new ObjectMapper().readValue(it, GeoJsonObject.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public GeoJsonObject createEGeoJsonObjectFromString(EDataType eDataType, String initialValue) {
        return this.createEGeoJsonObject(initialValue);
    }

    public String convertEGeoJsonObject(GeoJsonObject it) {
        try {
            return new ObjectMapper().writeValueAsString((Object)it);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String convertEGeoJsonObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertEGeoJsonObject((GeoJsonObject)instanceValue);
    }

    public Instant createEInstant(String it) {
        return Instant.parse(it);
    }

    public Instant createEInstantFromString(EDataType eDataType, String initialValue) {
        return this.createEInstant(initialValue);
    }

    public String convertEInstant(Instant it) {
        return it.toString();
    }

    public String convertEInstantToString(EDataType eDataType, Object instanceValue) {
        return this.convertEInstant((Instant)instanceValue);
    }

    @Override
    public ProviderPackage getProviderPackage() {
        return (ProviderPackage)this.getEPackage();
    }

    @Deprecated
    public static ProviderPackage getPackage() {
        return ProviderPackage.eINSTANCE;
    }
}

