/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.RootResponse;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;

@Produces(value={"application/json"})
@Path(value="/v1.1")
public interface RootResourceAccess {
    @GET
    default public RootResponse getRootResponse(@Context UriInfo info) {
        RootResponse response = new RootResponse();
        response.serverSettings = new RootResponse.ServerSettings();
        response.serverSettings.conformance = List.of("http://www.opengis.net/spec/iot_sensing/1.1/req/datamodel", "http://www.opengis.net/spec/iot_sensing/1.1/req/resource-path", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/order", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/select", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/status-code", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/query-status-code", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/orderby", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/top", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/skip", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/pagination", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/count", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/filter", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/built-in-filter-operations", "http://www.opengis.net/spec/iot_sensing/1.1/req/request-data/built-in-query-functions");
        response.value = List.of(RootResponse.NameUrl.create((String)"Things", (String)info.getAbsolutePathBuilder().path("Things").toString()), RootResponse.NameUrl.create((String)"Locations", (String)info.getAbsolutePathBuilder().path("Locations").toString()), RootResponse.NameUrl.create((String)"HistoricalLocations", (String)info.getAbsolutePathBuilder().path("HistoricalLocations").toString()), RootResponse.NameUrl.create((String)"Datastreams", (String)info.getAbsolutePathBuilder().path("Datastreams").toString()), RootResponse.NameUrl.create((String)"Sensors", (String)info.getAbsolutePathBuilder().path("Sensors").toString()), RootResponse.NameUrl.create((String)"Observations", (String)info.getAbsolutePathBuilder().path("Observations").toString()), RootResponse.NameUrl.create((String)"ObservedProperties", (String)info.getAbsolutePathBuilder().path("ObservedProperties").toString()), RootResponse.NameUrl.create((String)"FeaturesOfInterest", (String)info.getAbsolutePathBuilder().path("FeaturesOfInterest").toString()));
        return response;
    }

    @GET
    @Path(value="Things")
    public ResultList<Thing> getThings();

    @GET
    @Path(value="Locations")
    public ResultList<Location> getLocations();

    @GET
    @Path(value="HistoricalLocations")
    public ResultList<HistoricalLocation> getHistoricalLocations();

    @GET
    @Path(value="Datastreams")
    public ResultList<Datastream> getDatastreams();

    @GET
    @Path(value="Sensors")
    public ResultList<Sensor> getSensors();

    @GET
    @Path(value="Observations")
    public ResultList<Observation> getObservations();

    @GET
    @Path(value="ObservedProperties")
    public ResultList<ObservedProperty> getObservedProperties();

    @GET
    @Path(value="FeaturesOfInterest")
    public ResultList<FeatureOfInterest> getFeaturesOfInterest();
}

