/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.jakartawrappers;

import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionEvent;
import java.util.EventListener;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.base.internal.javaxwrappers.HttpSessionWrapper;
import org.apache.felix.http.base.internal.javaxwrappers.ServletContextWrapper;
import org.apache.felix.http.base.internal.javaxwrappers.ServletRequestWrapper;
import org.jetbrains.annotations.NotNull;

public class EventListenerWrapper
implements jakarta.servlet.http.HttpSessionAttributeListener,
jakarta.servlet.http.HttpSessionIdListener,
jakarta.servlet.http.HttpSessionListener,
ServletContextListener,
ServletContextAttributeListener,
jakarta.servlet.ServletRequestListener,
ServletRequestAttributeListener {
    private final HttpSessionAttributeListener httpSessionAttributeListener;
    private final HttpSessionIdListener httpSessionIdListener;
    private final HttpSessionListener httpSessionListener;
    private final javax.servlet.ServletContextListener servletContextListener;
    private final javax.servlet.ServletContextAttributeListener servletContextAttributeListener;
    private final ServletRequestListener servletRequestListener;
    private final javax.servlet.ServletRequestAttributeListener servletRequestAttributeListener;
    private final EventListener listener;

    public EventListenerWrapper(@NotNull EventListener listener, @NotNull Set<String> listenerTypes) {
        this.listener = listener;
        this.httpSessionAttributeListener = listenerTypes.contains(jakarta.servlet.http.HttpSessionAttributeListener.class.getName()) ? (HttpSessionAttributeListener)listener : null;
        this.httpSessionIdListener = listenerTypes.contains(jakarta.servlet.http.HttpSessionIdListener.class.getName()) ? (HttpSessionIdListener)listener : null;
        this.httpSessionListener = listenerTypes.contains(jakarta.servlet.http.HttpSessionListener.class.getName()) ? (HttpSessionListener)listener : null;
        this.servletContextListener = listenerTypes.contains(ServletContextListener.class.getName()) ? (javax.servlet.ServletContextListener)listener : null;
        this.servletContextAttributeListener = listenerTypes.contains(ServletContextAttributeListener.class.getName()) ? (javax.servlet.ServletContextAttributeListener)listener : null;
        this.servletRequestListener = listenerTypes.contains(jakarta.servlet.ServletRequestListener.class.getName()) ? (ServletRequestListener)listener : null;
        this.servletRequestAttributeListener = listenerTypes.contains(ServletRequestAttributeListener.class.getName()) ? (javax.servlet.ServletRequestAttributeListener)listener : null;
    }

    public void attributeAdded(jakarta.servlet.ServletRequestAttributeEvent srae) {
        if (this.servletRequestAttributeListener != null) {
            this.servletRequestAttributeListener.attributeAdded(new ServletRequestAttributeEvent((ServletContext)new ServletContextWrapper(srae.getServletContext()), ServletRequestWrapper.getWrapper(srae.getServletRequest()), srae.getName(), srae.getValue()));
        }
    }

    public void attributeRemoved(jakarta.servlet.ServletRequestAttributeEvent srae) {
        if (this.servletRequestAttributeListener != null) {
            this.servletRequestAttributeListener.attributeRemoved(new ServletRequestAttributeEvent((ServletContext)new ServletContextWrapper(srae.getServletContext()), ServletRequestWrapper.getWrapper(srae.getServletRequest()), srae.getName(), srae.getValue()));
        }
    }

    public void attributeReplaced(jakarta.servlet.ServletRequestAttributeEvent srae) {
        if (this.servletRequestAttributeListener != null) {
            this.servletRequestAttributeListener.attributeReplaced(new ServletRequestAttributeEvent((ServletContext)new ServletContextWrapper(srae.getServletContext()), ServletRequestWrapper.getWrapper(srae.getServletRequest()), srae.getName(), srae.getValue()));
        }
    }

    public void requestDestroyed(jakarta.servlet.ServletRequestEvent sre) {
        if (this.servletRequestListener != null) {
            this.servletRequestListener.requestDestroyed(new ServletRequestEvent((ServletContext)new ServletContextWrapper(sre.getServletContext()), ServletRequestWrapper.getWrapper(sre.getServletRequest())));
        }
    }

    public void requestInitialized(jakarta.servlet.ServletRequestEvent sre) {
        if (this.servletRequestListener != null) {
            this.servletRequestListener.requestInitialized(new ServletRequestEvent((ServletContext)new ServletContextWrapper(sre.getServletContext()), ServletRequestWrapper.getWrapper(sre.getServletRequest())));
        }
    }

    public void attributeAdded(jakarta.servlet.ServletContextAttributeEvent event) {
        if (this.servletContextAttributeListener != null) {
            this.servletContextAttributeListener.attributeAdded(new ServletContextAttributeEvent((ServletContext)new ServletContextWrapper(event.getServletContext()), event.getName(), event.getValue()));
        }
    }

    public void attributeRemoved(jakarta.servlet.ServletContextAttributeEvent event) {
        if (this.servletContextAttributeListener != null) {
            this.servletContextAttributeListener.attributeRemoved(new ServletContextAttributeEvent((ServletContext)new ServletContextWrapper(event.getServletContext()), event.getName(), event.getValue()));
        }
    }

    public void attributeReplaced(jakarta.servlet.ServletContextAttributeEvent event) {
        if (this.servletContextAttributeListener != null) {
            this.servletContextAttributeListener.attributeReplaced(new ServletContextAttributeEvent((ServletContext)new ServletContextWrapper(event.getServletContext()), event.getName(), event.getValue()));
        }
    }

    public void contextInitialized(jakarta.servlet.ServletContextEvent sce) {
        if (this.servletContextListener != null) {
            this.servletContextListener.contextInitialized(new ServletContextEvent((ServletContext)new ServletContextWrapper(sce.getServletContext())));
        }
    }

    public void contextDestroyed(jakarta.servlet.ServletContextEvent sce) {
        if (this.servletContextListener != null) {
            this.servletContextListener.contextDestroyed(new ServletContextEvent((ServletContext)new ServletContextWrapper(sce.getServletContext())));
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        if (this.httpSessionListener != null) {
            this.httpSessionListener.sessionCreated(new javax.servlet.http.HttpSessionEvent((HttpSession)new HttpSessionWrapper(se.getSession())));
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        if (this.httpSessionListener != null) {
            this.httpSessionListener.sessionDestroyed(new javax.servlet.http.HttpSessionEvent((HttpSession)new HttpSessionWrapper(se.getSession())));
        }
    }

    public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
        if (this.httpSessionIdListener != null) {
            this.httpSessionIdListener.sessionIdChanged(new javax.servlet.http.HttpSessionEvent((HttpSession)new HttpSessionWrapper(event.getSession())), oldSessionId);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (this.httpSessionAttributeListener != null) {
            this.httpSessionAttributeListener.attributeAdded(new javax.servlet.http.HttpSessionBindingEvent((HttpSession)new HttpSessionWrapper(event.getSession()), event.getName(), event.getValue()));
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (this.httpSessionAttributeListener != null) {
            this.httpSessionAttributeListener.attributeRemoved(new javax.servlet.http.HttpSessionBindingEvent((HttpSession)new HttpSessionWrapper(event.getSession()), event.getName(), event.getValue()));
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (this.httpSessionAttributeListener != null) {
            this.httpSessionAttributeListener.attributeReplaced(new javax.servlet.http.HttpSessionBindingEvent((HttpSession)new HttpSessionWrapper(event.getSession()), event.getName(), event.getValue()));
        }
    }

    @NotNull
    public EventListener getListener() {
        return this.listener;
    }
}

