/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.rest.integration.notification;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.sse.SseEventSource;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.northbound.query.dto.notification.ResourceDataNotificationDTO;
import org.eclipse.sensinact.northbound.query.dto.notification.ResourceLifecycleNotificationDTO;
import org.eclipse.sensinact.northbound.rest.integration.TestUtils;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import org.osgi.service.cm.Configuration;
import org.osgi.service.jakartars.client.SseEventSourceFactory;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.InjectConfiguration;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.service.ServiceAware;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
public class ResourceNotificationsTest {
    private static final UserInfo USER = UserInfo.ANONYMOUS;
    private static final String PROVIDER = "RestNotificationProvider";
    private static final String PROVIDER_TOPIC = "RestNotificationProvider/RestNotificationProvider/*";
    @InjectService
    protected SseEventSourceFactory sseClient;
    @InjectService
    SensiNactSessionManager sessionManager;
    @InjectService
    DataUpdate push;
    @InjectService
    ClientBuilder clientBuilder;
    BlockingQueue<ResourceDataNotification> queue;
    final TestUtils utils = new TestUtils();

    @BeforeEach
    public void await(@InjectConfiguration(withConfig=@WithConfiguration(pid="sensinact.northbound.rest", location="?", properties={@Property(key="allow.anonymous", value={"true"}), @Property(key="buzz", value={"fizzbuzz"})})) Configuration cm, @InjectService(filter="(buzz=fizzbuzz)", cardinality=0) ServiceAware<Application> a) throws InterruptedException {
        a.waitForService(5000L);
        for (int i = 0; i < 10; ++i) {
            try {
                if (this.utils.queryStatus("/").statusCode() == 200) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.sleep(200L);
        }
        throw new AssertionFailedError("REST API did not appear");
    }

    @BeforeEach
    void start() throws InterruptedException {
        this.queue = new ArrayBlockingQueue<ResourceDataNotification>(32);
        SensiNactSession session = this.sessionManager.getDefaultSession(USER);
        session.addListener(List.of(PROVIDER_TOPIC), (t, e) -> this.queue.offer(e), null, null, null);
        Assertions.assertNull((Object)this.queue.poll(500L, TimeUnit.MILLISECONDS));
    }

    @AfterEach
    void stop() {
        SensiNactSession session = this.sessionManager.getDefaultSession(USER);
        session.activeListeners().keySet().forEach(arg_0 -> ((SensiNactSession)session).removeListener(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void resourceNotificationNonExistent() throws Exception {
        String service = "new";
        String resource = "new-resource";
        Client client = ((ClientBuilder)this.clientBuilder.connectTimeout(3L, TimeUnit.SECONDS).register(JacksonJsonProvider.class)).build();
        SseEventSource sseSource = this.sseClient.newSource(client.target("http://localhost:8185/sensinact/").path("providers").path(PROVIDER).path("services").path("new").path("resources").path("new-resource").path("SUBSCRIBE"));
        BlockingArrayQueue lifeCycleEvents = new BlockingArrayQueue();
        BlockingArrayQueue dataEvents = new BlockingArrayQueue();
        sseSource.register(ise -> {
            switch (ise.getName()) {
                case "lifecycle": {
                    lifeCycleEvents.add((Object)((ResourceLifecycleNotificationDTO)ise.readData(ResourceLifecycleNotificationDTO.class)));
                    break;
                }
                case "data": {
                    dataEvents.add((Object)((ResourceDataNotificationDTO)ise.readData(ResourceDataNotificationDTO.class)));
                    break;
                }
            }
        });
        sseSource.open();
        try {
            int initialValue = 42;
            GenericDto dto = this.utils.makeDto(PROVIDER, "new", "new-resource", initialValue, Integer.class);
            this.push.pushUpdate((Object)dto);
            ResourceDataNotification friendlyName = this.queue.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)friendlyName);
            Assertions.assertEquals((Object)ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName(), (Object)friendlyName.resource, (String)"First event was not FriendlyName, so the Provider already exists. It is likely that the data folder wasn't cleared and this is a remnant of a previous testrun.");
            Assertions.assertNotNull((Object)this.queue.poll(1L, TimeUnit.SECONDS));
            Assertions.assertNotNull((Object)this.queue.poll(1L, TimeUnit.SECONDS));
            ResourceDataNotification localNotif = this.queue.poll(2L, TimeUnit.SECONDS);
            this.utils.assertNotification(dto, localNotif);
            ResourceLifecycleNotificationDTO lifeCycleNotif = (ResourceLifecycleNotificationDTO)lifeCycleEvents.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)lifeCycleNotif);
            Assertions.assertEquals((Object)PROVIDER, (Object)lifeCycleNotif.provider);
            Assertions.assertEquals((Object)dto.service, (Object)lifeCycleNotif.service);
            Assertions.assertEquals((Object)dto.resource, (Object)lifeCycleNotif.resource);
            Assertions.assertEquals((Object)LifecycleNotification.Status.RESOURCE_CREATED, (Object)lifeCycleNotif.status);
            Assertions.assertFalse((boolean)localNotif.timestamp.isAfter(Instant.ofEpochMilli(lifeCycleNotif.timestamp)), (String)"Lifecycle timestamp is too early");
            ResourceDataNotificationDTO dataNotif = (ResourceDataNotificationDTO)dataEvents.poll(500L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)dataNotif);
            Assertions.assertEquals((Object)PROVIDER, (Object)dataNotif.provider);
            Assertions.assertEquals((Object)dto.service, (Object)dataNotif.service);
            Assertions.assertEquals((Object)dto.resource, (Object)dataNotif.resource);
            Assertions.assertNull((Object)dataNotif.oldValue, (String)"Old value is not null");
            Assertions.assertEquals((Object)dto.value, (Object)dataNotif.newValue);
            Assertions.assertEquals((long)localNotif.timestamp.toEpochMilli(), (long)dataNotif.timestamp);
            dto.value = initialValue + 10;
            this.push.pushUpdate((Object)dto);
            localNotif = this.queue.poll(1L, TimeUnit.SECONDS);
            this.utils.assertNotification(dto, localNotif);
            dataNotif = (ResourceDataNotificationDTO)dataEvents.poll(500L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)dataNotif);
            Assertions.assertEquals((Object)PROVIDER, (Object)dataNotif.provider);
            Assertions.assertEquals((Object)dto.service, (Object)dataNotif.service);
            Assertions.assertEquals((Object)dto.resource, (Object)dataNotif.resource);
            Assertions.assertEquals((Object)initialValue, (Object)dataNotif.oldValue);
            Assertions.assertEquals((Object)dto.value, (Object)dataNotif.newValue);
            Assertions.assertEquals((long)localNotif.timestamp.toEpochMilli(), (long)dataNotif.timestamp);
            Assertions.assertNull((Object)lifeCycleEvents.poll());
        }
        finally {
            sseSource.close();
        }
    }
}

