/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.test;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.core.InvalidServiceProviderException;
import org.eclipse.sensinact.gateway.core.security.dao.AuthenticatedDAO;
import org.eclipse.sensinact.gateway.core.security.dao.BundleDAO;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.dao.ObjectAccessDAO;
import org.eclipse.sensinact.gateway.core.security.dao.ObjectDAO;
import org.eclipse.sensinact.gateway.core.security.dao.UserDAO;
import org.eclipse.sensinact.gateway.core.security.entity.BundleEntity;
import org.eclipse.sensinact.gateway.core.security.entity.ImmutableSnaEntity;
import org.eclipse.sensinact.gateway.core.security.entity.ObjectAccessEntity;
import org.eclipse.sensinact.gateway.core.security.entity.ObjectEntity;
import org.eclipse.sensinact.gateway.core.security.entity.SnaEntity;
import org.eclipse.sensinact.gateway.core.security.entity.UserEntity;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;
import org.eclipse.sensinact.gateway.datastore.api.UnableToConnectToDataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.UnableToFindDataStoreException;
import org.eclipse.sensinact.gateway.datastore.sqlite.SQLiteDataStoreService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class TestDAO {
    private static final String LOG_FILTER = "(objectClass=" + LogService.class.getCanonicalName() + ")";
    private static final String DATA_STORE_FILTER = "(objectClass=" + DataStoreService.class.getCanonicalName() + ")";
    private static final String MOCK_BUNDLE_NAME = "MockedBundle";
    private static final long MOCK_BUNDLE_ID = 1L;
    private final Filter filterDataStore = (Filter)Mockito.mock(Filter.class);
    private final BundleContext context = (BundleContext)Mockito.mock(BundleContext.class);
    private final Bundle bundle = (Bundle)Mockito.mock(Bundle.class);
    private final ServiceReference<?> referenceDataStoreService = (ServiceReference)Mockito.mock(ServiceReference.class);
    private SQLiteDataStoreService dataStoreService;
    private File tempDB;

    @BeforeEach
    public void init() throws InvalidServiceProviderException, UnableToFindDataStoreException, UnableToConnectToDataStoreException, InvalidSyntaxException, IOException {
        Filter filter = (Filter)Mockito.mock(Filter.class);
        Mockito.when((Object)filter.toString()).thenReturn((Object)LOG_FILTER);
        Mockito.when((Object)this.context.createFilter(LOG_FILTER)).thenReturn((Object)filter);
        Mockito.when((Object)this.context.getServiceReferences((String)Mockito.eq(null), (String)Mockito.eq((Object)LOG_FILTER))).thenReturn(null);
        Mockito.when((Object)this.context.getServiceReference(LOG_FILTER)).thenReturn(null);
        Mockito.when((Object)this.context.createFilter(DATA_STORE_FILTER)).thenReturn((Object)this.filterDataStore);
        Mockito.when((Object)this.filterDataStore.toString()).thenReturn((Object)DATA_STORE_FILTER);
        Mockito.when((Object)this.context.getServiceReferences(Mockito.anyString(), Mockito.anyString())).then((Answer)new Answer<ServiceReference<?>[]>(){

            public ServiceReference<?>[] answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                if (arguments == null || arguments.length != 2) {
                    return null;
                }
                if (arguments[0] != null && arguments[0].equals(DataStoreService.class.getCanonicalName())) {
                    return new ServiceReference[]{TestDAO.this.referenceDataStoreService};
                }
                return null;
            }
        });
        Mockito.when((Object)this.context.getServiceReferences((Class)Mockito.any(Class.class), Mockito.anyString())).then(new Answer<Collection<ServiceReference<?>>>(){

            public Collection<ServiceReference<?>> answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                if (arguments == null || arguments.length != 2) {
                    return null;
                }
                if (arguments[0] != null && arguments[0].equals(DataStoreService.class)) {
                    return Collections.singleton(TestDAO.this.referenceDataStoreService);
                }
                return Collections.emptyList();
            }
        });
        Mockito.when((Object)this.context.getService((ServiceReference)Mockito.any(ServiceReference.class))).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                if (arguments == null || arguments.length != 1) {
                    return null;
                }
                if (arguments[0] == TestDAO.this.referenceDataStoreService) {
                    return TestDAO.this.dataStoreService;
                }
                return null;
            }
        });
        Mockito.when((Object)this.context.getBundle()).thenReturn((Object)this.bundle);
        Mockito.when((Object)this.bundle.getSymbolicName()).thenReturn((Object)MOCK_BUNDLE_NAME);
        Mockito.when((Object)this.bundle.getBundleId()).thenReturn((Object)1L);
        Mockito.when((Object)this.bundle.getState()).thenReturn((Object)32);
        Mockito.when((Object)this.bundle.getResource(Mockito.anyString())).thenAnswer((Answer)new Answer<URL>(){

            public URL answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                if (arguments == null || arguments.length != 1) {
                    return null;
                }
                if (arguments[0].equals("script/getObjectFromPath.sql")) {
                    return new File("src/main/resources/script/getObjectFromPath.sql").getAbsoluteFile().toURI().toURL();
                }
                if (arguments[0].equals("script/getMethodAccessibilities.sql")) {
                    return new File("src/main/resources/script/getMethodAccessibilities.sql").getAbsoluteFile().toURI().toURL();
                }
                return null;
            }
        });
        this.tempDB = File.createTempFile("test", ".sqlite");
        this.tempDB.deleteOnExit();
        String dbPath = FrameworkUtil.getBundle(this.getClass()).getBundleContext().getProperty("sqlitedb");
        Path copied = this.tempDB.toPath();
        Path originalPath = Paths.get(dbPath, new String[0]);
        System.err.println("orignal - " + originalPath.toFile().getAbsolutePath());
        Files.copy(originalPath, copied, StandardCopyOption.REPLACE_EXISTING);
        SQLiteDataStoreService.SQLiteConfig sqlLiteConfig = (SQLiteDataStoreService.SQLiteConfig)Mockito.mock(SQLiteDataStoreService.SQLiteConfig.class);
        Mockito.when((Object)sqlLiteConfig.database()).thenReturn((Object)this.tempDB.getAbsolutePath());
        this.dataStoreService = new SQLiteDataStoreService();
        this.dataStoreService.start(sqlLiteConfig);
    }

    @AfterEach
    public void after() {
        this.tempDB.delete();
    }

    @Test
    public void testSelectUserDAO() throws DAOException, DataStoreException {
        UserDAO userDAO = new UserDAO((DataStoreService)this.dataStoreService);
        List userEntities = userDAO.select();
        int index = 0;
        String[][] users = new String[][]{{"anonymous", "ANONYMOUS", "294de3557d9d0b3d2d8a1e6aab028cf", "anonymous"}, {"christophe.munilla@cea.fr", "cea", "ac0dad7d2c39119f9d7d76d34303ec85", "73c5f1a1e7b4a75c2b5fabafca2cf51e6b0e7426"}, {"fake@cea.fr", "fake", "144c9defac04969c7bfad8efaa8ea194", "f92fe92b61e018be14a88ab84f2859c35d832316"}, {"fake2@cea.fr", "fake2", "503f7fada600da935e2851a1c7326084", "31e63e9c4a319bf313b8a6d454798e09b3e7344a"}};
        for (UserEntity userEntity : userEntities) {
            Assertions.assertTrue((index == (int)userEntity.getIdentifier() ? 1 : 0) != 0);
            String[] user = users[index++];
            Assertions.assertTrue((boolean)userEntity.getAccount().equals(user[0]));
            Assertions.assertTrue((boolean)userEntity.getLogin().equals(user[1]));
            Assertions.assertTrue((boolean)userEntity.getPassword().equals(user[2]));
            Assertions.assertTrue((boolean)userEntity.getPublicKey().equals(user[3]));
        }
    }

    @Test
    public void testSelectObjectDAO() throws DAOException, DataStoreException {
        ObjectDAO objectDAO = new ObjectDAO((DataStoreService)this.dataStoreService);
        Object[][] objects = new Object[][]{{6, 5, "/slider/cursor/position", 3, "position", 1}, {4, 3, "/slider/[^/]+/location", 3, "location", 1}, {5, 2, "/slider/cursor", 3, "cursor", 1}};
        String[] paths = new String[]{"/slider/cursor/position", "/slider/cursor/location", "/slider/cursor/fake"};
        for (int index = 0; index < 3; ++index) {
            String path = paths[index];
            Object[] object = objects[index];
            List objectEntities = objectDAO.find(path);
            ObjectEntity objectEntity = (ObjectEntity)objectEntities.get(0);
            Assertions.assertEquals((long)((Integer)object[0]).longValue(), (long)objectEntity.getIdentifier());
            Assertions.assertEquals((long)((Integer)object[1]).longValue(), (long)objectEntity.getParent());
            Assertions.assertEquals((Object)object[2], (Object)objectEntity.getPath());
            Assertions.assertEquals((long)((Integer)object[3]).longValue(), (long)objectEntity.getBundleEntity());
            Assertions.assertEquals((Object)object[4], (Object)objectEntity.getName());
            Assertions.assertEquals((long)((Integer)object[5]).longValue(), (long)objectEntity.getObjectProfileEntity());
        }
    }

    @Test
    public void testSelectExactObjectDAO() throws DAOException, DataStoreException {
        ObjectDAO objectDAO = new ObjectDAO((DataStoreService)this.dataStoreService);
        String[] paths = new String[]{"/slider/cursor/position", "/slider/cursor/location", "/slider/cursor/fake"};
        String[] resultingPaths = new String[]{"/slider/cursor/position", "/slider/[^/]+/location", "/slider/cursor"};
        block4: for (int index = 0; index < 3; ++index) {
            String path = paths[index];
            String resultingPath = resultingPaths[index];
            List objectEntities = objectDAO.find(path, true);
            ObjectEntity objectEntity = objectEntities.isEmpty() ? null : (ObjectEntity)objectEntities.get(0);
            switch (index) {
                case 0: 
                case 1: {
                    Assertions.assertTrue((boolean)objectEntity.getPath().equals(resultingPath));
                    continue block4;
                }
                case 2: {
                    Assertions.assertTrue((objectEntity == null ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testSelectObjectChildren() throws DAOException, DataStoreException {
        ObjectDAO objectDAO = new ObjectDAO((DataStoreService)this.dataStoreService);
        List list = objectDAO.findChildren(2L);
        Assertions.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((((ObjectEntity)list.get(0)).getIdentifier() == 3L ? 1 : 0) != 0);
        Assertions.assertTrue((((ObjectEntity)list.get(1)).getIdentifier() == 5L ? 1 : 0) != 0);
    }

    @Test
    public void testFakePredefinedSelectStatement() throws DAOException, DataStoreException, MalformedURLException {
        URL url = FrameworkUtil.getBundle(TestDAO.class).getResource("script/fake.sql");
        ObjectDAO objectDAO = new ObjectDAO((DataStoreService)this.dataStoreService, url);
        List list = objectDAO.select("getObjectFromPath", new String[]{"/slider/cursor/position"});
        Assertions.assertEquals((int)15, (int)list.size());
    }

    @Test
    public void testImmutableCreate() throws DAOException {
        ObjectAccessDAO objectAccessDAO = new ObjectAccessDAO((DataStoreService)this.dataStoreService);
        ObjectAccessEntity entity = new ObjectAccessEntity("FAKE", 12);
        Assertions.assertThrows(DAOException.class, () -> objectAccessDAO.create((ImmutableSnaEntity)entity));
    }

    @Test
    public void testImmutableDelete() throws DAOException, DataStoreException {
        ObjectAccessDAO objectAccessDAO = new ObjectAccessDAO((DataStoreService)this.dataStoreService);
        ObjectAccessEntity entity = objectAccessDAO.find(1L);
        Assertions.assertThrows(DAOException.class, () -> objectAccessDAO.delete((ImmutableSnaEntity)entity));
    }

    @Test
    public void testImmutableUpdate() throws DAOException, DataStoreException {
        ObjectAccessDAO objectAccessDAO = new ObjectAccessDAO((DataStoreService)this.dataStoreService);
        ObjectAccessEntity entity = objectAccessDAO.find(1L);
        entity.setLevel(10);
        Assertions.assertThrows(DAOException.class, () -> objectAccessDAO.update((ImmutableSnaEntity)entity));
    }

    @Test
    public void testImmutableSelect() throws DAOException, DataStoreException {
        ObjectAccessDAO objectAccessDAO = new ObjectAccessDAO((DataStoreService)this.dataStoreService);
        ObjectAccessEntity entity = objectAccessDAO.find(1L);
        Assertions.assertTrue((1L == entity.getIdentifier() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)"Anonymous".equals(entity.getName()));
        Assertions.assertTrue((1 == entity.getLevel() ? 1 : 0) != 0);
    }

    @Test
    public void testMutable() throws DAOException, DataStoreException {
        ObjectDAO objectDAO = new ObjectDAO((DataStoreService)this.dataStoreService);
        ObjectEntity entity = new ObjectEntity(2L, 2L, "admin", 0, 1, 2L, null);
        objectDAO.create((SnaEntity)entity);
        long identifier = entity.getIdentifier();
        Assertions.assertTrue((identifier > 0L ? 1 : 0) != 0);
        entity = (ObjectEntity)objectDAO.select(entity.getKeys());
        Assertions.assertTrue((identifier == entity.getIdentifier() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)"admin".equals(entity.getName()));
        entity.setName("administration");
        objectDAO.update((SnaEntity)entity);
        entity = (ObjectEntity)objectDAO.select(entity.getKeys());
        Assertions.assertTrue((identifier == entity.getIdentifier() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)"administration".equals(entity.getName()));
        Assertions.assertTrue((boolean)"/slider/administration".equals(entity.getPath()));
        objectDAO.delete((SnaEntity)entity);
    }

    @Test
    public void testDeleteParentObject() throws DAOException, DataStoreException {
        ObjectDAO objectDAO = new ObjectDAO((DataStoreService)this.dataStoreService);
        ObjectEntity entity = new ObjectEntity(2L, 1L, "fake", 0, 0, 0L, null);
        objectDAO.create((SnaEntity)entity);
        long identifier = entity.getIdentifier();
        Assertions.assertTrue((identifier > 0L ? 1 : 0) != 0);
        ObjectEntity newEntity = new ObjectEntity(2L, 2L, "admin", 0, 1, identifier, null);
        objectDAO.create((SnaEntity)newEntity);
        long newIdentifier = newEntity.getIdentifier();
        Assertions.assertTrue((newIdentifier > 0L ? 1 : 0) != 0);
        ObjectEntity otherEntity = new ObjectEntity(2L, 1L, "service", 0, 1, identifier, null);
        objectDAO.create((SnaEntity)otherEntity);
        long otherIdentifier = otherEntity.getIdentifier();
        Assertions.assertTrue((otherIdentifier > 0L ? 1 : 0) != 0);
        ObjectEntity lastEntity = new ObjectEntity(2L, 1L, "resource", 0, 1, otherIdentifier, null);
        objectDAO.create((SnaEntity)lastEntity);
        long lastIdentifier = lastEntity.getIdentifier();
        Assertions.assertTrue((lastIdentifier > 0L ? 1 : 0) != 0);
        objectDAO.delete((SnaEntity)entity);
        newEntity = (ObjectEntity)objectDAO.select(newEntity.getKeys());
        Assertions.assertNull((Object)newEntity);
        AuthenticatedDAO authenticatedDAO = new AuthenticatedDAO((DataStoreService)this.dataStoreService);
        List entities = authenticatedDAO.select(Collections.singletonMap("OID", lastIdentifier));
        Assertions.assertTrue((boolean)entities.isEmpty());
        entities = authenticatedDAO.select(Collections.singletonMap("OID", otherIdentifier));
        Assertions.assertTrue((boolean)entities.isEmpty());
        entities = authenticatedDAO.select(Collections.singletonMap("OID", newIdentifier));
        Assertions.assertTrue((boolean)entities.isEmpty());
        entities = authenticatedDAO.select(Collections.singletonMap("OID", identifier));
        Assertions.assertTrue((boolean)entities.isEmpty());
    }

    @Test
    public void testDeleteBundle() throws DAOException, DataStoreException {
        BundleDAO bundleDAO = new BundleDAO((DataStoreService)this.dataStoreService);
        BundleEntity bundleEntity = new BundleEntity("fake-bundle", "fake-bundle", 0, 1L);
        bundleDAO.create((SnaEntity)bundleEntity);
        ObjectDAO objectDAO = new ObjectDAO((DataStoreService)this.dataStoreService);
        ObjectEntity entity = new ObjectEntity(bundleEntity.getIdentifier(), 1L, "fake", 0, 0, 0L, null);
        objectDAO.create((SnaEntity)entity);
        long identifier = entity.getIdentifier();
        Assertions.assertTrue((identifier > 0L ? 1 : 0) != 0);
        ObjectEntity newEntity = new ObjectEntity(2L, 2L, "admin", 0, 1, identifier, null);
        objectDAO.create((SnaEntity)newEntity);
        long newIdentifier = newEntity.getIdentifier();
        Assertions.assertTrue((newIdentifier > 0L ? 1 : 0) != 0);
        ObjectEntity otherEntity = new ObjectEntity(2L, 1L, "service", 0, 1, identifier, null);
        objectDAO.create((SnaEntity)otherEntity);
        long otherIdentifier = otherEntity.getIdentifier();
        Assertions.assertTrue((otherIdentifier > 0L ? 1 : 0) != 0);
        ObjectEntity lastEntity = new ObjectEntity(2L, 1L, "resource", 0, 1, otherIdentifier, null);
        objectDAO.create((SnaEntity)lastEntity);
        long lastIdentifier = lastEntity.getIdentifier();
        Assertions.assertTrue((lastIdentifier > 0L ? 1 : 0) != 0);
        bundleDAO.delete((SnaEntity)bundleEntity);
        AuthenticatedDAO authenticatedDAO = new AuthenticatedDAO((DataStoreService)this.dataStoreService);
        List entities = authenticatedDAO.select(Collections.singletonMap("OID", lastIdentifier));
        Assertions.assertTrue((boolean)entities.isEmpty());
        entities = authenticatedDAO.select(Collections.singletonMap("OID", otherIdentifier));
        Assertions.assertTrue((boolean)entities.isEmpty());
        entities = authenticatedDAO.select(Collections.singletonMap("OID", newIdentifier));
        Assertions.assertTrue((boolean)entities.isEmpty());
        entities = authenticatedDAO.select(Collections.singletonMap("OID", identifier));
        Assertions.assertTrue((boolean)entities.isEmpty());
    }
}

