/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.eclipse.sensinact.gateway.core.AnonymousSession;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.security.dao.UserDAO;
import org.eclipse.sensinact.gateway.core.security.entity.SnaEntity;
import org.eclipse.sensinact.gateway.core.security.entity.UserEntity;
import org.eclipse.sensinact.gateway.core.security.test.AbstractConfiguredSecurityTest;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;
import org.eclipse.sensinact.gateway.datastore.api.UnableToConnectToDataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.UnableToFindDataStoreException;
import org.eclipse.sensinact.gateway.datastore.sqlite.SQLiteDataStoreService;
import org.eclipse.sensinact.gateway.mail.connector.api.MailAccountConnectorMailReplacement;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleResponse;
import org.eclipse.sensinact.gateway.util.CryptoUtils;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectInstalledBundle;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.annotation.config.WithConfigurations;
import org.osgi.test.common.service.ServiceAware;
import org.osgi.test.junit5.cm.ConfigurationExtension;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.context.InstalledBundleExtension;
import org.osgi.test.junit5.service.ServiceExtension;

@Extensions(value={@ExtendWith(value={BundleContextExtension.class}), @ExtendWith(value={ServiceExtension.class}), @ExtendWith(value={InstalledBundleExtension.class}), @ExtendWith(value={ConfigurationExtension.class})})
public class TestUserManager
extends AbstractConfiguredSecurityTest {
    public static int HTTP_PORT = 8899;
    public static String HTTP_ROOTURL = "http://127.0.0.1:" + HTTP_PORT;
    private SQLiteDataStoreService dataStoreService;
    private File tempDB;

    public static String newRequest(String url, String content, String method) {
        ConnectionConfigurationImpl builder = new ConnectionConfigurationImpl();
        builder.setUri(url);
        try {
            if (method.equals("GET")) {
                builder.setHttpMethod("GET");
            } else if (method.equals("POST")) {
                builder.setContentType("application/json");
                builder.setHttpMethod("POST");
                if (content != null && content.length() > 0) {
                    JSONObject jsonData = new JSONObject(content);
                    builder.setContent((Object)jsonData.toString());
                }
            } else {
                return null;
            }
            builder.setAccept("application/json");
            SimpleRequest request = new SimpleRequest((ConnectionConfiguration)builder);
            SimpleResponse response = (SimpleResponse)request.send();
            System.out.println(response);
            byte[] responseContent = response.getContent();
            String contentStr = responseContent == null ? null : new String(responseContent);
            return contentStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @BeforeEach
    public void before(@InjectBundleContext BundleContext context) throws UnableToFindDataStoreException, UnableToConnectToDataStoreException, IOException {
        this.tempDB = File.createTempFile("test", ".sqlite");
        this.tempDB.deleteOnExit();
        Path copied = this.tempDB.toPath();
        Path originalPath = Paths.get(context.getProperty("sqlitedb"), new String[0]);
        Files.copy(originalPath, copied, StandardCopyOption.REPLACE_EXISTING);
        SQLiteDataStoreService.SQLiteConfig sqlLiteConfig = (SQLiteDataStoreService.SQLiteConfig)Mockito.mock(SQLiteDataStoreService.SQLiteConfig.class);
        Mockito.when((Object)sqlLiteConfig.database()).thenReturn((Object)this.tempDB.getAbsolutePath());
        this.dataStoreService = new SQLiteDataStoreService();
        this.dataStoreService.start(sqlLiteConfig);
    }

    @AfterEach
    public void after() {
        if (this.tempDB != null) {
            this.tempDB.delete();
        }
    }

    @Disabled
    @Test
    @WithConfigurations(value={@WithConfiguration(pid="SQLiteDataStoreService", location="?", properties={@Property(key="database", value={"${sqlitedb}"})}), @WithConfiguration(pid="sensinact.mail.account.connector", location="?", properties={@Property(key="host", value={"smtp.server.fr"}), @Property(key="port", value={"465"}), @Property(key="from", value={"sensinact@bigclout.eu"}), @Property(key="login", value={"cmunilla@server.fr"}), @Property(key="password", value={"478569LM"})})})
    public void testUserManager(@InjectService(timeout=1000L) Core core, @InjectInstalledBundle(value="tb.jar", start=true) Bundle bundle, @InjectService(cardinality=0) ServiceAware<MailAccountConnectorMailReplacement> mailReplacerAware) throws Exception {
        UserDAO dao = new UserDAO((DataStoreService)this.dataStoreService);
        String encryptedPassword = CryptoUtils.cryptWithMD5((String)"mytestpassword");
        UserEntity entity = dao.find("mytester", encryptedPassword);
        Assertions.assertNull((Object)entity);
        AnonymousSession as = core.getAnonymousSession();
        Assertions.assertNotNull((Object)as);
        as.registerUser("mytester", encryptedPassword, "fake@test.fr", "MAIL");
        Thread.sleep(2000L);
        MailAccountConnectorMailReplacement replacer = (MailAccountConnectorMailReplacement)mailReplacerAware.waitForService(500L);
        String message = replacer.getMailDetails();
        String link = "http" + message.split("http")[1];
        String validation = TestUserManager.newRequest(link, null, "GET");
        entity = dao.find("mytester", encryptedPassword);
        Assertions.assertNotNull((Object)entity);
        String publicKey = validation.substring(validation.lastIndexOf(58) + 2);
        System.out.println(publicKey);
        entity = dao.find(publicKey);
        Assertions.assertNotNull((Object)entity);
        dao.delete((SnaEntity)entity);
        entity = dao.find("mytester", encryptedPassword);
        Assertions.assertNull((Object)entity);
    }
}

