/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.sensinact.gateway.core.security.dao.AbstractMutableSnaDAO;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.entity.UserEntity;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;

public class UserDAO
extends AbstractMutableSnaDAO<UserEntity> {
    public UserDAO(DataStoreService dataStoreService) throws DAOException {
        super(UserEntity.class, dataStoreService);
    }

    public UserEntity find(long identifier) throws DAOException, DataStoreException {
        List userEntities = super.select(Collections.singletonMap("SUID", identifier));
        if (userEntities.size() != 1) {
            return null;
        }
        return (UserEntity)userEntities.get(0);
    }

    public UserEntity findFromAccount(String account) throws DAOException, DataStoreException {
        List userEntities = super.select(Collections.singletonMap("SUACCOUNT", account));
        if (userEntities.size() != 1) {
            return null;
        }
        return (UserEntity)userEntities.get(0);
    }

    public UserEntity find(final String login, final String password) throws DAOException, DataStoreException {
        List userEntities = super.select(new HashMap<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("SULOGIN", login);
                this.put("SUPASSWORD", password);
            }
        });
        if (userEntities.size() != 1) {
            return null;
        }
        return (UserEntity)userEntities.get(0);
    }

    public UserEntity find(String publicKey) throws DAOException, DataStoreException {
        List userEntities = super.select(Collections.singletonMap("SUPUBLIC_KEY", publicKey));
        if (userEntities.size() != 1) {
            return null;
        }
        return (UserEntity)userEntities.get(0);
    }

    public UserEntity create(String login, String password, String account, String accountType) throws DAOException, DataStoreException {
        UserEntity entity = null;
        entity = this.findFromAccount(account);
        if (entity != null) {
            throw new DAOException("A user with the same email address already exists");
        }
        entity = this.find(login);
        if (entity != null) {
            throw new DAOException("A user with the login already exists");
        }
        entity = new UserEntity(login, password, account, accountType);
        super.create(entity);
        return entity;
    }
}

