/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.integration.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.metrics.IMetricsGauge;
import org.eclipse.sensinact.core.metrics.IMetricsListener;
import org.eclipse.sensinact.core.metrics.IMetricsManager;
import org.eclipse.sensinact.core.metrics.IMetricsMultiGauge;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class MetricsTest {
    private static final String GAUGE_NAME = "test.gauge";
    private static final String GAUGES_1 = "gauges-1";
    private static final String GAUGES_2 = "gauges-2";
    private static final String[] GAUGES_NAMES = new String[]{"gauges-1", "gauges-2"};
    final BlockingQueue<BulkGenericDto> queue = new ArrayBlockingQueue<BulkGenericDto>(4);
    final AtomicBoolean gaugeCalled = new AtomicBoolean();
    final Map<String, Boolean> gaugesCalled = new ConcurrentHashMap<String, Boolean>();
    final List<ServiceRegistration<?>> svcRegs = new ArrayList();
    @InjectService
    GatewayThread thread;

    @BeforeEach
    void setUp(@InjectBundleContext BundleContext context) throws Exception {
        this.svcRegs.add(context.registerService(IMetricsListener.class, (Object)new TestListener(), null));
        TestGauge gauge = new TestGauge();
        this.svcRegs.add(context.registerService(IMetricsGauge.class, (Object)gauge, new Hashtable<String, String>(Map.of("sensinact.metrics.gauge.name", GAUGE_NAME))));
        this.svcRegs.add(context.registerService(IMetricsMultiGauge.class, (Object)gauge, new Hashtable<String, String[]>(Map.of("sensinact.metrics.multigauge.names", GAUGES_NAMES))));
    }

    @AfterEach
    void cleanUp(@InjectService IMetricsManager metrics) {
        metrics.clear();
        this.svcRegs.forEach(ServiceRegistration::unregister);
        this.svcRegs.clear();
    }

    @Test
    @WithConfiguration(pid="sensinact.metrics", location="?", properties={@Property(key="enabled", value={"false"}), @Property(key="metrics.rate", value={"1"})})
    void testDisabled(@InjectService(filter="(enabled=false)") IMetricsManager metrics) throws Exception {
        metrics.getCounter("toto").inc();
        Assertions.assertNull((Object)this.queue.poll(2L, TimeUnit.SECONDS), (String)"Listener was notified.");
        Assertions.assertFalse((boolean)this.gaugeCalled.get(), (String)"Gauge was called");
        Assertions.assertTrue((boolean)this.gaugesCalled.isEmpty(), (String)"Multigauge was called");
    }

    @Test
    @WithConfiguration(pid="sensinact.metrics", location="?", properties={@Property(key="enabled", value={"true"}), @Property(key="metrics.rate", value={"1"})})
    void testEnabled(@InjectService(filter="(enabled=true)") IMetricsManager metrics) throws Exception {
        metrics.getCounter("toto").inc();
        BulkGenericDto bulk = this.queue.poll(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)bulk, (String)"Listener was not notified");
        Assertions.assertTrue((boolean)this.gaugeCalled.get(), (String)"Gauge was not called");
        Assertions.assertFalse((boolean)this.gaugesCalled.isEmpty(), (String)"Multigauge was not called");
        HashMap<String, GenericDto> dtos = new HashMap<String, GenericDto>();
        for (GenericDto dto : bulk.dtos) {
            dtos.put(dto.resource, dto);
        }
        GenericDto dto = (GenericDto)dtos.get("toto");
        Assertions.assertNotNull((Object)dto, (String)"Resource not found");
        Assertions.assertEquals((Object)dto.model, (Object)"sensiNact-metrics");
        Assertions.assertEquals((Object)dto.provider, (Object)"sensiNact-metrics");
        Assertions.assertEquals((Object)dto.service, (Object)"metrics");
        Assertions.assertEquals((Object)dto.type, Long.class);
        Assertions.assertEquals((Object)dto.value, (Object)1L);
        dto = (GenericDto)dtos.get("gauge");
        Assertions.assertNotNull((Object)dto, (String)"Resource not found");
        Assertions.assertEquals((Object)dto.model, (Object)"sensiNact-metrics");
        Assertions.assertEquals((Object)dto.provider, (Object)"sensiNact-metrics");
        Assertions.assertEquals((Object)dto.service, (Object)"test");
        Assertions.assertEquals((Object)dto.type, Integer.class);
        Assertions.assertEquals((Object)dto.value, (Object)42);
        dto = (GenericDto)dtos.get(GAUGES_1);
        Assertions.assertNotNull((Object)dto, (String)"Resource not found");
        Assertions.assertEquals((Object)dto.model, (Object)"sensiNact-metrics");
        Assertions.assertEquals((Object)dto.provider, (Object)"sensiNact-metrics");
        Assertions.assertEquals((Object)dto.service, (Object)"metrics");
        Assertions.assertEquals((Object)dto.type, Integer.class);
        Assertions.assertEquals((Object)dto.value, (Object)1);
        dto = (GenericDto)dtos.get(GAUGES_2);
        Assertions.assertNotNull((Object)dto, (String)"Resource not found");
        Assertions.assertEquals((Object)dto.model, (Object)"sensiNact-metrics");
        Assertions.assertEquals((Object)dto.provider, (Object)"sensiNact-metrics");
        Assertions.assertEquals((Object)dto.service, (Object)"metrics");
        Assertions.assertEquals((Object)dto.type, Long.class);
        Assertions.assertEquals((Object)dto.value, (Object)2L);
    }

    @Test
    @WithConfiguration(pid="sensinact.metrics", location="?", properties={@Property(key="enabled", value={"true"}), @Property(key="metrics.rate", value={"1"}), @Property(key="provider.enabled", value={"true"})})
    void testProvider(@InjectService(filter="(enabled=true)") IMetricsManager metrics) throws Exception {
        metrics.getCounter("toto").inc();
        boolean atLeastOne = false;
        for (int trial = 0; trial < 5; ++trial) {
            BulkGenericDto bulk = this.queue.poll(1L, TimeUnit.SECONDS);
            atLeastOne |= bulk != null;
            if (this.gaugeCalled.get() && !this.gaugesCalled.isEmpty()) break;
        }
        Assertions.assertTrue((boolean)atLeastOne, (String)"Listener was not notified");
        Assertions.assertTrue((boolean)this.gaugeCalled.get(), (String)"Gauge was not called");
        Assertions.assertFalse((boolean)this.gaugesCalled.isEmpty(), (String)"Multigauge was not called");
        this.thread.execute((AbstractSensinactCommand)new AbstractTwinCommand<Void>(){

            protected Promise<Void> call(SensinactDigitalTwin twin, PromiseFactory pf) {
                SensinactResource resource = twin.getResource("sensiNact-metrics", "metrics", "toto");
                if (resource == null) {
                    return pf.failed((Throwable)((Object)new AssertionError((Object)"Resource not found")));
                }
                return pf.resolved(null);
            }
        }).getValue();
    }

    public class TestListener
    implements IMetricsListener {
        public void onMetricsReport(BulkGenericDto dto) {
            MetricsTest.this.queue.offer(dto);
        }
    }

    public class TestGauge
    implements IMetricsGauge,
    IMetricsMultiGauge {
        public Object gauge() {
            MetricsTest.this.gaugeCalled.set(true);
            return 42;
        }

        public Object gauge(String name) {
            MetricsTest.this.gaugesCalled.put(name, true);
            switch (name) {
                case "gauges-1": {
                    return 1;
                }
                case "gauges-2": {
                    return 2L;
                }
            }
            return null;
        }
    }
}

