/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.command;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class IndependentCommands<T>
extends AbstractSensinactCommand<List<T>> {
    private List<AbstractSensinactCommand<? extends T>> commands;
    private SensinactDigitalTwin twin;
    private SensinactModelManager modelMgr;
    private PromiseFactory pf;

    public IndependentCommands(AbstractSensinactCommand<? extends T> command, AbstractSensinactCommand<? extends T> command2) {
        this.commands = List.of(command, command2);
    }

    public IndependentCommands(AbstractSensinactCommand<? extends T> command, AbstractSensinactCommand<? extends T> command2, AbstractSensinactCommand<? extends T> command3) {
        this.commands = List.of(command, command2, command3);
    }

    public IndependentCommands(List<AbstractSensinactCommand<? extends T>> command) {
        this.commands = List.copyOf(command);
    }

    @Override
    protected Promise<List<T>> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
        this.twin = twin;
        this.modelMgr = modelMgr;
        this.pf = promiseFactory;
        return promiseFactory.all((Collection)this.commands.stream().map(this::safeCall).collect(Collectors.toList()));
    }

    private Promise<T> safeCall(AbstractSensinactCommand<? extends T> command) {
        return IndependentCommands.safeCall(command, this.twin, this.modelMgr, this.pf);
    }
}

