/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final String prefix;

    public ResourceServlet(String prefix) {
        this.prefix = prefix;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String target = req.getPathInfo();
        String resName = target == null ? this.prefix : this.prefix + target;
        URL url = this.getServletContext().getResource(resName);
        if (url == null) {
            res.sendError(404);
        } else {
            this.handle(req, res, url, resName);
        }
    }

    private void handle(HttpServletRequest req, HttpServletResponse res, URL url, String resName) throws IOException {
        long lastModified;
        String contentType = this.getServletContext().getMimeType(resName);
        if (contentType != null) {
            res.setContentType(contentType);
        }
        if ((lastModified = this.getLastModified(url)) != 0L) {
            res.setDateHeader("Last-Modified", lastModified);
        }
        if (!this.resourceModified(lastModified, req.getDateHeader("If-Modified-Since"))) {
            res.setStatus(304);
        } else {
            this.copyResource(url, res);
        }
    }

    private long getLastModified(URL url) {
        File f;
        String filepath;
        long lastModified = 0L;
        try {
            URLConnection conn = url.openConnection();
            lastModified = conn.getLastModified();
        }
        catch (Exception conn) {
            // empty catch block
        }
        if (lastModified == 0L && (filepath = url.getPath()) != null && (f = new File(filepath)).exists()) {
            lastModified = f.lastModified();
        }
        return lastModified;
    }

    private boolean resourceModified(long resTimestamp, long modSince) {
        return (resTimestamp /= 1000L) == 0L || (modSince /= 1000L) == -1L || resTimestamp > modSince;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(URL url, HttpServletResponse res) throws IOException {
        URLConnection conn = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int n;
            conn = url.openConnection();
            is = conn.getInputStream();
            os = res.getOutputStream();
            int len = this.getContentLength(conn);
            if (len >= 0) {
                res.setContentLength(len);
            }
            byte[] buf = new byte[1024];
            while ((n = is.read(buf, 0, buf.length)) >= 0) {
                os.write(buf, 0, n);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private int getContentLength(URLConnection conn) {
        File f;
        String path;
        int length = -1;
        length = conn.getContentLength();
        if (length < 0 && (path = conn.getURL().getPath()) != null && (f = new File(path)).length() < Integer.MAX_VALUE) {
            length = (int)f.length();
        }
        return length;
    }
}

