/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.service.local.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.aries.tx.control.service.local.impl.TransactionControlImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.transaction.control.TransactionControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private TransactionControlImpl service;
    private ServiceRegistration<TransactionControl> reg;

    public void start(BundleContext context) throws Exception {
        Dictionary<String, Object> properties = this.getProperties();
        logger.info("Registering a new Local TransactionControl service with properties {}", properties);
        this.service = new TransactionControlImpl();
        this.reg = context.registerService(TransactionControl.class, (Object)this.service, properties);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.reg != null) {
            try {
                this.reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.service.close();
    }

    private Dictionary<String, Object> getProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.local.enabled", Boolean.TRUE);
        ((Dictionary)props).put("service.description", "The Apache Aries Transaction Control Service for Local Transactions");
        ((Dictionary)props).put("service.vendor", "Apache Aries");
        return props;
    }
}

