/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime.application;

import jakarta.ws.rs.core.Application;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osgitech.rest.binder.PromiseResponseHandlerBinder;
import org.eclipse.osgitech.rest.binder.PrototypeServiceBinder;
import org.eclipse.osgitech.rest.factories.InjectableFactory;
import org.eclipse.osgitech.rest.factories.JerseyResourceInstanceFactory;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplicationContentProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyExtensionProvider;
import org.eclipse.osgitech.rest.runtime.application.feature.WhiteboardFeature;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.spi.AbstractContainerLifecycleListener;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.servlet.async.AsyncContextDelegateProviderImpl;
import org.glassfish.jersey.servlet.init.FilterUrlMappingsProviderImpl;
import org.osgi.framework.ServiceObjects;

public class JerseyApplication
extends Application {
    private final Map<String, Class<?>> classes = new HashMap();
    private final Map<String, Object> singletons = new HashMap<String, Object>();
    private final Map<String, JerseyExtensionProvider> extensions = new HashMap<String, JerseyExtensionProvider>();
    private final Map<String, JerseyApplicationContentProvider> contentProviders = new HashMap<String, JerseyApplicationContentProvider>();
    private final String applicationName;
    private final Logger log = Logger.getLogger("jersey.application");
    private final Map<String, Object> properties;
    private final Application sourceApplication;
    private final Map<Class<?>, InjectableFactory<?>> factories = new HashMap();
    private final WhiteboardFeature whiteboardFeature;
    private final Set<Object> appSingletons;

    public JerseyApplication(String applicationName, Application sourceApplication, Map<String, Object> additionalProperites, List<JerseyApplicationContentProvider> providers) {
        this.applicationName = applicationName;
        this.sourceApplication = sourceApplication;
        HashMap<String, Map<String, Object>> props = new HashMap<String, Map<String, Object>>();
        if (additionalProperites != null) {
            props.put("osgi.jakartars.application.serviceProperties", additionalProperites);
        }
        if (sourceApplication.getProperties() != null) {
            props.putAll(sourceApplication.getProperties());
        }
        this.properties = Collections.unmodifiableMap(props);
        providers.forEach(this::addContent);
        this.whiteboardFeature = new WhiteboardFeature(this.extensions);
        PrototypeServiceBinder resourceFactory = new PrototypeServiceBinder();
        this.factories.forEach(resourceFactory::register);
        this.appSingletons = new HashSet<Object>();
        this.appSingletons.addAll(this.singletons.values());
        this.appSingletons.addAll(sourceApplication.getSingletons());
        this.appSingletons.add(this.whiteboardFeature);
        this.appSingletons.add((Object)resourceFactory);
        this.appSingletons.add((Object)new ContainerLifecycleTracker());
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Set<Class<?>> getClasses() {
        return Stream.of(this.classes.values().stream(), this.sourceApplication.getClasses().stream(), Stream.of(PromiseResponseHandlerBinder.class, AsyncContextDelegateProviderImpl.class, FilterUrlMappingsProviderImpl.class)).flatMap(Function.identity()).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Object> getSingletons() {
        return Collections.unmodifiableSet(this.appSingletons);
    }

    public void dispose() {
        this.whiteboardFeature.dispose();
        this.singletons.forEach((k, v) -> {
            JerseyApplicationContentProvider provider = this.contentProviders.get(k);
            Object providerObj = provider.getProviderObject();
            if (providerObj instanceof ServiceObjects) {
                ServiceObjects serviceObjs = (ServiceObjects)providerObj;
                try {
                    serviceObjs.ungetService(v);
                }
                catch (IllegalArgumentException e) {
                    this.log.log(Level.SEVERE, "Cannot unget service for resource " + provider.getName(), e);
                }
            }
        });
        this.singletons.clear();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    private boolean addContent(JerseyApplicationContentProvider contentProvider) {
        if (contentProvider == null) {
            if (this.log != null) {
                this.log.log(Level.WARNING, "A null service content provider was given to register as a Jakartars resource or extension");
            }
            return false;
        }
        String key = contentProvider.getId();
        this.contentProviders.put(key, contentProvider);
        if (contentProvider instanceof JerseyExtensionProvider) {
            Class<?> extensionClass = contentProvider.getObjectClass();
            if (extensionClass == null) {
                this.contentProviders.remove(key);
                JerseyExtensionProvider removed = this.extensions.remove(key);
                return removed != null;
            }
            JerseyExtensionProvider result = this.extensions.put(key, (JerseyExtensionProvider)contentProvider);
            return result == null || !extensionClass.equals(result.getObjectClass());
        }
        Class<?> resourceClass = contentProvider.getObjectClass();
        this.factories.put(resourceClass, new JerseyResourceInstanceFactory(contentProvider));
        if (contentProvider.isSingleton()) {
            Object result = this.singletons.get(key);
            if (result == null || !result.getClass().equals(resourceClass)) {
                Object providerObject = contentProvider.getProviderObject();
                if (providerObject == null) {
                    this.contentProviders.remove(key);
                    Object removed = this.singletons.remove(key);
                    return removed != null;
                }
                Object service = ((ServiceObjects)providerObject).getService();
                if (service == null) {
                    this.contentProviders.remove(key);
                    Object removed = this.singletons.remove(key);
                    return removed != null;
                }
                result = this.singletons.put(key, service);
                if (result != null) {
                    ((ServiceObjects)contentProvider.getProviderObject()).ungetService(result);
                }
                return true;
            }
            return false;
        }
        if (resourceClass == null) {
            this.contentProviders.remove(key);
            Class<?> removed = this.classes.remove(key);
            return removed != null;
        }
        Class<?> result = this.classes.put(key, resourceClass);
        return !resourceClass.equals(result) || result == null;
    }

    public Application getSourceApplication() {
        return this.sourceApplication;
    }

    private class ContainerLifecycleTracker
    extends AbstractContainerLifecycleListener {
        private ContainerLifecycleTracker() {
        }

        public void onStartup(Container container) {
            InjectionManager im = container.getApplicationHandler().getInjectionManager();
            JerseyApplication.this.factories.values().forEach(f -> f.setInjectionManager(im));
        }

        public void onShutdown(Container container) {
            JerseyApplication.this.dispose();
        }
    }
}

