/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.resource.common.impl;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import org.osgi.framework.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrackingResourceProviderFactory<T extends AutoCloseable> {
    private static final Logger LOG = LoggerFactory.getLogger(TrackingResourceProviderFactory.class);
    private final Set<T> toClose = Collections.newSetFromMap(new IdentityHashMap());
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doGetResult(Callable<T> getter) {
        AutoCloseable t;
        Callable<T> callable = getter;
        synchronized (callable) {
            if (this.closed) {
                throw new IllegalStateException("This ResourceProvider has been reclaimed because the factory service that provided it was released");
            }
        }
        try {
            t = (AutoCloseable)getter.call();
        }
        catch (Exception e) {
            LOG.warn("A failure occurred obtaining the resource provider", (Throwable)e);
            throw new ServiceException("A failure occurred obtaining the resource provider", (Throwable)e);
        }
        boolean destroy = false;
        Set<T> set = this.toClose;
        synchronized (set) {
            if (this.closed) {
                destroy = true;
            } else {
                this.toClose.add(t);
            }
        }
        if (destroy) {
            try {
                t.close();
            }
            catch (Exception e) {
                LOG.warn("A failure occurred closing the resource provider", (Throwable)e);
            }
            throw new IllegalStateException("This ResourceProvider has been reclaimed because the factory service that provided it was released");
        }
        return (T)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Set<T> set = this.toClose;
        synchronized (set) {
            this.closed = true;
        }
        this.toClose.stream().forEach(ajcp -> {
            try {
                ajcp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.toClose.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(T t) {
        Set<T> set = this.toClose;
        synchronized (set) {
            if (this.closed) {
                throw new IllegalStateException("This resource factory is closed");
            }
            if (!this.toClose.remove(t)) {
                throw new IllegalArgumentException("The resource " + t + " is not managed by this factory");
            }
        }
        try {
            t.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

