/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.sensinact.core.command.impl.CommandScopedImpl;
import org.eclipse.sensinact.core.emf.model.EMFModel;
import org.eclipse.sensinact.core.emf.model.EMFService;
import org.eclipse.sensinact.core.emf.model.EMFServiceBuilder;
import org.eclipse.sensinact.core.model.impl.ServiceBuilderImpl;
import org.eclipse.sensinact.core.model.impl.ServiceImpl;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;

public class ModelImpl
extends CommandScopedImpl
implements EMFModel {
    private final String name;
    private final EClass eClass;
    private ModelNexus nexusImpl;

    public ModelImpl(AtomicBoolean active, String name, EClass eClass, ModelNexus nexusImpl) {
        super(active);
        this.name = name;
        this.eClass = eClass;
        this.nexusImpl = nexusImpl;
    }

    public boolean isFrozen() {
        this.checkValid();
        return ((EClassImpl)this.eClass).isFrozen();
    }

    public boolean isDynamic() {
        this.checkValid();
        return !ProviderPackage.Literals.DYNAMIC_PROVIDER.isSuperTypeOf(this.eClass);
    }

    public String getName() {
        this.checkValid();
        return this.name;
    }

    public String getPackageUri() {
        this.checkValid();
        return this.eClass.getEPackage().getNsURI();
    }

    public boolean isExclusivelyOwned() {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public boolean isAutoDelete() {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public EMFServiceBuilder<EMFService> createService(String service) {
        this.checkValid();
        if (this.isFrozen()) {
            throw new IllegalStateException("Model " + this.name + " is frozen and can't be modified.");
        }
        return new ServiceBuilderImpl<Object>(this.active, null, this, service, this.nexusImpl);
    }

    public EMFService createDynamicService(String svc, EClass svcEClass) {
        return new ServiceImpl(this.active, this, svc, svcEClass, this.nexusImpl);
    }

    public Map<String, ? extends EMFService> getServices() {
        this.checkValid();
        return this.nexusImpl.getServiceReferencesForModel(this.eClass).collect(Collectors.toMap(ENamedElement::getName, r -> new ServiceImpl(this.active, this, r.getName(), r.getEReferenceType(), this.nexusImpl)));
    }

    public EClass getModelEClass() {
        return this.eClass;
    }

    @Override
    protected void checkValid() {
        super.checkValid();
        if (!this.nexusImpl.registered(this.eClass)) {
            throw new IllegalStateException("This model has been deleted");
        }
    }
}

