/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.helper;

import jakarta.ws.rs.core.Application;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;

public class JerseyHelper {
    public static <T> T getPropertyWithDefault(Map<String, Object> props, String key, T defaultValue) {
        if (props == null) {
            throw new IllegalStateException("Cannot call getProperties in a state, where the component context is not available");
        }
        Object value = props.get(key);
        return (T)(value == null ? defaultValue : value);
    }

    public static boolean isEmpty(Application application) {
        if (application == null) {
            return true;
        }
        return application.getClasses().isEmpty() && application.getSingletons().isEmpty();
    }

    public static String[] getStringPlusProperty(String propertyName, Map<String, Object> properties) {
        if (propertyName == null || properties == null) {
            return null;
        }
        Object filterObject = properties.get(propertyName);
        String[] filters = null;
        if (filterObject instanceof String) {
            filters = new String[]{filterObject.toString()};
        } else if (filterObject instanceof String[]) {
            filters = (String[])filterObject;
        } else if (filterObject instanceof List) {
            filters = (String[])((List)filterObject).stream().map(String::valueOf).toArray(String[]::new);
        }
        return filters;
    }

    public static Map<String, Object> getServiceProperties(ServiceReference<?> reference) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (reference != null) {
            for (String key : reference.getPropertyKeys()) {
                props.put(key, reference.getProperty(key));
            }
        }
        return props;
    }
}

