/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime;

import jakarta.ws.rs.core.Application;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osgitech.rest.annotations.RequireJerseyExtras;
import org.eclipse.osgitech.rest.annotations.RequireRuntimeAdapter;
import org.eclipse.osgitech.rest.dto.DTOConverter;
import org.eclipse.osgitech.rest.helper.DispatcherHelper;
import org.eclipse.osgitech.rest.runtime.application.AbstractJakartarsProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplicationContentProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplicationProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyExtensionProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyResourceProvider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.jakartars.runtime.JakartarsServiceRuntime;
import org.osgi.service.jakartars.runtime.dto.ApplicationDTO;
import org.osgi.service.jakartars.runtime.dto.BaseApplicationDTO;
import org.osgi.service.jakartars.runtime.dto.BaseDTO;
import org.osgi.service.jakartars.runtime.dto.BaseExtensionDTO;
import org.osgi.service.jakartars.runtime.dto.ExtensionDTO;
import org.osgi.service.jakartars.runtime.dto.FailedApplicationDTO;
import org.osgi.service.jakartars.runtime.dto.FailedExtensionDTO;
import org.osgi.service.jakartars.runtime.dto.FailedResourceDTO;
import org.osgi.service.jakartars.runtime.dto.ResourceDTO;
import org.osgi.service.jakartars.runtime.dto.ResourceMethodInfoDTO;
import org.osgi.service.jakartars.runtime.dto.RuntimeDTO;
import org.osgi.util.tracker.ServiceTracker;

@RequireJerseyExtras
@RequireRuntimeAdapter
public class JerseyServiceRuntime<C extends Container> {
    private static final String RESOURCE_FILTER = "(osgi.jakartars.resource=true)";
    private static final String EXTENSION_FILTER = "(osgi.jakartars.extension=true)";
    private static final String APPLICATION_FILTER = "(&(objectClass=" + Application.class.getName() + ")(osgi.jakartars.application.base=*))";
    private final Object lock = new Object();
    private Boolean active = null;
    private Instant lastUpdate;
    private RuntimeDTO runtimeDTO = new RuntimeDTO();
    private long updateCount;
    private long changeCount;
    private Map<String, Object> runtimeProperties;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final BundleContext context;
    private final BiFunction<String, ResourceConfig, C> containerFactory;
    private final BiConsumer<String, C> containerDestroyer;
    private final ServiceTracker<Object, ServiceReference<?>> resourceTracker;
    private final ServiceTracker<Object, ServiceReference<?>> extensionTracker;
    private final ServiceTracker<Application, Application> applicationTracker;
    private final Map<Long, JerseyApplicationProvider> applicationContainerMap = new HashMap<Long, JerseyApplicationProvider>();
    private final Map<Long, JerseyExtensionProvider> extensionMap = new HashMap<Long, JerseyExtensionProvider>();
    private final Map<Long, JerseyResourceProvider> resourceMap = new HashMap<Long, JerseyResourceProvider>();
    private final JerseyApplicationProvider defaultProvider = new JerseyApplicationProvider(new Application(), Map.of("osgi.jakartars.name", ".default", "osgi.jakartars.application.base", "/", "service.ranking", Integer.MIN_VALUE));
    private final Logger logger = Logger.getLogger("Jakartars.serviceRuntime");
    private ServiceRegistration<JakartarsServiceRuntime> regJakartarsServiceRuntime;
    private final Map<String, C> containersByPath = new HashMap<String, C>();

    public JerseyServiceRuntime(BundleContext context, BiFunction<String, ResourceConfig, C> containerFactory, BiConsumer<String, C> containerDestroyer) {
        this.context = context;
        this.containerFactory = containerFactory;
        this.containerDestroyer = containerDestroyer;
        try {
            this.resourceTracker = new ServiceTracker<Object, ServiceReference<?>>(context, context.createFilter(RESOURCE_FILTER), null){

                public ServiceReference<?> addingService(ServiceReference<Object> reference) {
                    JerseyResourceProvider provider = new JerseyResourceProvider((ServiceObjects<Object>)this.context.getServiceObjects(reference), JerseyServiceRuntime.this.getServiceProps(reference));
                    JerseyServiceRuntime.this.updateMap(JerseyServiceRuntime.this.resourceMap, provider);
                    return reference;
                }

                public void modifiedService(ServiceReference<Object> reference, ServiceReference<?> service) {
                    JerseyResourceProvider provider = new JerseyResourceProvider((ServiceObjects<Object>)this.context.getServiceObjects(reference), JerseyServiceRuntime.this.getServiceProps(reference));
                    JerseyServiceRuntime.this.updateMap(JerseyServiceRuntime.this.resourceMap, provider);
                }

                public void removedService(ServiceReference<Object> reference, ServiceReference<?> service) {
                    JerseyServiceRuntime.this.clearMap(JerseyServiceRuntime.this.resourceMap, AbstractJakartarsProvider.getServiceId(JerseyServiceRuntime.this.getServiceProps(reference)));
                }
            };
            this.extensionTracker = new ServiceTracker<Object, ServiceReference<?>>(context, context.createFilter(EXTENSION_FILTER), null){

                public ServiceReference<?> addingService(ServiceReference<Object> reference) {
                    JerseyExtensionProvider provider = new JerseyExtensionProvider((ServiceObjects<Object>)this.context.getServiceObjects(reference), JerseyServiceRuntime.this.getServiceProps(reference));
                    JerseyServiceRuntime.this.updateMap(JerseyServiceRuntime.this.extensionMap, provider);
                    return reference;
                }

                public void modifiedService(ServiceReference<Object> reference, ServiceReference<?> service) {
                    JerseyExtensionProvider provider = new JerseyExtensionProvider((ServiceObjects<Object>)this.context.getServiceObjects(reference), JerseyServiceRuntime.this.getServiceProps(reference));
                    JerseyServiceRuntime.this.updateMap(JerseyServiceRuntime.this.extensionMap, provider);
                }

                public void removedService(ServiceReference<Object> reference, ServiceReference<?> service) {
                    JerseyServiceRuntime.this.clearMap(JerseyServiceRuntime.this.extensionMap, AbstractJakartarsProvider.getServiceId(JerseyServiceRuntime.this.getServiceProps(reference)));
                }
            };
            this.applicationTracker = new ServiceTracker<Application, Application>(context, context.createFilter(APPLICATION_FILTER), null){

                public Application addingService(ServiceReference<Application> reference) {
                    Application app = (Application)super.addingService(reference);
                    JerseyApplicationProvider provider = new JerseyApplicationProvider(app, JerseyServiceRuntime.this.getServiceProps(reference));
                    JerseyServiceRuntime.this.updateMap(JerseyServiceRuntime.this.applicationContainerMap, provider);
                    return app;
                }

                public void modifiedService(ServiceReference<Application> reference, Application service) {
                    JerseyApplicationProvider provider = new JerseyApplicationProvider(service, JerseyServiceRuntime.this.getServiceProps(reference));
                    JerseyServiceRuntime.this.updateMap(JerseyServiceRuntime.this.applicationContainerMap, provider);
                }

                public void removedService(ServiceReference<Application> reference, Application service) {
                    JerseyServiceRuntime.this.clearMap(JerseyServiceRuntime.this.applicationContainerMap, AbstractJakartarsProvider.getServiceId(JerseyServiceRuntime.this.getServiceProps(reference)));
                    super.removedService(reference, (Object)service);
                }
            };
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException("An error occurred creating a filter from a static String", ise);
        }
    }

    private Map<String, Object> getServiceProps(ServiceReference<?> ref) {
        return Arrays.stream(ref.getPropertyKeys()).collect(Collectors.toMap(Function.identity(), arg_0 -> ref.getProperty(arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, T extends AbstractJakartarsProvider<R>> void updateMap(Map<Long, T> map, T provider) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduleUpdate();
            map.put(provider.getServiceId(), provider);
            ++this.updateCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, T extends AbstractJakartarsProvider<R>> void clearMap(Map<Long, T> map, Long id) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduleUpdate();
            map.remove(id);
            ++this.updateCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeDTO getRuntimeDTO() {
        RuntimeDTO dto;
        Object object = this.lock;
        synchronized (object) {
            dto = this.runtimeDTO;
        }
        return DTOConverter.deepCopy(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Map<String, Object> runtimeProperties) {
        Object object = this.lock;
        synchronized (object) {
            this.active = Boolean.TRUE;
            this.lastUpdate = Instant.ofEpochMilli(0L);
            this.scheduleUpdate();
            this.runtimeProperties = Map.copyOf(runtimeProperties);
            ++this.updateCount;
        }
        this.applicationTracker.open();
        this.extensionTracker.open();
        this.resourceTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Map<String, Object> runtimeProperties) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduleUpdate();
            this.runtimeProperties = Map.copyOf(runtimeProperties);
            ++this.updateCount;
        }
    }

    private void scheduleUpdate() {
        if (this.active == Boolean.TRUE && this.updateCount == this.changeCount) {
            long since = Duration.between(this.lastUpdate, Instant.now()).toMillis();
            long delay = since < 50L ? 50L - since : 0L;
            this.executor.schedule(() -> this.doInternalUpdate(), delay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInternalUpdate() {
        block14: {
            List<JerseyResourceProvider> resources;
            List<JerseyExtensionProvider> extensions;
            List<JerseyApplicationProvider> applications;
            Map runtimeProperties;
            long changeCount;
            Instant update = Instant.now();
            Object object = this.lock;
            synchronized (object) {
                if (this.active != Boolean.TRUE) {
                    return;
                }
                this.lastUpdate = update;
                this.changeCount = this.updateCount;
                changeCount = this.updateCount;
                runtimeProperties = this.regJakartarsServiceRuntime == null ? Map.copyOf(this.runtimeProperties) : FrameworkUtil.asMap((Dictionary)this.regJakartarsServiceRuntime.getReference().getProperties());
                applications = Stream.concat(Stream.of(this.defaultProvider), this.applicationContainerMap.values().stream()).map(jap -> jap.cleanCopy()).collect(Collectors.toList());
                extensions = this.extensionMap.values().stream().map(jep -> jep.cleanCopy()).collect(Collectors.toList());
                resources = this.resourceMap.values().stream().map(jrp -> jrp.cleanCopy()).collect(Collectors.toList());
            }
            try {
                this.doDispatch(runtimeProperties, applications, extensions, resources);
                RuntimeDTO dto = this.getUpdatedRuntimeDTO(runtimeProperties, applications, extensions, resources);
                Object object2 = this.lock;
                synchronized (object2) {
                    this.runtimeDTO = dto;
                }
                Dictionary<String, Object> properties = this.getRuntimePropertiesWithNewChangeCount(runtimeProperties, changeCount);
                if (this.regJakartarsServiceRuntime == null) {
                    this.regJakartarsServiceRuntime = this.context.registerService(JakartarsServiceRuntime.class, this::getRuntimeDTO, properties);
                } else {
                    this.regJakartarsServiceRuntime.setProperties(properties);
                }
                ServiceReferenceDTO updatedDto = DTOConverter.toServiceReferenceDTO(this.regJakartarsServiceRuntime.getReference());
                Object object3 = this.lock;
                synchronized (object3) {
                    this.runtimeDTO.serviceDTO = updatedDto;
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error updating JerseyServiceRuntime", e);
                if (this.regJakartarsServiceRuntime == null) break block14;
                this.regJakartarsServiceRuntime.unregister();
                this.regJakartarsServiceRuntime = null;
            }
        }
    }

    private Dictionary<String, Object> getRuntimePropertiesWithNewChangeCount(Map<String, Object> runtimeProps, long changeCount) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(runtimeProps);
        if (!runtimeProps.containsKey("osgi.jakartars.endpoint")) {
            ((Dictionary)properties).put("osgi.jakartars.endpoint", List.of("/"));
        }
        ((Dictionary)properties).put("service.changecount", changeCount);
        return properties;
    }

    private void doDispatch(Map<String, Object> properties, List<JerseyApplicationProvider> applications, List<JerseyExtensionProvider> extensions, List<JerseyResourceProvider> resources) {
        try {
            applications.removeIf(a -> !a.canHandleWhiteboard(properties));
            extensions.removeIf(e -> !e.canHandleWhiteboard(properties));
            resources.removeIf(r -> !r.canHandleWhiteboard(properties));
            List<JerseyApplicationProvider> applicationCandidates = this.checkPathProperty(applications);
            List<AbstractJakartarsProvider<?>> candidates = this.checkNameProperty(applicationCandidates, extensions, resources);
            applicationCandidates = candidates.stream().filter(JerseyApplicationProvider.class::isInstance).map(JerseyApplicationProvider.class::cast).collect(Collectors.toUnmodifiableList());
            List resourceCandidates = candidates.stream().filter(JerseyResourceProvider.class::isInstance).map(JerseyResourceProvider.class::cast).collect(Collectors.toUnmodifiableList());
            List extensionCandidates = candidates.stream().filter(JerseyExtensionProvider.class::isInstance).map(JerseyExtensionProvider.class::cast).collect(Collectors.toUnmodifiableList());
            this.assignContent(applicationCandidates, extensionCandidates);
            applicationCandidates = this.checkExtensionSelect(applicationCandidates, extensions, properties);
            Set<JerseyApplicationProvider> defaultApplications = DispatcherHelper.getDefaultApplications(applicationCandidates);
            defaultApplications.stream().skip(1L).forEach(a -> a.updateStatus(1));
            applicationCandidates = applicationCandidates.stream().filter(Predicate.not(AbstractJakartarsProvider::isFailed)).collect(Collectors.toUnmodifiableList());
            this.assignContent(applicationCandidates, resourceCandidates);
            this.checkExtensionSelectForResources(applicationCandidates, resources, properties);
            for (JerseyApplicationProvider jap : applicationCandidates) {
                Container c = (Container)this.containersByPath.get(jap.getPath());
                if (c == null) {
                    c = (Container)this.containerFactory.apply(jap.getPath(), jap.getJakartarsApplication());
                    this.containersByPath.put(jap.getPath(), c);
                    continue;
                }
                Application application = c.getConfiguration().getApplication();
                if (!jap.isChanged(application)) continue;
                c.reload(jap.getJakartarsApplication());
            }
            Set paths = applicationCandidates.stream().map(JerseyApplicationProvider::getPath).collect(Collectors.toSet());
            Iterator<Map.Entry<String, C>> it = this.containersByPath.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, C> e2 = it.next();
                if (paths.contains(e2.getKey())) continue;
                Container container = (Container)e2.getValue();
                if (container != null) {
                    this.containerDestroyer.accept(e2.getKey(), container);
                }
                it.remove();
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    private List<JerseyApplicationProvider> checkPathProperty(List<JerseyApplicationProvider> applicationCandidates) {
        this.logger.fine("App Candidates size BEFORE ordering " + applicationCandidates.size());
        applicationCandidates = applicationCandidates.stream().filter(Predicate.not(AbstractJakartarsProvider::isFailed)).sorted().collect(Collectors.toUnmodifiableList());
        this.logger.fine("App Candidates size AFTER ordering " + applicationCandidates.size());
        for (int i = 0; i < applicationCandidates.size(); ++i) {
            JerseyApplicationProvider a1 = applicationCandidates.get(i);
            String path = a1.getPath();
            for (int j = i + 1; j < applicationCandidates.size(); ++j) {
                JerseyApplicationProvider a2 = applicationCandidates.get(j);
                if (!path.equals(a2.getPath())) continue;
                this.logger.fine("Failing DTO status for App " + a2.getId());
                a2.updateStatus(1);
            }
        }
        return applicationCandidates.stream().filter(Predicate.not(AbstractJakartarsProvider::isFailed)).collect(Collectors.toList());
    }

    private List<AbstractJakartarsProvider<?>> checkNameProperty(List<JerseyApplicationProvider> applicationCandidates, List<JerseyExtensionProvider> extensionCandidates, List<JerseyResourceProvider> resourceCandidates) {
        List allCandidates = Stream.of(applicationCandidates.stream(), extensionCandidates.stream(), resourceCandidates.stream()).flatMap(s -> s).filter(Predicate.not(AbstractJakartarsProvider::isFailed)).sorted().collect(Collectors.toUnmodifiableList());
        for (int i = 0; i < allCandidates.size(); ++i) {
            AbstractJakartarsProvider p = (AbstractJakartarsProvider)allCandidates.get(i);
            String name = p.getName();
            String id = p.getId();
            for (int j = i + 1; j < allCandidates.size(); ++j) {
                AbstractJakartarsProvider p2 = (AbstractJakartarsProvider)allCandidates.get(j);
                if (!name.equals(p2.getName()) || id.equals(p2.getId())) continue;
                this.logger.info("Adding failure " + p2.getId() + " with name " + p2.getName() + " compared with " + p.getId());
                p2.updateStatus(6);
            }
        }
        return allCandidates.stream().filter(Predicate.not(AbstractJakartarsProvider::isFailed)).collect(Collectors.toList());
    }

    private void assignContent(Collection<JerseyApplicationProvider> candidates, Collection<? extends JerseyApplicationContentProvider> content) {
        for (JerseyApplicationContentProvider jerseyApplicationContentProvider : content) {
            boolean matched = false;
            for (JerseyApplicationProvider jap : candidates) {
                if (!jerseyApplicationContentProvider.canHandleApplication(jap)) continue;
                this.logger.info("Added content " + jerseyApplicationContentProvider.getName() + " to application " + jap.getName() + " " + jerseyApplicationContentProvider.getObjectClass());
                matched = true;
                if (jap.addContent(jerseyApplicationContentProvider.cleanCopy())) continue;
                this.logger.warning("Unhandled JerseyApplicationContentProvider. Could not add content " + jerseyApplicationContentProvider + " to application " + jap.getName());
            }
            if (matched) continue;
            jerseyApplicationContentProvider.updateStatus(7);
        }
    }

    private List<JerseyApplicationProvider> checkExtensionSelect(List<JerseyApplicationProvider> applicationCandidates, List<JerseyExtensionProvider> extensionsForDTO, Map<String, Object> runtimeProperties) {
        for (JerseyApplicationProvider app : applicationCandidates) {
            HashMap dependencyMap = new HashMap();
            Collection<JerseyApplicationContentProvider> contents = app.getContentProviders();
            List extensions = contents.stream().filter(JerseyExtensionProvider.class::isInstance).map(JerseyExtensionProvider.class::cast).collect(Collectors.toList());
            if (app.requiresExtensions()) {
                dependencyMap.put(app, new HashSet());
                List<Filter> extFilters = app.getExtensionFilters();
                block1: for (Filter filter : extFilters) {
                    for (JerseyExtensionProvider ext : extensions) {
                        if (!filter.matches(ext.getProviderProperties())) continue;
                        ((Set)dependencyMap.get(app)).add(ext.getId());
                        continue block1;
                    }
                    if (filter.matches(runtimeProperties)) continue;
                    app.updateStatus(5);
                    break;
                }
            }
            for (JerseyExtensionProvider ext : extensions) {
                if (!ext.requiresExtensions()) continue;
                dependencyMap.put(ext, new HashSet());
                List<Filter> extFilters = ext.getExtensionFilters();
                block4: for (Filter filter : extFilters) {
                    for (JerseyExtensionProvider ext2 : extensions) {
                        if (!filter.matches(ext2.getProviderProperties())) continue;
                        ((Set)dependencyMap.get(ext)).add(ext2.getId());
                        continue block4;
                    }
                    if (filter.matches(app.getProviderProperties()) || filter.matches(runtimeProperties)) continue;
                    this.handleExtensionRemoval(app, ext, extensionsForDTO, dependencyMap);
                }
            }
        }
        return applicationCandidates.stream().filter(Predicate.not(AbstractJakartarsProvider::isFailed)).collect(Collectors.toList());
    }

    private void handleExtensionRemoval(JerseyApplicationProvider app, JerseyExtensionProvider ext, List<JerseyExtensionProvider> extensionsForDTO, Map<AbstractJakartarsProvider<?>, Set<String>> dependencies) {
        app.removeContent(ext);
        ext.updateStatus(5);
        extensionsForDTO.add(ext);
        String id = ext.getId();
        dependencies.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(id)).map(Map.Entry::getKey).forEach(e -> {
            if (e instanceof JerseyExtensionProvider) {
                this.handleExtensionRemoval(app, (JerseyExtensionProvider)e, extensionsForDTO, dependencies);
            } else {
                e.updateStatus(5);
            }
        });
    }

    private void checkExtensionSelectForResources(List<JerseyApplicationProvider> applicationCandidates, List<JerseyResourceProvider> resourcesForDTO, Map<String, Object> runtimeProperties) {
        for (JerseyApplicationProvider app : applicationCandidates) {
            Collection<JerseyApplicationContentProvider> contents = app.getContentProviders();
            List extensions = contents.stream().filter(JerseyExtensionProvider.class::isInstance).map(JerseyExtensionProvider.class::cast).collect(Collectors.toList());
            List resources = contents.stream().filter(JerseyResourceProvider.class::isInstance).map(JerseyResourceProvider.class::cast).collect(Collectors.toList());
            for (JerseyResourceProvider res : resources) {
                if (!res.requiresExtensions()) continue;
                List<Filter> extFilters = res.getExtensionFilters();
                block2: for (Filter filter : extFilters) {
                    for (JerseyExtensionProvider ext : extensions) {
                        if (!filter.matches(ext.getProviderProperties())) continue;
                        continue block2;
                    }
                    if (filter.matches(app.getProviderProperties()) || filter.matches(runtimeProperties)) continue;
                    app.removeContent(res);
                    res.updateStatus(5);
                    resourcesForDTO.add(res);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void teardown(long time, TimeUnit unit) {
        Object object = this.lock;
        synchronized (object) {
            this.active = Boolean.FALSE;
        }
        try {
            Future<?> f = this.executor.submit(() -> {
                if (this.regJakartarsServiceRuntime != null) {
                    this.regJakartarsServiceRuntime.unregister();
                    this.regJakartarsServiceRuntime = null;
                }
                this.containersByPath.entrySet().forEach(e -> this.containerDestroyer.accept((String)e.getKey(), (Container)e.getValue()));
            });
            this.executor.shutdown();
            f.get(time, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.severe(e.getMessage());
        }
    }

    private RuntimeDTO getUpdatedRuntimeDTO(Map<String, Object> properties, List<JerseyApplicationProvider> applications, List<JerseyExtensionProvider> extensions, List<JerseyResourceProvider> resources) {
        RuntimeDTO newDto = new RuntimeDTO();
        if (this.regJakartarsServiceRuntime != null) {
            newDto.serviceDTO = DTOConverter.toServiceReferenceDTO(this.regJakartarsServiceRuntime.getReference());
            newDto.serviceDTO.properties.putAll(properties);
        } else {
            newDto.serviceDTO = new ServiceReferenceDTO();
            newDto.serviceDTO.properties = properties;
            newDto.serviceDTO.bundle = this.context.getBundle().getBundleId();
            newDto.serviceDTO.id = -1L;
            newDto.serviceDTO.usingBundles = new long[0];
        }
        ArrayList<ApplicationDTO> appDTOList = new ArrayList<ApplicationDTO>();
        ArrayList<FailedApplicationDTO> failedAppDTOList = new ArrayList<FailedApplicationDTO>();
        for (JerseyApplicationProvider jerseyApplicationProvider : applications) {
            BaseApplicationDTO appDTO = jerseyApplicationProvider.getApplicationDTO();
            if (appDTO instanceof ApplicationDTO) {
                ApplicationDTO curDTO = (ApplicationDTO)appDTO;
                if (curDTO.name.equals(".default") || curDTO.base.equals("/")) {
                    newDto.defaultApplication = curDTO;
                    continue;
                }
                appDTOList.add(curDTO);
                continue;
            }
            if (appDTO instanceof FailedApplicationDTO) {
                failedAppDTOList.add((FailedApplicationDTO)appDTO);
                continue;
            }
            this.logger.severe("The application " + jerseyApplicationProvider.getId() + " had an invalid dto.");
        }
        newDto.applicationDTOs = (ApplicationDTO[])appDTOList.toArray(ApplicationDTO[]::new);
        newDto.failedApplicationDTOs = (FailedApplicationDTO[])failedAppDTOList.toArray(FailedApplicationDTO[]::new);
        ArrayList<FailedExtensionDTO> failedExtensions = new ArrayList<FailedExtensionDTO>();
        for (JerseyExtensionProvider jep : extensions) {
            BaseExtensionDTO dto = jep.getExtensionDTO();
            if (!(dto instanceof FailedExtensionDTO)) continue;
            failedExtensions.add((FailedExtensionDTO)dto);
        }
        newDto.failedExtensionDTOs = (FailedExtensionDTO[])failedExtensions.toArray(FailedExtensionDTO[]::new);
        ArrayList<FailedResourceDTO> arrayList = new ArrayList<FailedResourceDTO>();
        for (JerseyResourceProvider jrp : resources) {
            BaseDTO dto = jrp.getResourceDTO();
            if (!(dto instanceof FailedResourceDTO)) continue;
            arrayList.add((FailedResourceDTO)dto);
        }
        newDto.failedResourceDTOs = (FailedResourceDTO[])arrayList.toArray(FailedResourceDTO[]::new);
        this.setExtResourceForNameBinding(newDto.applicationDTOs);
        this.setExtResourceForNameBinding(new ApplicationDTO[]{newDto.defaultApplication});
        return newDto;
    }

    private void setExtResourceForNameBinding(ApplicationDTO[] apps) {
        for (ApplicationDTO aDTO : apps) {
            if (aDTO == null) continue;
            HashMap extResNameBind = new HashMap();
            for (ResourceDTO resourceDTO : aDTO.resourceDTOs) {
                for (ResourceMethodInfoDTO mDTO : resourceDTO.resourceMethods) {
                    if (mDTO.nameBindings == null || mDTO.nameBindings.length <= 0) continue;
                    for (String n : mDTO.nameBindings) {
                        for (ExtensionDTO extDTO : aDTO.extensionDTOs) {
                            if (extDTO.nameBindings == null || extDTO.nameBindings.length <= 0) continue;
                            for (String en : extDTO.nameBindings) {
                                if (!n.equals(en)) continue;
                                if (!extResNameBind.containsKey(extDTO.name)) {
                                    extResNameBind.put(extDTO.name, new HashSet());
                                }
                                ((Set)extResNameBind.get(extDTO.name)).add(resourceDTO);
                            }
                        }
                    }
                }
            }
            for (ResourceDTO resourceDTO : aDTO.extensionDTOs) {
                if (!extResNameBind.containsKey(resourceDTO.name)) continue;
                resourceDTO.filteredByName = ((Set)extResNameBind.get(resourceDTO.name)).toArray(new ResourceDTO[0]);
            }
        }
    }
}

