/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.command;

import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public abstract class DependentCommand<P, T>
extends AbstractSensinactCommand<T> {
    private AbstractSensinactCommand<P> parent;

    protected DependentCommand(AbstractSensinactCommand<P> parent) {
        this.parent = parent;
    }

    @Override
    protected Promise<T> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
        Promise<P> parentResult = DependentCommand.safeCall(this.parent, twin, modelMgr, promiseFactory);
        if (parentResult.isDone()) {
            return DependentCommand.safeCall(() -> this.call(parentResult, twin, modelMgr, promiseFactory), promiseFactory);
        }
        GatewayThread gateway = GatewayThread.getGatewayThread();
        Deferred d = promiseFactory.deferred();
        parentResult.onResolve(() -> d.resolveWith(gateway.execute(new ChildCommand(parentResult))));
        return d.getPromise();
    }

    protected abstract Promise<T> call(Promise<P> var1, SensinactDigitalTwin var2, SensinactModelManager var3, PromiseFactory var4);

    private class ChildCommand
    extends AbstractSensinactCommand<T> {
        private final Promise<P> parentResult;

        public ChildCommand(Promise<P> parentResult) {
            super(DependentCommand.this.getAccumulator());
            this.parentResult = parentResult;
        }

        @Override
        protected Promise<T> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
            return DependentCommand.this.call(this.parentResult, twin, modelMgr, promiseFactory);
        }
    }
}

