/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.resource.common.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.aries.tx.control.resource.common.impl.ConfigurationDefinedResourceFactory;
import org.apache.aries.tx.control.resource.common.impl.ResourceProviderFactoryServiceFactory;
import org.apache.aries.tx.control.resource.common.impl.TrackingResourceProviderFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceActivator<R extends AutoCloseable, F extends TrackingResourceProviderFactory<R>>
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceActivator.class);
    private ResourceProviderFactoryServiceFactory<R, F> service;
    private ConfigurationDefinedResourceFactory msf;
    private ServiceRegistration<?> reg;
    private ServiceRegistration<ManagedServiceFactory> factoryReg;

    public void start(BundleContext context) throws Exception {
        this.service = this.getServiceFactory(context);
        if (this.service != null) {
            this.reg = context.registerService(this.getAdvertisedInterface().getName(), this.service, this.getServiceProperties());
        }
        this.msf = this.getConfigurationDefinedResourceFactory(context);
        if (this.msf != null) {
            this.factoryReg = context.registerService(ManagedServiceFactory.class, (Object)this.msf, this.getMSFProperties());
        }
        if (this.service == null && this.msf == null) {
            LOG.warn("The Resource Activator class {} defined no service factory or configuration defined resources", (Object)this.getClass().getName());
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.safeUnregister(this.reg);
        this.safeUnregister(this.factoryReg);
        if (this.msf != null) {
            try {
                this.msf.stop();
            }
            catch (Exception e) {
                LOG.error("There was an error closing the Configuration Defined Resource Manager", (Throwable)e);
            }
        }
        if (this.service != null) {
            try {
                this.service.close();
            }
            catch (Exception e) {
                LOG.error("There was an error closing the ResourceProviderFactory", (Throwable)e);
            }
        }
    }

    private void safeUnregister(ServiceRegistration<?> reg) {
        if (reg != null) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected Dictionary<String, ?> getMSFProperties() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", this.getMSFPid());
        return props;
    }

    protected ResourceProviderFactoryServiceFactory<R, F> getServiceFactory(BundleContext context) {
        return null;
    }

    protected Class<? super F> getAdvertisedInterface() {
        throw new UnsupportedOperationException("Resource factories are not supported");
    }

    protected Dictionary<String, Object> getServiceProperties() {
        throw new UnsupportedOperationException("Resource factories are not supported");
    }

    protected ConfigurationDefinedResourceFactory getConfigurationDefinedResourceFactory(BundleContext context) {
        return null;
    }

    protected String getMSFPid() {
        throw new UnsupportedOperationException("Configuration defined resources are not supported");
    }
}

