/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.resource.common.impl;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.aries.tx.control.resource.common.impl.TrackingResourceProviderFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public abstract class ResourceProviderFactoryServiceFactory<R extends AutoCloseable, T extends TrackingResourceProviderFactory<R>>
implements ServiceFactory<TrackingResourceProviderFactory<R>> {
    Set<TrackingResourceProviderFactory<R>> factories = new CopyOnWriteArraySet<TrackingResourceProviderFactory<R>>();

    public TrackingResourceProviderFactory<R> getService(Bundle bundle, ServiceRegistration<TrackingResourceProviderFactory<R>> registration) {
        TrackingResourceProviderFactory<R> factory = this.getTrackingResourceManagerProviderFactory();
        this.factories.add(factory);
        return factory;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<TrackingResourceProviderFactory<R>> registration, TrackingResourceProviderFactory<R> service) {
        this.factories.remove(service);
        service.closeAll();
    }

    public void close() {
        this.factories.stream().forEach(r -> r.closeAll());
    }

    protected abstract TrackingResourceProviderFactory<R> getTrackingResourceManagerProviderFactory();
}

