/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.gateway.geojson.Coordinates;
import org.eclipse.sensinact.gateway.geojson.GeoJsonType;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EQueryType;
import org.eclipse.sensinact.northbound.query.api.EReadWriteMode;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.dto.SensinactPath;
import org.eclipse.sensinact.northbound.query.dto.query.AccessMethodCallParameterDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryActDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryDescribeDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryGetDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QuerySetDTO;
import org.eclipse.sensinact.northbound.query.dto.query.WrappedAccessMethodCallParametersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.AccessMethodDTO;
import org.eclipse.sensinact.northbound.query.dto.result.AccessMethodParameterDTO;
import org.eclipse.sensinact.northbound.query.dto.result.CompleteProviderDescriptionDTO;
import org.eclipse.sensinact.northbound.query.dto.result.MetadataDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeProviderDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeResourceDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeServiceDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseGetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseSetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultActDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultDescribeProvidersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListProvidersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ShortResourceDescriptionDTO;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SerializationTest {
    private final ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true)).build();

    @Test
    void testAct() throws Exception {
        QueryActDTO query = new QueryActDTO();
        Assertions.assertEquals((Object)EQueryType.ACT, (Object)query.operation);
        query.requestId = "abc";
        query.uri = new SensinactPath("provider", "svc", "rc");
        query.parameters = Map.of("arg1", 42, "arg2", "abc");
        QueryActDTO parsedQuery = (QueryActDTO)this.mapper.readValue(this.mapper.writeValueAsString((Object)query), QueryActDTO.class);
        Assertions.assertEquals((Object)query.operation, (Object)parsedQuery.operation);
        Assertions.assertEquals((Object)query.requestId, (Object)parsedQuery.requestId);
        Assertions.assertEquals((Object)query.uri, (Object)parsedQuery.uri);
        Assertions.assertEquals((Object)query.parameters, (Object)parsedQuery.parameters);
        Map rawQuery = (Map)this.mapper.convertValue((Object)query, Map.class);
        AccessMethodCallParameterDTO arg1 = new AccessMethodCallParameterDTO();
        arg1.name = "arg1";
        arg1.type = Integer.class.getName();
        arg1.value = 42;
        AccessMethodCallParameterDTO arg2 = new AccessMethodCallParameterDTO();
        arg2.name = "arg2";
        arg2.type = String.class.getName();
        arg2.value = "abc";
        rawQuery.put("parameters", List.of(arg1, arg2));
        QueryActDTO parsedRawQuery = (QueryActDTO)this.mapper.readValue(this.mapper.writeValueAsString((Object)rawQuery), QueryActDTO.class);
        Assertions.assertEquals((Object)query.operation, (Object)parsedRawQuery.operation);
        Assertions.assertEquals((Object)query.requestId, (Object)parsedRawQuery.requestId);
        Assertions.assertEquals((Object)query.uri, (Object)parsedRawQuery.uri);
        Assertions.assertEquals((Object)query.parameters, (Object)parsedRawQuery.parameters);
        ResultActDTO result = new ResultActDTO();
        Assertions.assertEquals((Object)EResultType.ACT_RESPONSE, (Object)result.type);
        result.statusCode = 200;
        result.error = "abc";
        result.requestId = query.requestId;
        result.uri = query.uri.toUri();
        result.response = 42;
        ResultActDTO parsedResult = (ResultActDTO)this.mapper.readValue(this.mapper.writeValueAsString((Object)result), ResultActDTO.class);
        Assertions.assertEquals((Object)result.type, (Object)parsedResult.type);
        Assertions.assertEquals((int)result.statusCode, (int)parsedResult.statusCode);
        Assertions.assertEquals((Object)result.error, (Object)parsedResult.error);
        Assertions.assertEquals((Object)result.requestId, (Object)parsedResult.requestId);
        Assertions.assertEquals((Object)result.uri, (Object)parsedResult.uri);
        Assertions.assertEquals((Object)result.response, (Object)parsedResult.response);
    }

    @Test
    void testDescribeResource() throws Exception {
        QueryDescribeDTO query = new QueryDescribeDTO();
        Assertions.assertEquals((Object)EQueryType.DESCRIBE, (Object)query.operation);
        query.requestId = "abc";
        query.filter = "(PROVIDER=*)";
        query.filterLanguage = "ldap";
        query.uri = new SensinactPath("provider", "svc", "rc");
        Assertions.assertTrue((boolean)query.uri.targetsSpecificResource());
        QueryDescribeDTO parsedQuery = (QueryDescribeDTO)this.mapper.readValue(this.mapper.writeValueAsString((Object)query), QueryDescribeDTO.class);
        Assertions.assertEquals((Object)query.operation, (Object)parsedQuery.operation);
        Assertions.assertEquals((Object)query.requestId, (Object)parsedQuery.requestId);
        Assertions.assertEquals((Object)query.filter, (Object)parsedQuery.filter);
        Assertions.assertEquals((Object)query.filterLanguage, (Object)parsedQuery.filterLanguage);
        Assertions.assertEquals((Object)query.uri, (Object)parsedQuery.uri);
        TypedResponse rcDescribe = new TypedResponse(EResultType.DESCRIBE_RESOURCE);
        Assertions.assertEquals((Object)EResultType.DESCRIBE_RESOURCE, (Object)rcDescribe.type);
        rcDescribe.statusCode = 200;
        rcDescribe.error = "abc";
        rcDescribe.requestId = query.requestId;
        rcDescribe.uri = query.uri.toUri();
        rcDescribe.response = new ResponseDescribeResourceDTO();
        ((ResponseDescribeResourceDTO)rcDescribe.response).name = "rc";
        ((ResponseDescribeResourceDTO)rcDescribe.response).type = ResourceType.PROPERTY;
        MetadataDTO metadata = new MetadataDTO();
        metadata.name = "meta";
        metadata.type = Integer.class.getName();
        metadata.value = 42;
        ((ResponseDescribeResourceDTO)rcDescribe.response).attributes = List.of(metadata);
        AccessMethodDTO method = new AccessMethodDTO();
        method.name = "ACT";
        AccessMethodParameterDTO param = new AccessMethodParameterDTO();
        param.name = "name";
        param.constraints = new String[]{"constraint"};
        param.fixed = false;
        param.type = String.class.getName();
        method.parameters = List.of(param);
        ((ResponseDescribeResourceDTO)rcDescribe.response).accessMethods = List.of(method);
        TypedResponse parsedResult = (TypedResponse)this.mapper.readValue(this.mapper.writeValueAsString((Object)rcDescribe), TypedResponse.class);
        Assertions.assertEquals((Object)rcDescribe.type, (Object)parsedResult.type);
        Assertions.assertEquals((int)rcDescribe.statusCode, (int)parsedResult.statusCode);
        Assertions.assertEquals((Object)rcDescribe.error, (Object)parsedResult.error);
        Assertions.assertEquals((Object)rcDescribe.requestId, (Object)parsedResult.requestId);
        Assertions.assertEquals((Object)rcDescribe.uri, (Object)parsedResult.uri);
        Assertions.assertEquals((Object)((ResponseDescribeResourceDTO)rcDescribe.response).name, (Object)((ResponseDescribeResourceDTO)parsedResult.response).name);
        Assertions.assertEquals((Object)((ResponseDescribeResourceDTO)rcDescribe.response).type, (Object)((ResponseDescribeResourceDTO)parsedResult.response).type);
        Assertions.assertEquals((int)((ResponseDescribeResourceDTO)rcDescribe.response).attributes.size(), (int)((ResponseDescribeResourceDTO)parsedResult.response).attributes.size());
        MetadataDTO parsedMetadata = (MetadataDTO)((ResponseDescribeResourceDTO)parsedResult.response).attributes.get(0);
        Assertions.assertEquals((Object)metadata.name, (Object)parsedMetadata.name);
        Assertions.assertEquals((Object)metadata.type, (Object)parsedMetadata.type);
        Assertions.assertEquals((Object)metadata.value, (Object)parsedMetadata.value);
        Assertions.assertEquals((int)((ResponseDescribeResourceDTO)rcDescribe.response).accessMethods.size(), (int)((ResponseDescribeResourceDTO)parsedResult.response).accessMethods.size());
        AccessMethodDTO parsedMethod = (AccessMethodDTO)((ResponseDescribeResourceDTO)parsedResult.response).accessMethods.get(0);
        Assertions.assertEquals((Object)method.name, (Object)parsedMethod.name);
        Assertions.assertEquals((int)method.parameters.size(), (int)parsedMethod.parameters.size());
        AccessMethodParameterDTO parsedParam = (AccessMethodParameterDTO)parsedMethod.parameters.get(0);
        Assertions.assertEquals((Object)param.name, (Object)parsedParam.name);
        Assertions.assertArrayEquals((Object[])param.constraints, (Object[])parsedParam.constraints);
        Assertions.assertEquals((Object)param.fixed, (Object)parsedParam.fixed);
        Assertions.assertEquals((Object)param.type, (Object)parsedParam.type);
    }

    @Test
    void testDescribeService() throws Exception {
        QueryDescribeDTO query = new QueryDescribeDTO();
        Assertions.assertEquals((Object)EQueryType.DESCRIBE, (Object)query.operation);
        query.requestId = "abc";
        query.filter = "(PROVIDER=*)";
        query.filterLanguage = "ldap";
        query.uri = new SensinactPath("provider", "svc");
        Assertions.assertTrue((boolean)query.uri.targetsSpecificService());
        TypedResponse svcDescribe = new TypedResponse(EResultType.DESCRIBE_SERVICE);
        Assertions.assertEquals((Object)EResultType.DESCRIBE_SERVICE, (Object)svcDescribe.type);
        svcDescribe.statusCode = 200;
        svcDescribe.error = "abc";
        svcDescribe.requestId = query.requestId;
        svcDescribe.uri = query.uri.toUri();
        svcDescribe.response = new ResponseDescribeServiceDTO();
        ((ResponseDescribeServiceDTO)svcDescribe.response).name = "svc";
        ShortResourceDescriptionDTO rcDesc = new ShortResourceDescriptionDTO();
        rcDesc.name = "rc";
        rcDesc.rws = EReadWriteMode.RW;
        rcDesc.type = ResourceType.PROPERTY;
        ((ResponseDescribeServiceDTO)svcDescribe.response).resources = List.of(rcDesc);
        TypedResponse parsedResult = (TypedResponse)this.mapper.readValue(this.mapper.writeValueAsString((Object)svcDescribe), TypedResponse.class);
        Assertions.assertEquals((Object)svcDescribe.type, (Object)parsedResult.type);
        Assertions.assertEquals((int)svcDescribe.statusCode, (int)parsedResult.statusCode);
        Assertions.assertEquals((Object)svcDescribe.error, (Object)parsedResult.error);
        Assertions.assertEquals((Object)svcDescribe.requestId, (Object)parsedResult.requestId);
        Assertions.assertEquals((Object)svcDescribe.uri, (Object)parsedResult.uri);
        Assertions.assertEquals((Object)((ResponseDescribeServiceDTO)svcDescribe.response).name, (Object)((ResponseDescribeServiceDTO)parsedResult.response).name);
        Assertions.assertEquals((int)((ResponseDescribeServiceDTO)svcDescribe.response).resources.size(), (int)((ResponseDescribeServiceDTO)parsedResult.response).resources.size());
        ShortResourceDescriptionDTO parsedRc = (ShortResourceDescriptionDTO)((ResponseDescribeServiceDTO)parsedResult.response).resources.get(0);
        Assertions.assertEquals((Object)rcDesc.name, (Object)parsedRc.name);
        Assertions.assertEquals((Object)rcDesc.rws, (Object)parsedRc.rws);
        Assertions.assertEquals((Object)rcDesc.type, (Object)parsedRc.type);
    }

    @Test
    void testDescribeProvider() throws Exception {
        QueryDescribeDTO query = new QueryDescribeDTO();
        Assertions.assertEquals((Object)EQueryType.DESCRIBE, (Object)query.operation);
        query.requestId = "abc";
        query.filter = "(PROVIDER=*)";
        query.filterLanguage = "ldap";
        query.uri = new SensinactPath("provider");
        Assertions.assertTrue((boolean)query.uri.targetsSpecificProvider());
        TypedResponse provDescribe = new TypedResponse(EResultType.DESCRIBE_PROVIDER);
        Assertions.assertEquals((Object)EResultType.DESCRIBE_PROVIDER, (Object)provDescribe.type);
        provDescribe.statusCode = 200;
        provDescribe.error = "abc";
        provDescribe.requestId = query.requestId;
        provDescribe.uri = query.uri.toUri();
        provDescribe.response = new ResponseDescribeProviderDTO();
        ((ResponseDescribeProviderDTO)provDescribe.response).name = "provider";
        ((ResponseDescribeProviderDTO)provDescribe.response).services = List.of("admin", "svc");
        TypedResponse parsedResult = (TypedResponse)this.mapper.readValue(this.mapper.writeValueAsString((Object)provDescribe), TypedResponse.class);
        Assertions.assertEquals((Object)provDescribe.type, (Object)parsedResult.type);
        Assertions.assertEquals((int)provDescribe.statusCode, (int)parsedResult.statusCode);
        Assertions.assertEquals((Object)provDescribe.error, (Object)parsedResult.error);
        Assertions.assertEquals((Object)provDescribe.requestId, (Object)parsedResult.requestId);
        Assertions.assertEquals((Object)provDescribe.uri, (Object)parsedResult.uri);
        Assertions.assertEquals((Object)((ResponseDescribeProviderDTO)provDescribe.response).name, (Object)((ResponseDescribeProviderDTO)parsedResult.response).name);
        Assertions.assertEquals((Object)((ResponseDescribeProviderDTO)provDescribe.response).services, (Object)((ResponseDescribeProviderDTO)parsedResult.response).services);
    }

    @Test
    void testDescribeProviders() throws Exception {
        QueryDescribeDTO query = new QueryDescribeDTO();
        Assertions.assertEquals((Object)EQueryType.DESCRIBE, (Object)query.operation);
        query.requestId = "abc";
        query.filter = "(PROVIDER=*)";
        query.filterLanguage = "ldap";
        query.uri = new SensinactPath();
        Assertions.assertEquals((Object)"/", (Object)query.uri.toUri());
        ResultDescribeProvidersDTO provDescribe = new ResultDescribeProvidersDTO();
        Assertions.assertEquals((Object)EResultType.COMPLETE_LIST, (Object)provDescribe.type);
        provDescribe.statusCode = 200;
        provDescribe.error = "abc";
        provDescribe.requestId = query.requestId;
        provDescribe.uri = query.uri.toUri();
        CompleteProviderDescriptionDTO provider = new CompleteProviderDescriptionDTO();
        provider.name = "provider123";
        provider.icon = "icon123";
        Point location = new Point();
        location.coordinates = new Coordinates();
        location.coordinates.latitude = 45.0;
        location.coordinates.longitude = 5.0;
        provider.location = location;
        ResponseDescribeServiceDTO admin = new ResponseDescribeServiceDTO();
        admin.name = "admin";
        ShortResourceDescriptionDTO locationRc = new ShortResourceDescriptionDTO();
        locationRc.name = "location";
        locationRc.rws = EReadWriteMode.RO;
        locationRc.type = ResourceType.PROPERTY;
        admin.resources = List.of(locationRc);
        provider.services = List.of(admin);
        provDescribe.providers = List.of(provider);
        ResultDescribeProvidersDTO parsedResult = (ResultDescribeProvidersDTO)this.mapper.readValue(this.mapper.writeValueAsString((Object)provDescribe), ResultDescribeProvidersDTO.class);
        Assertions.assertEquals((Object)provDescribe.type, (Object)parsedResult.type);
        Assertions.assertEquals((int)provDescribe.statusCode, (int)parsedResult.statusCode);
        Assertions.assertEquals((Object)provDescribe.error, (Object)parsedResult.error);
        Assertions.assertEquals((Object)provDescribe.requestId, (Object)parsedResult.requestId);
        Assertions.assertEquals((Object)provDescribe.uri, (Object)parsedResult.uri);
        Assertions.assertEquals((int)provDescribe.providers.size(), (int)parsedResult.providers.size());
        CompleteProviderDescriptionDTO parsedProvider = (CompleteProviderDescriptionDTO)parsedResult.providers.get(0);
        Assertions.assertEquals((Object)provider.name, (Object)parsedProvider.name);
        Assertions.assertEquals((Object)provider.icon, (Object)parsedProvider.icon);
        Assertions.assertEquals((Object)GeoJsonType.Point, (Object)parsedProvider.location.type);
        Point parsedLocation = (Point)parsedProvider.location;
        Assertions.assertEquals((double)location.coordinates.latitude, (double)parsedLocation.coordinates.latitude);
        Assertions.assertEquals((double)location.coordinates.longitude, (double)parsedLocation.coordinates.longitude);
        Assertions.assertEquals((int)provider.services.size(), (int)parsedProvider.services.size());
        ResponseDescribeServiceDTO parsedService = (ResponseDescribeServiceDTO)parsedProvider.services.get(0);
        Assertions.assertEquals((Object)admin.name, (Object)parsedService.name);
        Assertions.assertEquals((int)admin.resources.size(), (int)parsedService.resources.size());
        ShortResourceDescriptionDTO parsedRc = (ShortResourceDescriptionDTO)parsedService.resources.get(0);
        Assertions.assertEquals((Object)locationRc.name, (Object)parsedRc.name);
        Assertions.assertEquals((Object)locationRc.rws, (Object)parsedRc.rws);
        Assertions.assertEquals((Object)locationRc.type, (Object)parsedRc.type);
    }

    @Test
    void testGet() throws Exception {
        QueryGetDTO query = new QueryGetDTO();
        Assertions.assertEquals((Object)EQueryType.GET, (Object)query.operation);
        query.requestId = "abc";
        query.uri = new SensinactPath("provider", "svc", "rc");
        QueryGetDTO parsedQuery = (QueryGetDTO)this.mapper.readValue(this.mapper.writeValueAsString((Object)query), QueryGetDTO.class);
        Assertions.assertEquals((Object)query.operation, (Object)parsedQuery.operation);
        Assertions.assertEquals((Object)query.requestId, (Object)parsedQuery.requestId);
        Assertions.assertEquals((Object)query.uri, (Object)parsedQuery.uri);
        TypedResponse getRc = new TypedResponse(EResultType.GET_RESPONSE);
        Assertions.assertEquals((Object)EResultType.GET_RESPONSE, (Object)getRc.type);
        getRc.statusCode = 200;
        getRc.error = "abc";
        getRc.requestId = query.requestId;
        getRc.uri = query.uri.toUri();
        getRc.response = new ResponseGetDTO();
        ((ResponseGetDTO)getRc.response).name = "rc";
        ((ResponseGetDTO)getRc.response).timestamp = Instant.now().toEpochMilli();
        ((ResponseGetDTO)getRc.response).type = Integer.class.getName();
        ((ResponseGetDTO)getRc.response).value = 42;
        TypedResponse parsedResult = (TypedResponse)this.mapper.readValue(this.mapper.writeValueAsString((Object)getRc), TypedResponse.class);
        Assertions.assertEquals((Object)getRc.type, (Object)parsedResult.type);
        Assertions.assertEquals((int)getRc.statusCode, (int)parsedResult.statusCode);
        Assertions.assertEquals((Object)getRc.error, (Object)parsedResult.error);
        Assertions.assertEquals((Object)getRc.requestId, (Object)parsedResult.requestId);
        Assertions.assertEquals((Object)getRc.uri, (Object)parsedResult.uri);
        Assertions.assertEquals((Object)((ResponseGetDTO)getRc.response).name, (Object)((ResponseGetDTO)parsedResult.response).name);
        Assertions.assertEquals((long)((ResponseGetDTO)getRc.response).timestamp, (long)((ResponseGetDTO)parsedResult.response).timestamp);
        Assertions.assertEquals((Object)((ResponseGetDTO)getRc.response).type, (Object)((ResponseGetDTO)parsedResult.response).type);
        Assertions.assertEquals((Object)((ResponseGetDTO)getRc.response).value, (Object)((ResponseGetDTO)parsedResult.response).value);
    }

    @Test
    void testSet() throws Exception {
        QuerySetDTO query = new QuerySetDTO();
        Assertions.assertEquals((Object)EQueryType.SET, (Object)query.operation);
        query.requestId = "abc";
        query.uri = new SensinactPath("provider", "svc", "rc");
        query.value = 42;
        query.valueType = Integer.class.getName();
        QuerySetDTO parsedQuery = (QuerySetDTO)this.mapper.readValue(this.mapper.writeValueAsString((Object)query), QuerySetDTO.class);
        Assertions.assertEquals((Object)query.operation, (Object)parsedQuery.operation);
        Assertions.assertEquals((Object)query.requestId, (Object)parsedQuery.requestId);
        Assertions.assertEquals((Object)query.uri, (Object)parsedQuery.uri);
        Assertions.assertEquals((Object)query.value, (Object)parsedQuery.value);
        Assertions.assertEquals((Object)query.valueType, (Object)parsedQuery.valueType);
        TypedResponse setRc = new TypedResponse(EResultType.SET_RESPONSE);
        Assertions.assertEquals((Object)EResultType.SET_RESPONSE, (Object)setRc.type);
        setRc.statusCode = 200;
        setRc.error = "abc";
        setRc.requestId = query.requestId;
        setRc.uri = query.uri.toUri();
        setRc.response = new ResponseSetDTO();
        ((ResponseSetDTO)setRc.response).name = "rc";
        ((ResponseSetDTO)setRc.response).timestamp = Instant.now().toEpochMilli();
        ((ResponseSetDTO)setRc.response).type = Integer.class.getName();
        ((ResponseSetDTO)setRc.response).value = 42;
        TypedResponse parsedResult = (TypedResponse)this.mapper.readValue(this.mapper.writeValueAsString((Object)setRc), TypedResponse.class);
        Assertions.assertEquals((Object)setRc.type, (Object)parsedResult.type);
        Assertions.assertEquals((int)setRc.statusCode, (int)parsedResult.statusCode);
        Assertions.assertEquals((Object)setRc.error, (Object)parsedResult.error);
        Assertions.assertEquals((Object)setRc.requestId, (Object)parsedResult.requestId);
        Assertions.assertEquals((Object)setRc.uri, (Object)parsedResult.uri);
        Assertions.assertEquals((Object)((ResponseSetDTO)setRc.response).name, (Object)((ResponseGetDTO)parsedResult.response).name);
        Assertions.assertEquals((long)((ResponseSetDTO)setRc.response).timestamp, (long)((ResponseGetDTO)parsedResult.response).timestamp);
        Assertions.assertEquals((Object)((ResponseSetDTO)setRc.response).type, (Object)((ResponseGetDTO)parsedResult.response).type);
        Assertions.assertEquals((Object)((ResponseSetDTO)setRc.response).value, (Object)((ResponseGetDTO)parsedResult.response).value);
    }

    @Test
    void testWrappedAccessMethodCallParametesrDTO() throws JsonProcessingException {
        AccessMethodCallParameterDTO arg1 = new AccessMethodCallParameterDTO();
        arg1.name = "arg1";
        arg1.type = Integer.class.getName();
        arg1.value = 42;
        AccessMethodCallParameterDTO arg2 = new AccessMethodCallParameterDTO();
        arg2.name = "arg2";
        arg2.type = String.class.getName();
        arg2.value = "abc";
        List<AccessMethodCallParameterDTO> parameters = List.of(arg1, arg2);
        WrappedAccessMethodCallParametersDTO dto = new WrappedAccessMethodCallParametersDTO();
        dto.parameters = parameters;
        String s = this.mapper.writeValueAsString((Object)dto);
        WrappedAccessMethodCallParametersDTO read = (WrappedAccessMethodCallParametersDTO)this.mapper.readValue(s, WrappedAccessMethodCallParametersDTO.class);
        Assertions.assertEquals((Object)((AccessMethodCallParameterDTO)dto.parameters.get((int)0)).name, (Object)((AccessMethodCallParameterDTO)read.parameters.get((int)0)).name);
        s = this.mapper.writeValueAsString(parameters);
        WrappedAccessMethodCallParametersDTO read2 = (WrappedAccessMethodCallParametersDTO)this.mapper.readValue(s, WrappedAccessMethodCallParametersDTO.class);
        Assertions.assertEquals((Object)((AccessMethodCallParameterDTO)dto.parameters.get((int)0)).name, (Object)((AccessMethodCallParameterDTO)read2.parameters.get((int)0)).name);
    }

    @Test
    void testTypedResponseSerialization() throws JsonProcessingException {
        TypedResponse original = new TypedResponse(EResultType.GET_RESPONSE);
        original.statusCode = 218;
        original.uri = "a/b/c";
        original.response = new ResponseGetDTO();
        ((ResponseGetDTO)original.response).name = "c";
        ((ResponseGetDTO)original.response).type = Integer.class.getName();
        ((ResponseGetDTO)original.response).timestamp = Instant.now().toEpochMilli();
        ((ResponseGetDTO)original.response).value = 42;
        String strJson = this.mapper.writeValueAsString((Object)original);
        int idx = -1;
        int typeKeyOccurrences = -1;
        do {
            ++typeKeyOccurrences;
        } while ((idx = strJson.indexOf("\"type\"", idx + 1)) != -1);
        Assertions.assertEquals((int)2, (int)typeKeyOccurrences);
        TypedResponse parsed = (TypedResponse)this.mapper.readValue(strJson, TypedResponse.class);
        Assertions.assertEquals((Object)original.error, (Object)parsed.error);
        Assertions.assertEquals((Object)original.requestId, (Object)parsed.requestId);
        Assertions.assertEquals((int)original.statusCode, (int)parsed.statusCode);
        Assertions.assertEquals(((ResponseGetDTO)original.response).getClass(), parsed.response.getClass());
    }

    @Test
    void testProvidersList() throws JsonProcessingException {
        ResultListProvidersDTO original = new ResultListProvidersDTO();
        original.statusCode = 200;
        original.uri = "/";
        original.providers = List.of("toto", "titi", "tutu");
        String strJson = this.mapper.writeValueAsString((Object)original);
        ResultListProvidersDTO typedParsed = (ResultListProvidersDTO)this.mapper.readValue(strJson, ResultListProvidersDTO.class);
        Assertions.assertEquals((Object)original.type, (Object)typedParsed.type);
        Assertions.assertEquals((int)original.statusCode, (int)typedParsed.statusCode);
        Assertions.assertEquals((Object)original.uri, (Object)typedParsed.uri);
        Assertions.assertEquals((Object)original.providers, (Object)typedParsed.providers);
        AbstractResultDTO abstractParsed = (AbstractResultDTO)this.mapper.readValue(strJson, AbstractResultDTO.class);
        Assertions.assertEquals((Object)original.type, (Object)abstractParsed.type);
        Assertions.assertEquals((int)original.statusCode, (int)abstractParsed.statusCode);
        Assertions.assertEquals((Object)original.uri, (Object)abstractParsed.uri);
        Assertions.assertEquals((Object)original.providers, (Object)((ResultListProvidersDTO)abstractParsed).providers);
    }
}

