/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.websocket.integration;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class WSHandler {
    Consumer<Session> onConnect;
    BiConsumer<Session, Integer> onClose;
    BiConsumer<Session, String> onMessage;
    BiConsumer<Session, Throwable> onError;

    @OnWebSocketConnect
    public void onConnect(Session session) {
        if (this.onConnect != null) {
            this.onConnect.accept(session);
        }
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        if (this.onClose != null) {
            this.onClose.accept(session, statusCode);
        }
    }

    @OnWebSocketMessage
    public void onMsg(Session session, String msg) {
        if (this.onMessage != null) {
            this.onMessage.accept(session, msg);
        }
    }

    @OnWebSocketError
    public void onError(Session session, Throwable t) {
        if (this.onError != null) {
            this.onError.accept(session, t);
        }
    }
}

