/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.websocket.integration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Hashtable;
import java.util.Random;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.exceptions.UpgradeException;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.northbound.query.api.AbstractQueryDTO;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.dto.SensinactPath;
import org.eclipse.sensinact.northbound.query.dto.query.QueryGetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseGetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.eclipse.sensinact.northbound.security.api.Authenticator;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.websocket.integration.WSHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"AUTHENTICATED_ONLY"})})
public class SecureWebSocketTest {
    final ObjectMapper mapper = new ObjectMapper();
    static URI wsUri;

    @BeforeAll
    static void setup() throws URISyntaxException {
        wsUri = new URI("ws://localhost:14001/ws/sensinact");
    }

    public GenericDto makeDto(String provider, String service, String resource, Object value, Class<?> type) {
        GenericDto dto = new GenericDto();
        dto.model = provider;
        dto.provider = provider;
        dto.service = service;
        dto.resource = resource;
        dto.value = value;
        dto.type = type;
        return dto;
    }

    void sendDTO(Session session, AbstractQueryDTO dto) {
        try {
            session.getRemote().sendString(this.mapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            Assertions.fail((String)"Error sending DTO", (Throwable)e);
        }
    }

    @Test
    void testConnectNoCredentialsOrAuthenticators() throws Exception {
        WSHandler handler = new WSHandler();
        try (WSClient client = new WSClient();){
            client.ws.connect((Object)handler, wsUri).join();
            Assertions.fail((String)"Should fail to connect");
        }
        catch (CompletionException ce) {
            Throwable cause = ce.getCause();
            Assertions.assertInstanceOf(UpgradeException.class, (Object)cause);
            Assertions.assertEquals((int)503, (int)((UpgradeException)cause).getResponseStatusCode());
        }
    }

    @Test
    void testConnectNoCredentials(@InjectBundleContext BundleContext ctx) throws Exception {
        TestAuthenticator auth = new TestAuthenticator("test_realm", Authenticator.Scheme.USER_PASSWORD, "test", "testPw");
        ctx.registerService(Authenticator.class, (Object)auth, new Hashtable());
        WSHandler handler = new WSHandler();
        try (WSClient client = new WSClient();){
            client.ws.connect((Object)handler, wsUri).join();
            Assertions.fail((String)"Should fail to connect");
        }
        catch (CompletionException ce) {
            Throwable cause = ce.getCause();
            Assertions.assertInstanceOf(UpgradeException.class, (Object)cause);
            Assertions.assertEquals((int)401, (int)((UpgradeException)cause).getResponseStatusCode());
        }
    }

    @Test
    void testConnectBadCredentials(@InjectBundleContext BundleContext ctx) throws Exception {
        TestAuthenticator auth = new TestAuthenticator("test_realm", Authenticator.Scheme.USER_PASSWORD, "test", "testPw");
        ctx.registerService(Authenticator.class, (Object)auth, new Hashtable());
        ClientUpgradeRequest req = new ClientUpgradeRequest();
        req.setHeader("Authorization", Base64.getUrlEncoder().encodeToString("test:incorrect".getBytes(StandardCharsets.UTF_8)));
        WSHandler handler = new WSHandler();
        try (WSClient client = new WSClient();){
            client.ws.connect((Object)handler, wsUri).join();
            Assertions.fail((String)"Should fail to connect");
        }
        catch (CompletionException ce) {
            Throwable cause = ce.getCause();
            Assertions.assertInstanceOf(UpgradeException.class, (Object)cause);
            Assertions.assertEquals((int)401, (int)((UpgradeException)cause).getResponseStatusCode());
        }
    }

    @Test
    void testConnectBasicCredentials(@InjectBundleContext BundleContext ctx) throws Exception {
        TestAuthenticator auth = new TestAuthenticator("test_realm", Authenticator.Scheme.USER_PASSWORD, "test", "testPw");
        ctx.registerService(Authenticator.class, (Object)auth, new Hashtable());
        WSHandler handler = new WSHandler();
        CountDownLatch barrier = new CountDownLatch(1);
        QueryGetDTO query = new QueryGetDTO();
        query.uri = new SensinactPath("sensiNact", "admin", "friendlyName");
        query.requestId = String.valueOf(new Random().nextInt());
        handler.onConnect = s -> this.sendDTO((Session)s, (AbstractQueryDTO)query);
        AtomicReference error = new AtomicReference();
        handler.onError = (s, t) -> {
            error.set(t);
            barrier.countDown();
        };
        handler.onClose = (s, c) -> barrier.countDown();
        AtomicReference resultHolder = new AtomicReference();
        handler.onMessage = (s, m) -> {
            try {
                resultHolder.set((AbstractResultDTO)this.mapper.readValue(m, AbstractResultDTO.class));
                barrier.countDown();
            }
            catch (JsonProcessingException e) {
                Assertions.fail((String)"Error parsing WS response", (Throwable)e);
            }
        };
        ClientUpgradeRequest req = new ClientUpgradeRequest();
        req.setHeader("Authorization", "Basic " + Base64.getUrlEncoder().encodeToString("test:testPw".getBytes(StandardCharsets.UTF_8)));
        try (WSClient client = new WSClient();){
            client.ws.connect((Object)handler, wsUri, req).get();
            barrier.await();
        }
        if (error.get() != null) {
            Assertions.fail((Throwable)((Throwable)error.get()));
        }
        AbstractResultDTO result = (AbstractResultDTO)resultHolder.get();
        Assertions.assertNotNull((Object)result, (String)"No WS query result");
        Assertions.assertEquals((int)200, (int)result.statusCode);
        Assertions.assertEquals((Object)query.requestId, (Object)result.requestId);
        Assertions.assertEquals((Object)EResultType.GET_RESPONSE, (Object)result.type);
        TypedResponse typed = (TypedResponse)result;
        Assertions.assertEquals((Object)"sensiNact", (Object)((ResponseGetDTO)typed.response).value);
    }

    @Test
    void testConnectBearerCredentials(@InjectBundleContext BundleContext ctx) throws Exception {
        TestAuthenticator auth = new TestAuthenticator("test_realm", Authenticator.Scheme.TOKEN, null, "my_token");
        ctx.registerService(Authenticator.class, (Object)auth, new Hashtable());
        WSHandler handler = new WSHandler();
        CountDownLatch barrier = new CountDownLatch(1);
        QueryGetDTO query = new QueryGetDTO();
        query.uri = new SensinactPath("sensiNact", "admin", "friendlyName");
        query.requestId = String.valueOf(new Random().nextInt());
        handler.onConnect = s -> this.sendDTO((Session)s, (AbstractQueryDTO)query);
        AtomicReference error = new AtomicReference();
        handler.onError = (s, t) -> {
            error.set(t);
            barrier.countDown();
        };
        handler.onClose = (s, c) -> barrier.countDown();
        AtomicReference resultHolder = new AtomicReference();
        handler.onMessage = (s, m) -> {
            try {
                resultHolder.set((AbstractResultDTO)this.mapper.readValue(m, AbstractResultDTO.class));
                barrier.countDown();
            }
            catch (JsonProcessingException e) {
                Assertions.fail((String)"Error parsing WS response", (Throwable)e);
            }
        };
        ClientUpgradeRequest req = new ClientUpgradeRequest();
        req.setHeader("Authorization", "Bearer my_token");
        try (WSClient client = new WSClient();){
            client.ws.connect((Object)handler, wsUri, req).get();
            barrier.await();
        }
        if (error.get() != null) {
            Assertions.fail((Throwable)((Throwable)error.get()));
        }
        AbstractResultDTO result = (AbstractResultDTO)resultHolder.get();
        Assertions.assertNotNull((Object)result, (String)"No WS query result");
        Assertions.assertEquals((int)200, (int)result.statusCode);
        Assertions.assertEquals((Object)query.requestId, (Object)result.requestId);
        Assertions.assertEquals((Object)EResultType.GET_RESPONSE, (Object)result.type);
        TypedResponse typed = (TypedResponse)result;
        Assertions.assertEquals((Object)"sensiNact", (Object)((ResponseGetDTO)typed.response).value);
    }

    class WSClient
    implements AutoCloseable {
        WebSocketClient ws = new WebSocketClient();

        public WSClient() throws Exception {
            this.ws.start();
        }

        @Override
        public void close() throws Exception {
            this.ws.stop();
            this.ws.destroy();
        }
    }

    private static class TestAuthenticator
    implements Authenticator {
        private final String realm;
        private final Authenticator.Scheme scheme;
        private final String user;
        private final String credential;
        private final UserInfo info = new UserInfo(){

            public boolean isMemberOfGroup(String group) {
                return false;
            }

            public boolean isAuthenticated() {
                return true;
            }

            public boolean isAnonymous() {
                return false;
            }

            public String getUserId() {
                return user;
            }
        };

        public TestAuthenticator(String realm, Authenticator.Scheme scheme, String user, String credential) {
            this.realm = realm;
            this.scheme = scheme;
            this.user = user;
            this.credential = credential;
        }

        public UserInfo authenticate(String user, String credential) {
            if (this.user == null && user != null) {
                return null;
            }
            if (this.user != null && !this.user.equals(user)) {
                return null;
            }
            if (!this.credential.equals(credential)) {
                return null;
            }
            return this.info;
        }

        public String getRealm() {
            return this.realm;
        }

        public Authenticator.Scheme getScheme() {
            return this.scheme;
        }
    }
}

