/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.nortbound.session.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.sensinact.nortbound.session.impl.DefaultAuthPolicy;
import org.eclipse.sensinact.nortbound.session.impl.DefaultSessionAuthorizationEngine;
import org.eclipse.sensinact.nortbound.session.impl.TestUserInfo;
import org.eclipse.sensinact.northbound.security.api.AuthorizationEngine;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class DefaultSessionAuthorizationEngineTests {
    private static final String MODEL_URI = "test/model/uri";
    private static final String MODEL = "model";
    private static final String PROVIDER = "provider";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    void testAuthorizer(DefaultAuthPolicy policy, UserInfo user, AuthorizationEngine.Authorizer.PreAuth preAuth, boolean permission, Function<Collection<String>, Collection<String>> transform) {
        DefaultSessionAuthorizationEngine engine = new DefaultSessionAuthorizationEngine(policy);
        AuthorizationEngine.Authorizer authorizer = engine.createAuthorizer(user);
        Assertions.assertEquals((Object)preAuth, (Object)authorizer.preAuthProvider(AuthorizationEngine.PermissionLevel.DESCRIBE, PROVIDER));
        Assertions.assertEquals((Object)preAuth, (Object)authorizer.preAuthService(AuthorizationEngine.PermissionLevel.DESCRIBE, PROVIDER, SERVICE));
        Assertions.assertEquals((Object)preAuth, (Object)authorizer.preAuthResource(AuthorizationEngine.PermissionLevel.DESCRIBE, PROVIDER, SERVICE, RESOURCE));
        Assertions.assertEquals((Object)permission, (Object)authorizer.hasProviderPermission(AuthorizationEngine.PermissionLevel.DESCRIBE, MODEL_URI, MODEL, PROVIDER));
        Assertions.assertEquals((Object)permission, (Object)authorizer.hasServicePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, MODEL_URI, MODEL, PROVIDER, SERVICE));
        Assertions.assertEquals((Object)permission, (Object)authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, MODEL_URI, MODEL, PROVIDER, SERVICE, RESOURCE));
        Set<String> set = Set.of(SERVICE);
        Assertions.assertEquals(transform.apply(set), (Object)authorizer.visibleServices(MODEL_URI, MODEL, PROVIDER, set));
        set = Set.of(RESOURCE);
        Assertions.assertEquals(transform.apply(set), (Object)authorizer.visibleResources(MODEL_URI, MODEL, PROVIDER, SERVICE, set));
    }

    static List<Arguments> testArgs() {
        TestUserInfo anon = new TestUserInfo("<ANON>", false);
        TestUserInfo bob = new TestUserInfo("bob", true);
        Function<Collection, Collection> copy = List::copyOf;
        Function<Collection, Collection> remove = x -> List.of();
        return List.of(Arguments.arguments((Object[])new Object[]{DefaultAuthPolicy.ALLOW_ALL, anon, AuthorizationEngine.Authorizer.PreAuth.ALLOW, true, copy}), Arguments.arguments((Object[])new Object[]{DefaultAuthPolicy.ALLOW_ALL, bob, AuthorizationEngine.Authorizer.PreAuth.ALLOW, true, copy}), Arguments.arguments((Object[])new Object[]{DefaultAuthPolicy.AUTHENTICATED_ONLY, anon, AuthorizationEngine.Authorizer.PreAuth.DENY, false, remove}), Arguments.arguments((Object[])new Object[]{DefaultAuthPolicy.AUTHENTICATED_ONLY, bob, AuthorizationEngine.Authorizer.PreAuth.ALLOW, true, copy}), Arguments.arguments((Object[])new Object[]{DefaultAuthPolicy.DENY_ALL, anon, AuthorizationEngine.Authorizer.PreAuth.DENY, false, remove}), Arguments.arguments((Object[])new Object[]{DefaultAuthPolicy.DENY_ALL, bob, AuthorizationEngine.Authorizer.PreAuth.DENY, false, remove}));
    }
}

