/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.device.factory.parser.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.southbound.device.factory.EncodingUtils;
import org.eclipse.sensinact.gateway.southbound.device.factory.IDeviceMappingParser;
import org.eclipse.sensinact.gateway.southbound.device.factory.IDeviceMappingRecord;
import org.eclipse.sensinact.gateway.southbound.device.factory.ParserException;
import org.eclipse.sensinact.gateway.southbound.device.factory.parser.json.JsonRecord;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={IDeviceMappingParser.class}, property={"sensinact.southbound.mapping.parser=json"})
public class JsonParser
implements IDeviceMappingParser {
    private ObjectMapper objectMapper = new ObjectMapper();

    public List<? extends IDeviceMappingRecord> parseRecords(byte[] rawInput, Map<String, Object> parserConfiguration, Map<String, String> context) throws ParserException {
        String base = (String)parserConfiguration.get("base");
        if (base == null || base.isBlank()) {
            base = null;
        }
        try {
            JsonNode root;
            String strEncoding = (String)parserConfiguration.get("encoding");
            if (strEncoding != null && !strEncoding.isBlank()) {
                Charset charset = Charset.forName(strEncoding);
                InputStream is = StandardCharsets.UTF_8.equals(charset) && rawInput.length > 3 ? EncodingUtils.removeBOM((byte[])rawInput) : new ByteArrayInputStream(rawInput);
                root = (JsonNode)this.objectMapper.readValue((Reader)new InputStreamReader(is, charset), JsonNode.class);
            } else {
                root = (JsonNode)this.objectMapper.readValue(rawInput, JsonNode.class);
            }
            return this.parseRecords(root, base);
        }
        catch (IllegalArgumentException e) {
            throw new ParserException("Invalid JSON input", (Throwable)e);
        }
        catch (IOException e) {
            throw new ParserException("Error parsing JSON input", (Throwable)e);
        }
    }

    private JsonNode getPath(JsonNode node, String pathPart) {
        if (node.isArray()) {
            return node.get(Integer.valueOf(pathPart).intValue());
        }
        return node.get(pathPart);
    }

    private List<JsonRecord> parseRecords(JsonNode root, String base) throws ParserException {
        JsonNode subRoot;
        if (base == null) {
            subRoot = root;
        } else {
            String[] parts = base.split("/");
            JsonNode current = root;
            for (String part : parts) {
                if (part.isBlank()) continue;
                current = this.getPath(current, part);
            }
            subRoot = current;
        }
        if (subRoot.isObject()) {
            return List.of(new JsonRecord(this.objectMapper, subRoot));
        }
        if (subRoot.isArray()) {
            ArrayList<JsonRecord> result = new ArrayList<JsonRecord>(subRoot.size());
            for (JsonNode child : subRoot) {
                result.add(new JsonRecord(this.objectMapper, child));
            }
            return result;
        }
        throw new ParserException("Unsupported JSON content: " + subRoot.getNodeType());
    }
}

