/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.history.timescale.integration;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.command.ResourceCommand;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import org.osgi.service.cm.Configuration;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.config.InjectConfiguration;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.postgresql.ds.PGSimpleDataSource;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class TimescaleHistoryTest {
    private static final Instant TS_2012 = Instant.parse("2012-01-01T00:00:00.00Z");
    private static final Instant TS_2013 = Instant.parse("2013-01-01T00:00:00.00Z");
    private static final Instant TS_2014 = Instant.parse("2014-01-01T00:00:00.00Z");
    private static JdbcDatabaseContainer<?> container;
    private Configuration historyProviderConfig;
    @InjectService
    DataUpdate push;
    @InjectService
    GatewayThread thread;

    @BeforeAll
    static void startContainer() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(TimescaleHistoryTest.class.getClassLoader());
        try {
            try {
                DockerClientFactory.lazyClient().versionCmd().exec();
            }
            catch (Throwable t2) {
                Assumptions.abort((String)"No docker executable on the path, so tests will be skipped");
            }
            container = new PostgreSQLContainer(DockerImageName.parse("timescale/timescaledb-ha").asCompatibleSubstituteFor("postgres").withTag("pg14-latest"));
            container.withDatabaseName("sensinactHistory");
            container.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @BeforeEach
    void setupTest(@InjectConfiguration(withConfig=@WithConfiguration(pid="sensinact.history.timescale", location="?")) Configuration cm) throws Exception {
        this.historyProviderConfig = cm;
        cm.update(new Hashtable<String, String>(Map.of("url", container.getJdbcUrl(), "user", container.getUsername(), ".password", container.getPassword())));
        this.waitForStart();
    }

    private void waitForStart() {
        boolean ready = false;
        long timeout = System.currentTimeMillis() + 5000L;
        Exception lastError = null;
        while (true) {
            try {
                for (String table : List.of("numeric_data", "text_data", "geo_data")) {
                    this.waitForRowCount("sensinact." + table, 0, true);
                }
                ready = true;
                lastError = null;
            }
            catch (Exception e) {
                lastError = e;
                if (!ready && System.currentTimeMillis() < timeout) continue;
            }
            break;
        }
        Assertions.assertTrue((boolean)ready, (String)("History provider setup timed out: " + lastError));
    }

    @AfterEach
    void cleanupTest() throws Exception {
        if (this.historyProviderConfig != null) {
            this.historyProviderConfig.delete();
        }
        this.thread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<Void>(){

            protected Promise<Void> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                twin.getProviders().forEach(SensinactProvider::delete);
                return promiseFactory.resolved(null);
            }
        }).getValue();
        try (Connection connection = this.getDataSource().getConnection();){
            Statement stmt = connection.createStatement();
            for (String table : List.of("numeric_data", "text_data", "geo_data")) {
                stmt.execute("DROP TABLE IF EXISTS sensinact." + table);
            }
        }
    }

    @AfterAll
    static void stopContainer() {
        if (container != null) {
            container.stop();
            container = null;
        }
    }

    private GenericDto getDto(String value, Instant timestamp) {
        GenericDto dto = new GenericDto();
        dto.model = "foo";
        dto.provider = "bar";
        dto.service = "foobar";
        dto.resource = "foofoobarbar";
        dto.value = value;
        dto.type = String.class;
        dto.timestamp = timestamp;
        return dto;
    }

    private GenericDto getDto(Integer value, Instant timestamp) {
        GenericDto dto = new GenericDto();
        dto.model = "fizz";
        dto.provider = "buzz";
        dto.service = "fizzbuzz";
        dto.resource = "fizzfizzbuzzbuzz";
        dto.value = value;
        dto.type = Integer.class;
        dto.timestamp = timestamp;
        return dto;
    }

    private GenericDto getDto(Double value, Instant timestamp) {
        GenericDto dto = new GenericDto();
        dto.model = "Bibbidi";
        dto.provider = "Bobbidi";
        dto.service = "Boo";
        dto.resource = "Magic";
        dto.value = BigDecimal.valueOf(value);
        dto.type = BigDecimal.class;
        dto.timestamp = timestamp;
        return dto;
    }

    private PGSimpleDataSource getDataSource() {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setURL(container.getJdbcUrl());
        ds.setUser(container.getUsername());
        ds.setPassword(container.getPassword());
        return ds;
    }

    private void waitForRowCount(String table, int count) {
        this.waitForRowCount(table, count, false);
    }

    private void waitForRowCount(String table, int count, boolean allowMore) {
        try (Connection conn = this.getDataSource().getConnection();){
            for (int i = 0; i < 50; ++i) {
                try (ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + table);){
                    Assertions.assertTrue((boolean)rs.next());
                    int current = rs.getInt(1);
                    if (current == count) {
                        return;
                    }
                    if (current > count) {
                        if (allowMore) {
                            return;
                        }
                        throw new AssertionFailedError("The count for table " + table + " was " + current + " which is larger than the expected " + count);
                    }
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nested
    class getMultiValueTests {
        getMultiValueTests() {
        }

        @Test
        void basicStringData() throws Exception {
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto("fizz", TS_2012)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto("buzz", TS_2013)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto("fizzbuzz", TS_2014)).getValue();
            TimescaleHistoryTest.this.waitForRowCount("sensinact.text_data", 9);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "range"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    List result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)2, (int)result.size());
                    Assertions.assertEquals((Object)"fizz", (Object)((TimedValue)result.get(0)).getValue());
                    Assertions.assertEquals((Object)TS_2012, (Object)((TimedValue)result.get(0)).getTimestamp());
                    Assertions.assertEquals((Object)"buzz", (Object)((TimedValue)result.get(1)).getValue());
                    Assertions.assertEquals((Object)TS_2013, (Object)((TimedValue)result.get(1)).getTimestamp());
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "fromTime", TS_2012.plus(Duration.ofDays(1L)).atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)2, (int)result.size());
                    Assertions.assertEquals((Object)"buzz", (Object)((TimedValue)result.get(0)).getValue());
                    Assertions.assertEquals((Object)TS_2013, (Object)((TimedValue)result.get(0)).getTimestamp());
                    Assertions.assertEquals((Object)"fizzbuzz", (Object)((TimedValue)result.get(1)).getValue());
                    Assertions.assertEquals((Object)TS_2014, (Object)((TimedValue)result.get(1)).getTimestamp());
                    return pf.resolved(null);
                }
            }).getValue();
        }

        private <T> T safeGet(Promise<T> p) {
            try {
                return (T)p.getValue();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Test
        void basicNumberData() throws Exception {
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(1, TS_2012)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(2, TS_2013)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(3, TS_2014)).getValue();
            TimescaleHistoryTest.this.waitForRowCount("sensinact.numeric_data", 3);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "range"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    List result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)2, (int)result.size());
                    Assertions.assertEquals((Object)1L, (Object)((TimedValue)result.get(0)).getValue());
                    Assertions.assertEquals((Object)TS_2012, (Object)((TimedValue)result.get(0)).getTimestamp());
                    Assertions.assertEquals((Object)2L, (Object)((TimedValue)result.get(1)).getValue());
                    Assertions.assertEquals((Object)TS_2013, (Object)((TimedValue)result.get(1)).getTimestamp());
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "fromTime", TS_2012.plus(Duration.ofDays(1L)).atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)2, (int)result.size());
                    Assertions.assertEquals((Object)2L, (Object)((TimedValue)result.get(0)).getValue());
                    Assertions.assertEquals((Object)TS_2013, (Object)((TimedValue)result.get(0)).getTimestamp());
                    Assertions.assertEquals((Object)3L, (Object)((TimedValue)result.get(1)).getValue());
                    Assertions.assertEquals((Object)TS_2014, (Object)((TimedValue)result.get(1)).getTimestamp());
                    return pf.resolved(null);
                }
            }).getValue();
        }

        @Test
        void basicDecimalData() throws Exception {
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(1.2, TS_2012)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(3.4, TS_2013)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(5.6, TS_2014)).getValue();
            TimescaleHistoryTest.this.waitForRowCount("sensinact.numeric_data", 3);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "range"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    List result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)2, (int)result.size());
                    Assertions.assertEquals((Object)1.2, (Object)((TimedValue)result.get(0)).getValue());
                    Assertions.assertEquals((Object)TS_2012, (Object)((TimedValue)result.get(0)).getTimestamp());
                    Assertions.assertEquals((Object)3.4, (Object)((TimedValue)result.get(1)).getValue());
                    Assertions.assertEquals((Object)TS_2013, (Object)((TimedValue)result.get(1)).getTimestamp());
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "fromTime", TS_2012.plus(Duration.ofDays(1L)).atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)2, (int)result.size());
                    Assertions.assertEquals((Object)3.4, (Object)((TimedValue)result.get(0)).getValue());
                    Assertions.assertEquals((Object)TS_2013, (Object)((TimedValue)result.get(0)).getTimestamp());
                    Assertions.assertEquals((Object)5.6, (Object)((TimedValue)result.get(1)).getValue());
                    Assertions.assertEquals((Object)TS_2014, (Object)((TimedValue)result.get(1)).getTimestamp());
                    return pf.resolved(null);
                }
            }).getValue();
        }

        @Test
        void manyStringData() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(String.valueOf(i), TS_2012.plus(Duration.ofDays(i)))).getValue();
            }
            TimescaleHistoryTest.this.waitForRowCount("sensinact.text_data", 1006);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "range"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    int i;
                    int i2;
                    List result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)367, (int)result.size());
                    for (i2 = 0; i2 < 367; ++i2) {
                        Assertions.assertEquals((Object)String.valueOf(i2), (Object)((TimedValue)result.get(i2)).getValue());
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(i2)), (Object)((TimedValue)result.get(i2)).getTimestamp());
                    }
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC), "skip", 50)).map(List.class::cast));
                    Assertions.assertEquals((int)317, (int)result.size());
                    for (i2 = 0; i2 < 317; ++i2) {
                        Assertions.assertEquals((Object)String.valueOf(i2 + 50), (Object)((TimedValue)result.get(i2)).getValue());
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(i2 + 50)), (Object)((TimedValue)result.get(i2)).getTimestamp());
                    }
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "fromTime", TS_2012.plus(Duration.ofDays(1L)).atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)501, (int)result.size());
                    for (i2 = 0; i2 < 500; ++i2) {
                        Assertions.assertEquals((Object)String.valueOf(i2 + 1), (Object)((TimedValue)result.get(i2)).getValue());
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(i2 + 1)), (Object)((TimedValue)result.get(i2)).getTimestamp());
                    }
                    Assert.assertNull((Object)((TimedValue)result.get(500)).getTimestamp());
                    Assert.assertNull((Object)((TimedValue)result.get(500)).getValue());
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "toTime", TS_2014.atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)500, (int)result.size());
                    long valueAt2014 = TS_2012.until(TS_2014, ChronoUnit.DAYS);
                    for (i = 0; i < 500; ++i) {
                        Assertions.assertEquals((Object)String.valueOf(valueAt2014 - 499L + (long)i), (Object)((TimedValue)result.get(i)).getValue());
                        Assertions.assertEquals((Object)TS_2014.minus(Duration.ofDays(499 - i)), (Object)((TimedValue)result.get(i)).getTimestamp());
                    }
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar")).map(List.class::cast));
                    Assertions.assertEquals((int)500, (int)result.size());
                    for (i = 0; i < 500; ++i) {
                        Assertions.assertEquals((Object)String.valueOf(500 + i), (Object)((TimedValue)result.get(i)).getValue());
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(500 + i)), (Object)((TimedValue)result.get(i)).getTimestamp());
                    }
                    return pf.resolved(null);
                }
            }).getValue();
        }

        @Test
        void manyStringCount() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(String.valueOf(i), TS_2012.plus(Duration.ofDays(i)))).getValue();
            }
            TimescaleHistoryTest.this.waitForRowCount("sensinact.text_data", 1006);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "count"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    Long result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC))).map(Long.class::cast));
                    Assertions.assertEquals((long)367L, (Long)result);
                    result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "fromTime", TS_2012.plus(Duration.ofDays(1L)).atOffset(ZoneOffset.UTC))).map(Long.class::cast));
                    Assertions.assertEquals((long)999L, (Long)result);
                    result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "toTime", TS_2014.atOffset(ZoneOffset.UTC))).map(Long.class::cast));
                    Assertions.assertEquals((long)732L, (Long)result);
                    result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar")).map(Long.class::cast));
                    Assertions.assertEquals((long)1000L, (Long)result);
                    return pf.resolved(null);
                }
            }).getValue();
        }

        @Test
        void manyNumberData() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(i, TS_2012.plus(Duration.ofDays(i)))).getValue();
            }
            TimescaleHistoryTest.this.waitForRowCount("sensinact.text_data", 1002);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "range"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    int i;
                    int i2;
                    List result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)367, (int)result.size());
                    for (i2 = 0; i2 < 367; ++i2) {
                        Assertions.assertEquals((Object)i2, (Object)((TimedValue)result.get(i2)).getValue());
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(i2)), (Object)((TimedValue)result.get(i2)).getTimestamp());
                    }
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC), "skip", 50)).map(List.class::cast));
                    Assertions.assertEquals((int)317, (int)result.size());
                    for (i2 = 0; i2 < 317; ++i2) {
                        Assertions.assertEquals((Object)(i2 + 50), (Object)((TimedValue)result.get(i2)).getValue());
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(i2 + 50)), (Object)((TimedValue)result.get(i2)).getTimestamp());
                    }
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "fromTime", TS_2012.plus(Duration.ofDays(1L)).atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)501, (int)result.size());
                    for (i2 = 0; i2 < 500; ++i2) {
                        Assertions.assertEquals((Object)(i2 + 1), (Object)((TimedValue)result.get(i2)).getValue());
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(i2 + 1)), (Object)((TimedValue)result.get(i2)).getTimestamp());
                    }
                    Assert.assertNull((Object)((TimedValue)result.get(500)).getTimestamp());
                    Assert.assertNull((Object)((TimedValue)result.get(500)).getValue());
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "toTime", TS_2014.atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)500, (int)result.size());
                    long valueAt2014 = TS_2012.until(TS_2014, ChronoUnit.DAYS);
                    for (i = 0; i < 500; ++i) {
                        Assertions.assertEquals((Object)(valueAt2014 - 499L + (long)i), (Object)((TimedValue)result.get(i)).getValue());
                        Assertions.assertEquals((Object)TS_2014.minus(Duration.ofDays(499 - i)), (Object)((TimedValue)result.get(i)).getTimestamp());
                    }
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz")).map(List.class::cast));
                    Assertions.assertEquals((int)500, (int)result.size());
                    for (i = 0; i < 500; ++i) {
                        Assertions.assertEquals((Object)(500 + i), (Object)((TimedValue)result.get(i)).getValue());
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(500 + i)), (Object)((TimedValue)result.get(i)).getTimestamp());
                    }
                    return pf.resolved(null);
                }
            }).getValue();
        }

        @Test
        void manyNumberCount() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(i, TS_2012.plus(Duration.ofDays(i)))).getValue();
            }
            TimescaleHistoryTest.this.waitForRowCount("sensinact.text_data", 1002);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "count"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    Long result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC))).map(Long.class::cast));
                    Assertions.assertEquals((long)367L, (Long)result);
                    result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "fromTime", TS_2012.plus(Duration.ofDays(1L)).atOffset(ZoneOffset.UTC))).map(Long.class::cast));
                    Assertions.assertEquals((long)999L, (Long)result);
                    result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "toTime", TS_2014.atOffset(ZoneOffset.UTC))).map(Long.class::cast));
                    Assertions.assertEquals((long)732L, (Long)result);
                    result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz")).map(Long.class::cast));
                    Assertions.assertEquals((long)1000L, (Long)result);
                    return pf.resolved(null);
                }
            }).getValue();
        }

        @Test
        void manyDecimalData() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(1.0001 * (double)i, TS_2012.plus(Duration.ofDays(i)))).getValue();
            }
            TimescaleHistoryTest.this.waitForRowCount("sensinact.text_data", 1002);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "range"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    int i;
                    int i2;
                    List result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)367, (int)result.size());
                    for (i2 = 0; i2 < 367; ++i2) {
                        Assertions.assertEquals((double)(1.0001 * (double)i2), (double)((Double)((TimedValue)result.get(i2)).getValue()), (double)1.0E-4);
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(i2)), (Object)((TimedValue)result.get(i2)).getTimestamp());
                    }
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC), "skip", 50)).map(List.class::cast));
                    Assertions.assertEquals((int)317, (int)result.size());
                    for (i2 = 0; i2 < 317; ++i2) {
                        Assertions.assertEquals((double)(1.0001 * (double)(i2 + 50)), (double)((Double)((TimedValue)result.get(i2)).getValue()), (double)1.0E-4);
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(i2 + 50)), (Object)((TimedValue)result.get(i2)).getTimestamp());
                    }
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "fromTime", TS_2012.plus(Duration.ofDays(1L)).atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)501, (int)result.size());
                    for (i2 = 0; i2 < 500; ++i2) {
                        Assertions.assertEquals((double)(1.0001 * (double)(i2 + 1)), (double)((Double)((TimedValue)result.get(i2)).getValue()), (double)1.0E-4);
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(i2 + 1)), (Object)((TimedValue)result.get(i2)).getTimestamp());
                    }
                    Assert.assertNull((Object)((TimedValue)result.get(500)).getTimestamp());
                    Assert.assertNull((Object)((TimedValue)result.get(500)).getValue());
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "toTime", TS_2014.atOffset(ZoneOffset.UTC))).map(List.class::cast));
                    Assertions.assertEquals((int)500, (int)result.size());
                    double valueAt2014 = 1.0001 * (double)TS_2012.until(TS_2014, ChronoUnit.DAYS);
                    for (i = 0; i < 500; ++i) {
                        Assertions.assertEquals((double)(valueAt2014 - (double)(499 - i) * 1.0001), (double)((Double)((TimedValue)result.get(i)).getValue()), (double)1.0E-4);
                        Assertions.assertEquals((Object)TS_2014.minus(Duration.ofDays(499 - i)), (Object)((TimedValue)result.get(i)).getTimestamp());
                    }
                    result = (List)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic")).map(List.class::cast));
                    Assertions.assertEquals((int)500, (int)result.size());
                    for (i = 0; i < 500; ++i) {
                        Assertions.assertEquals((double)(1.0001 * (double)(500 + i)), (double)((Double)((TimedValue)result.get(i)).getValue()), (double)1.0E-4);
                        Assertions.assertEquals((Object)TS_2012.plus(Duration.ofDays(500 + i)), (Object)((TimedValue)result.get(i)).getTimestamp());
                    }
                    return pf.resolved(null);
                }
            }).getValue();
        }

        @Test
        void manyDecimalCount() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(1.0001 * (double)i, TS_2012.plus(Duration.ofDays(i)))).getValue();
            }
            TimescaleHistoryTest.this.waitForRowCount("sensinact.text_data", 1002);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "count"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    Long result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "fromTime", TS_2012.atOffset(ZoneOffset.UTC), "toTime", TS_2013.atOffset(ZoneOffset.UTC))).map(Long.class::cast));
                    Assertions.assertEquals((long)367L, (Long)result);
                    result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "fromTime", TS_2012.plus(Duration.ofDays(1L)).atOffset(ZoneOffset.UTC))).map(Long.class::cast));
                    Assertions.assertEquals((long)999L, (Long)result);
                    result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "toTime", TS_2014.atOffset(ZoneOffset.UTC))).map(Long.class::cast));
                    Assertions.assertEquals((long)732L, (Long)result);
                    result = (Long)getMultiValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic")).map(Long.class::cast));
                    Assertions.assertEquals((long)1000L, (Long)result);
                    return pf.resolved(null);
                }
            }).getValue();
        }
    }

    @Nested
    class getSingleValueTests {
        getSingleValueTests() {
        }

        @Test
        void basicStringData() throws Exception {
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto("fizz", TS_2012)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto("buzz", TS_2013)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto("fizzbuzz", TS_2014)).getValue();
            TimescaleHistoryTest.this.waitForRowCount("sensinact.text_data", 9);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "single"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    TimedValue result = (TimedValue)getSingleValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "time", TS_2012.atOffset(ZoneOffset.UTC))).map(TimedValue.class::cast));
                    Assertions.assertEquals((Object)"fizz", (Object)result.getValue());
                    Assertions.assertEquals((Object)TS_2012, (Object)result.getTimestamp());
                    result = (TimedValue)getSingleValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar", "time", TS_2012.plus(Duration.ofDays(500L)).atOffset(ZoneOffset.UTC))).map(TimedValue.class::cast));
                    Assertions.assertEquals((Object)"buzz", (Object)result.getValue());
                    Assertions.assertEquals((Object)TS_2013, (Object)result.getTimestamp());
                    result = (TimedValue)getSingleValueTests.this.safeGet(resource.act(Map.of("provider", "bar", "service", "foobar", "resource", "foofoobarbar")).map(TimedValue.class::cast));
                    Assertions.assertEquals((Object)"fizz", (Object)result.getValue());
                    Assertions.assertEquals((Object)TS_2012, (Object)result.getTimestamp());
                    return pf.resolved(null);
                }
            }).getValue();
        }

        private <T> T safeGet(Promise<T> p) {
            try {
                return (T)p.getValue();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Test
        void basicNumberData() throws Exception {
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(1, TS_2012)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(2, TS_2013)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(3, TS_2014)).getValue();
            TimescaleHistoryTest.this.waitForRowCount("sensinact.numeric_data", 3);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "single"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    TimedValue result = (TimedValue)getSingleValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "time", TS_2012.atOffset(ZoneOffset.UTC))).map(TimedValue.class::cast));
                    Assertions.assertEquals((Object)1L, (Object)result.getValue());
                    Assertions.assertEquals((Object)TS_2012, (Object)result.getTimestamp());
                    result = (TimedValue)getSingleValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz", "time", TS_2012.plus(Duration.ofDays(500L)).atOffset(ZoneOffset.UTC))).map(TimedValue.class::cast));
                    Assertions.assertEquals((Object)2L, (Object)result.getValue());
                    Assertions.assertEquals((Object)TS_2013, (Object)result.getTimestamp());
                    result = (TimedValue)getSingleValueTests.this.safeGet(resource.act(Map.of("provider", "buzz", "service", "fizzbuzz", "resource", "fizzfizzbuzzbuzz")).map(TimedValue.class::cast));
                    Assertions.assertEquals((Object)1L, (Object)result.getValue());
                    Assertions.assertEquals((Object)TS_2012, (Object)result.getTimestamp());
                    return pf.resolved(null);
                }
            }).getValue();
        }

        @Test
        void basicDecimalData() throws Exception {
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(1.2, TS_2012)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(3.4, TS_2013)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(5.6, TS_2014)).getValue();
            TimescaleHistoryTest.this.waitForRowCount("sensinact.numeric_data", 3);
            TimescaleHistoryTest.this.thread.execute((AbstractSensinactCommand)new ResourceCommand<Void>("https://eclipse.org/sensinact/sensiNactHistory", "sensiNactHistory", "timescale-history", "history", "single"){

                protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                    TimedValue result = (TimedValue)getSingleValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "time", TS_2012.atOffset(ZoneOffset.UTC))).map(TimedValue.class::cast));
                    Assertions.assertEquals((Object)1.2, (Object)result.getValue());
                    Assertions.assertEquals((Object)TS_2012, (Object)result.getTimestamp());
                    result = (TimedValue)getSingleValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic", "time", TS_2012.plus(Duration.ofDays(500L)).atOffset(ZoneOffset.UTC))).map(TimedValue.class::cast));
                    Assertions.assertEquals((Object)3.4, (Object)result.getValue());
                    Assertions.assertEquals((Object)TS_2013, (Object)result.getTimestamp());
                    result = (TimedValue)getSingleValueTests.this.safeGet(resource.act(Map.of("provider", "Bobbidi", "service", "Boo", "resource", "Magic")).map(TimedValue.class::cast));
                    Assertions.assertEquals((Object)1.2, (Object)result.getValue());
                    Assertions.assertEquals((Object)TS_2012, (Object)result.getTimestamp());
                    return pf.resolved(null);
                }
            }).getValue();
        }
    }

    @Nested
    class InsertTests {
        InsertTests() {
        }

        @Test
        void basicStringData() throws Exception {
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto("fizz", TS_2012)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto("buzz", TS_2013)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto("fizzbuzz", TS_2014)).getValue();
            TimescaleHistoryTest.this.waitForRowCount("sensinact.text_data", 9);
            try (Connection connection = TimescaleHistoryTest.this.getDataSource().getConnection();
                 ResultSet result = connection.createStatement().executeQuery("SELECT * FROM sensinact.text_data WHERE provider = 'bar' ORDER BY time;");){
                Assertions.assertTrue((boolean)result.next());
                this.checkResult(result, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName(), "bar", TS_2012);
                Assertions.assertTrue((boolean)result.next());
                Assertions.assertTrue((boolean)result.next());
                Assertions.assertTrue((boolean)result.next());
                this.checkResult(result, "fizz", TS_2012);
                Assertions.assertTrue((boolean)result.next());
                this.checkResult(result, "buzz", TS_2013);
                Assertions.assertTrue((boolean)result.next());
                this.checkResult(result, "fizzbuzz", TS_2014);
                Assertions.assertFalse((boolean)result.next());
            }
        }

        private void checkResult(ResultSet result, String data, Instant timestamp) throws SQLException {
            this.checkResult(result, "foobar", "foofoobarbar", data, timestamp);
        }

        private void checkResult(ResultSet result, String service, String resource, String data, Instant timestamp) throws SQLException {
            Assertions.assertEquals((Object)"foo", (Object)result.getString("model"));
            Assertions.assertEquals((Object)"bar", (Object)result.getString("provider"));
            Assertions.assertEquals((Object)service, (Object)result.getString("service"));
            Assertions.assertEquals((Object)resource, (Object)result.getString("resource"));
            Assertions.assertEquals((Object)data, (Object)result.getString("data"));
            Assertions.assertEquals((Object)Timestamp.from(timestamp), (Object)result.getTimestamp("time"));
        }

        @Test
        void basicNumberData() throws Exception {
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(3, TS_2012)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(5, TS_2013)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(7, TS_2014)).getValue();
            TimescaleHistoryTest.this.waitForRowCount("sensinact.numeric_data", 3);
            try (Connection connection = TimescaleHistoryTest.this.getDataSource().getConnection();
                 ResultSet result = connection.createStatement().executeQuery("SELECT * FROM sensinact.numeric_data WHERE provider = 'buzz' ORDER BY time;");){
                Assertions.assertTrue((boolean)result.next());
                this.checkResult(result, 3, TS_2012);
                Assertions.assertTrue((boolean)result.next());
                this.checkResult(result, 5, TS_2013);
                Assertions.assertTrue((boolean)result.next());
                this.checkResult(result, 7, TS_2014);
                Assertions.assertFalse((boolean)result.next());
            }
        }

        private void checkResult(ResultSet result, Integer data, Instant timestamp) throws SQLException {
            Assertions.assertEquals((Object)"fizz", (Object)result.getString("model"));
            Assertions.assertEquals((Object)"buzz", (Object)result.getString("provider"));
            Assertions.assertEquals((Object)"fizzbuzz", (Object)result.getString("service"));
            Assertions.assertEquals((Object)"fizzfizzbuzzbuzz", (Object)result.getString("resource"));
            Assertions.assertEquals((Integer)data, (int)result.getInt("data"));
            Assertions.assertEquals((Object)Timestamp.from(timestamp), (Object)result.getTimestamp("time"));
        }

        @Test
        void basicDecimalData() throws Exception {
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(1.2, TS_2012)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(3.4, TS_2013)).getValue();
            TimescaleHistoryTest.this.push.pushUpdate((Object)TimescaleHistoryTest.this.getDto(5.6, TS_2014)).getValue();
            TimescaleHistoryTest.this.waitForRowCount("sensinact.numeric_data", 3);
            try (Connection connection = TimescaleHistoryTest.this.getDataSource().getConnection();
                 ResultSet result = connection.createStatement().executeQuery("SELECT * FROM sensinact.numeric_data WHERE provider = 'Bobbidi' ORDER BY time;");){
                Assertions.assertTrue((boolean)result.next());
                this.checkResult(result, 1.2, TS_2012);
                Assertions.assertTrue((boolean)result.next());
                this.checkResult(result, 3.4, TS_2013);
                Assertions.assertTrue((boolean)result.next());
                this.checkResult(result, 5.6, TS_2014);
                Assertions.assertFalse((boolean)result.next());
            }
        }

        private void checkResult(ResultSet result, Double data, Instant timestamp) throws SQLException {
            Assertions.assertEquals((Object)"Bibbidi", (Object)result.getString("model"));
            Assertions.assertEquals((Object)"Bobbidi", (Object)result.getString("provider"));
            Assertions.assertEquals((Object)"Boo", (Object)result.getString("service"));
            Assertions.assertEquals((Object)"Magic", (Object)result.getString("resource"));
            Assertions.assertEquals((Double)data, (double)result.getBigDecimal("data").doubleValue());
            Assertions.assertEquals((Object)Timestamp.from(timestamp), (Object)result.getTimestamp("time"));
        }
    }
}

