/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.mqtt.factory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.sensinact.gateway.southbound.device.factory.DeviceFactoryException;
import org.eclipse.sensinact.gateway.southbound.device.factory.IDeviceMappingHandler;
import org.eclipse.sensinact.gateway.southbound.device.factory.dto.DeviceMappingConfigurationDTO;
import org.eclipse.sensinact.gateway.southbound.mqtt.api.IMqttMessage;
import org.eclipse.sensinact.gateway.southbound.mqtt.api.IMqttMessageListener;
import org.eclipse.sensinact.gateway.southbound.mqtt.factory.MqttDeviceFactoryConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={}, configurationPid={"sensinact.mqtt.device.factory"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class MqttDeviceFactoryHandler
implements IMqttMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(MqttDeviceFactoryHandler.class);
    @Reference
    private IDeviceMappingHandler mappingHandler;
    private DeviceMappingConfigurationDTO mappingConfiguration;
    private String allowedHandlerId;
    private ServiceRegistration<IMqttMessageListener> svcReg;

    @Activate
    void activate(ComponentContext componentContext, MqttDeviceFactoryConfiguration configuration) {
        String handlerId = configuration.mqtt_handler_id();
        String[] topics = configuration.mqtt_topics();
        if (!(handlerId != null && !handlerId.isBlank() || topics != null && topics.length != 0)) {
            throw new IllegalArgumentException("MQTT device factory requires at least a handler ID or a topic to be configured");
        }
        this.allowedHandlerId = handlerId;
        if (topics == null || topics.length == 0) {
            topics = new String[]{"#"};
        } else if (topics.length == 1 && topics[0].contains(",")) {
            topics = topics[0].split(",");
        }
        if (configuration.mapping() == null) {
            throw new IllegalArgumentException("No mapping configuration given");
        }
        try {
            this.mappingConfiguration = (DeviceMappingConfigurationDTO)new ObjectMapper().readValue(configuration.mapping(), DeviceMappingConfigurationDTO.class);
        }
        catch (JsonProcessingException e) {
            logger.error("Error parsing MQTT mapping configuration", (Throwable)e);
            throw new IllegalArgumentException("Invalid mapping configuration", e);
        }
        BundleContext context = componentContext.getBundleContext();
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        if (topics != null) {
            properties.put("sensinact.mqtt.topics.filters", topics);
        }
        this.svcReg = context.registerService(IMqttMessageListener.class, (Object)this, properties);
    }

    @Deactivate
    void deactivate() {
        if (this.svcReg != null) {
            this.svcReg.unregister();
            this.svcReg = null;
        }
    }

    public void onMqttMessage(String handlerId, String topic, IMqttMessage message) {
        if (this.allowedHandlerId != null && !this.allowedHandlerId.equals(handlerId)) {
            return;
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("handlerId", handlerId);
        this.fillTopicSegments(topic, context);
        try {
            this.mappingHandler.handle(this.mappingConfiguration, context, message.getPayload());
        }
        catch (DeviceFactoryException e) {
            logger.error("Error handling MQTT payload from handler '{}' on topic '{}': {}", new Object[]{handlerId, topic, e.getMessage(), e});
        }
    }

    void fillTopicSegments(String topic, Map<String, String> context) {
        context.put("topic", topic);
        boolean startingSlash = topic.indexOf(47) == 0;
        boolean endingSlash = !topic.isEmpty() && topic.lastIndexOf(47) == topic.length() - 1;
        String[] parts = (String[])Arrays.stream(topic.split("/")).filter(Predicate.not(String::isEmpty)).toArray(String[]::new);
        int segmentIdx = 0;
        if (startingSlash || parts.length == 0) {
            context.put("topic-0", "");
            ++segmentIdx;
        }
        for (String part : parts) {
            context.put("topic-" + segmentIdx, part);
            ++segmentIdx;
        }
        if (endingSlash) {
            context.put("topic-" + segmentIdx, "");
        }
        if (endingSlash || parts.length == 0) {
            context.put("topic-last", "");
        } else {
            context.put("topic-last", parts[parts.length - 1]);
        }
    }
}

