/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.device.openhab.internal;

import org.eclipse.sensinact.gateway.device.openhab.internal.OpenHabPacketReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OpenHabPacketReaderTest {
    @Test
    public void testParseOpenhabPath_zwave_device_07150a2a_node21_alarm_general() {
        this.testParseOpenhabPath("zwave_device_07150a2a_node21_alarm_general");
    }

    @Test
    public void testParseOpenhabPath_Testeur_3_zwave_device_1e6c7d23_node10_sensor_temperature() {
        this.testParseOpenhabPath("Testeur_3:zwave_device_1e6c7d23_node10_sensor_temperature");
    }

    @Test
    public void testParseOpenhabPath_zwave_device_07150a2a_node16_config_decimal_param61() {
        this.testParseOpenhabPath("zwave_device_07150a2a_node16_config_decimal_param61", "decimal_param61");
    }

    @Test
    public void testCreateProvider_Testeur_3_zwave_device_1e6c7d23_node12_sensor_door() {
        this.testCreateProvider("Testeur_3:zwave_device_1e6c7d23_node12_sensor_door");
    }

    @Test
    public void testCreateProvider_zwave_device_07150a2a_node21_alarm_general() {
        this.testCreateProvider("zwave_device_07150a2a_node21_alarm_general");
    }

    private String[] testParseOpenhabPath(String openhabDeviceId) {
        return this.testParseOpenhabPath(openhabDeviceId, null);
    }

    private String[] testParseOpenhabPath(String openhabDeviceId, String expectedResourceId) {
        String[] parseOpenhabPath = null;
        try {
            parseOpenhabPath = OpenHabPacketReader.parseOpenhabPath((String)openhabDeviceId);
            Assertions.assertNotNull((Object)parseOpenhabPath, (String)"unexpected null path");
            Assertions.assertEquals((int)4, (int)parseOpenhabPath.length, (String)"unexpected path length");
            for (int i = 0; i < 4; ++i) {
                Assertions.assertNotNull((Object)parseOpenhabPath[i], (String)"unexpected null element");
            }
            System.out.println("Provider=" + OpenHabPacketReader.OPENHAB_ZWAVE_PROVIDER_ID_FORMAT.format(parseOpenhabPath));
            System.out.println("Service =" + parseOpenhabPath[2]);
            System.out.println("Resource=" + parseOpenhabPath[3]);
            if (expectedResourceId != null) {
                Assertions.assertEquals((Object)expectedResourceId, (Object)parseOpenhabPath[3], (String)"unexpected resource id");
            }
        }
        catch (Exception ex) {
            Assertions.fail((String)("unexpected error:" + ex.getMessage()));
        }
        return parseOpenhabPath;
    }

    private void testCreateProvider(String openhabDeviceId) {
        String[] parsedOpenhabPath = this.testParseOpenhabPath(openhabDeviceId);
        Assertions.assertNotNull((Object)parsedOpenhabPath, (String)"unexpected null path");
    }
}

