/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.device.factory.parser.csv;

import org.apache.commons.csv.CSVRecord;
import org.eclipse.sensinact.gateway.southbound.device.factory.IDeviceMappingRecord;
import org.eclipse.sensinact.gateway.southbound.device.factory.RecordPath;
import org.eclipse.sensinact.gateway.southbound.device.factory.dto.DeviceMappingOptionsDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvRecord
implements IDeviceMappingRecord {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CSVRecord record;
    private final boolean columnIndexOnly;

    public CsvRecord(CSVRecord record, boolean columnIndexOnly) {
        this.record = record;
        this.columnIndexOnly = columnIndexOnly;
    }

    private String getValue(RecordPath path) {
        try {
            if (path.isInt() || this.columnIndexOnly) {
                return this.record.get(path.asInt().intValue());
            }
            return this.record.get(path.asString());
        }
        catch (IllegalArgumentException e) {
            if (path.hasDefaultValue()) {
                Object defaultValue = path.getDefaultValue();
                return defaultValue != null ? String.valueOf(defaultValue) : null;
            }
            this.logger.warn("Error reading CSV record: {} (path: {})", (Object)e.getMessage(), (Object)path);
            return null;
        }
    }

    public Object getField(RecordPath field, DeviceMappingOptionsDTO options) {
        return field.convertValue((Object)this.getValue(field), options);
    }

    public String getFieldString(RecordPath field, DeviceMappingOptionsDTO options) {
        return this.getValue(field);
    }
}

