/**
 */
package com.playertour.backend.api;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.playertour.backend.api.PlayerApiFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/OCL/Import ecore='http://www.eclipse.org/emf/2002/Ecore'"
 * @generated
 */
public interface PlayerApiPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "api";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://theplayertour.com/backend/api/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "playerApi";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	PlayerApiPackage eINSTANCE = com.playertour.backend.api.impl.PlayerApiPackageImpl.init();

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.Base <em>Base</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.Base
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getBase()
	 * @generated
	 */
	int BASE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE__ID = 0;

	/**
	 * The number of structural features of the '<em>Base</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Base</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.PlayerProfileImpl <em>Player Profile</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.PlayerProfileImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getPlayerProfile()
	 * @generated
	 */
	int PLAYER_PROFILE = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__ID = BASE__ID;

	/**
	 * The feature id for the '<em><b>User Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__USER_HANDLE = BASE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Profile Picture Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__PROFILE_PICTURE_URL = BASE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Gender</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__GENDER = BASE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Country</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__COUNTRY = BASE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__STATE = BASE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Region</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__REGION = BASE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>City</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__CITY = BASE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Subscription Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__SUBSCRIPTION_STATUS = BASE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__ACTIVE = BASE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Merit Points</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__MERIT_POINTS = BASE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Fav Courses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__FAV_COURSES = BASE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Golf Course History</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE__GOLF_COURSE_HISTORY = BASE_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Player Profile</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE_FEATURE_COUNT = BASE_FEATURE_COUNT + 12;

	/**
	 * The number of operations of the '<em>Player Profile</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAYER_PROFILE_OPERATION_COUNT = BASE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.StrokeImpl <em>Stroke</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.StrokeImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getStroke()
	 * @generated
	 */
	int STROKE = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STROKE__ID = BASE__ID;

	/**
	 * The feature id for the '<em><b>Time Stamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STROKE__TIME_STAMP = BASE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STROKE__LOCATION = BASE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Golf Club Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STROKE__GOLF_CLUB_TYPE = BASE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Previous Stroke Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STROKE__PREVIOUS_STROKE_ID = BASE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STROKE__TYPE = BASE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Stroke</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STROKE_FEATURE_COUNT = BASE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Stroke</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STROKE_OPERATION_COUNT = BASE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.HoleScoreImpl <em>Hole Score</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.HoleScoreImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getHoleScore()
	 * @generated
	 */
	int HOLE_SCORE = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE_SCORE__ID = BASE__ID;

	/**
	 * The feature id for the '<em><b>Time Stamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE_SCORE__TIME_STAMP = BASE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Hole Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE_SCORE__HOLE_NUMBER = BASE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Strokes</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE_SCORE__STROKES = BASE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Score</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE_SCORE__SCORE = BASE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Puts</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE_SCORE__PUTS = BASE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Hole Score</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE_SCORE_FEATURE_COUNT = BASE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Hole Score</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE_SCORE_OPERATION_COUNT = BASE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.ScoreCardImpl <em>Score Card</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.ScoreCardImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getScoreCard()
	 * @generated
	 */
	int SCORE_CARD = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD__ID = BASE__ID;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD__START = BASE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD__END = BASE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Course Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD__COURSE_ID = BASE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Freeze</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD__FREEZE = BASE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Hole Stats</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD__HOLE_STATS = BASE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Score Card</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_FEATURE_COUNT = BASE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Score Card</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_OPERATION_COUNT = BASE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.LocationImpl <em>Location</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.LocationImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getLocation()
	 * @generated
	 */
	int LOCATION = 5;

	/**
	 * The feature id for the '<em><b>Lat</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION__LAT = 0;

	/**
	 * The feature id for the '<em><b>Lng</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION__LNG = 1;

	/**
	 * The number of structural features of the '<em>Location</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Location</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.ScoreCardResourceImpl <em>Score Card Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.ScoreCardResourceImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getScoreCardResource()
	 * @generated
	 */
	int SCORE_CARD_RESOURCE = 6;

	/**
	 * The number of structural features of the '<em>Score Card Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_RESOURCE_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Save Score Card</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_RESOURCE___SAVE_SCORE_CARD = 0;

	/**
	 * The operation id for the '<em>Get My Scorcards</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_RESOURCE___GET_MY_SCORCARDS = 1;

	/**
	 * The operation id for the '<em>Get Scorecards By Course</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_RESOURCE___GET_SCORECARDS_BY_COURSE__STRING = 2;

	/**
	 * The operation id for the '<em>Open Score Card</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_RESOURCE___OPEN_SCORE_CARD__STRING = 3;

	/**
	 * The operation id for the '<em>Submit Stroke</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_RESOURCE___SUBMIT_STROKE__STRING_STROKE = 4;

	/**
	 * The operation id for the '<em>Close Hole</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_RESOURCE___CLOSE_HOLE__STRING_HOLESCORE = 5;

	/**
	 * The operation id for the '<em>Close Score Card</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_RESOURCE___CLOSE_SCORE_CARD__STRING_HOLESCORE = 6;

	/**
	 * The number of operations of the '<em>Score Card Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_CARD_RESOURCE_OPERATION_COUNT = 7;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.GolfCourseResourceImpl <em>Golf Course Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.GolfCourseResourceImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getGolfCourseResource()
	 * @generated
	 */
	int GOLF_COURSE_RESOURCE = 7;

	/**
	 * The number of structural features of the '<em>Golf Course Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_RESOURCE_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Search By Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_RESOURCE___SEARCH_BY_NAME__STRING = 0;

	/**
	 * The operation id for the '<em>Search By Location</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_RESOURCE___SEARCH_BY_LOCATION__DOUBLE_DOUBLE = 1;

	/**
	 * The number of operations of the '<em>Golf Course Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_RESOURCE_OPERATION_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.GolfCourseImpl <em>Golf Course</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.GolfCourseImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getGolfCourse()
	 * @generated
	 */
	int GOLF_COURSE = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE__ID = BASE__ID;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE__TYPE = BASE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE__NAME = BASE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE__LOCATION = BASE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Course Picture Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE__COURSE_PICTURE_URL = BASE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Golf Course</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_FEATURE_COUNT = BASE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Golf Course</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_OPERATION_COUNT = BASE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.GolfCourseSearchResultImpl <em>Golf Course Search Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.GolfCourseSearchResultImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getGolfCourseSearchResult()
	 * @generated
	 */
	int GOLF_COURSE_SEARCH_RESULT = 9;

	/**
	 * The feature id for the '<em><b>Course</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_SEARCH_RESULT__COURSE = 0;

	/**
	 * The feature id for the '<em><b>Distance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_SEARCH_RESULT__DISTANCE = 1;

	/**
	 * The number of structural features of the '<em>Golf Course Search Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_SEARCH_RESULT_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Golf Course Search Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_SEARCH_RESULT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.GolfCourseSearchResultsImpl <em>Golf Course Search Results</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.GolfCourseSearchResultsImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getGolfCourseSearchResults()
	 * @generated
	 */
	int GOLF_COURSE_SEARCH_RESULTS = 10;

	/**
	 * The feature id for the '<em><b>Results</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_SEARCH_RESULTS__RESULTS = 0;

	/**
	 * The number of structural features of the '<em>Golf Course Search Results</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_SEARCH_RESULTS_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Golf Course Search Results</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GOLF_COURSE_SEARCH_RESULTS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.StringToStringMapEntryImpl <em>String To String Map Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.StringToStringMapEntryImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getStringToStringMapEntry()
	 * @generated
	 */
	int STRING_TO_STRING_MAP_ENTRY = 11;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP_ENTRY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP_ENTRY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>String To String Map Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP_ENTRY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>String To String Map Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_TO_STRING_MAP_ENTRY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.impl.ScorecardSearchResultsImpl <em>Scorecard Search Results</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.impl.ScorecardSearchResultsImpl
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getScorecardSearchResults()
	 * @generated
	 */
	int SCORECARD_SEARCH_RESULTS = 12;

	/**
	 * The feature id for the '<em><b>Results</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_SEARCH_RESULTS__RESULTS = 0;

	/**
	 * The number of structural features of the '<em>Scorecard Search Results</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_SEARCH_RESULTS_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Scorecard Search Results</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_SEARCH_RESULTS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.SubscriptionStatus <em>Subscription Status</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.SubscriptionStatus
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getSubscriptionStatus()
	 * @generated
	 */
	int SUBSCRIPTION_STATUS = 13;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.Gender <em>Gender</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.Gender
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getGender()
	 * @generated
	 */
	int GENDER = 14;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.CoursePreference <em>Course Preference</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.CoursePreference
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getCoursePreference()
	 * @generated
	 */
	int COURSE_PREFERENCE = 15;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.StrokeType <em>Stroke Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.StrokeType
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getStrokeType()
	 * @generated
	 */
	int STROKE_TYPE = 16;

	/**
	 * The meta object id for the '{@link com.playertour.backend.api.CourseType <em>Course Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.api.CourseType
	 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getCourseType()
	 * @generated
	 */
	int COURSE_TYPE = 17;


	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.Base <em>Base</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Base</em>'.
	 * @see com.playertour.backend.api.Base
	 * @generated
	 */
	EClass getBase();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.Base#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see com.playertour.backend.api.Base#getId()
	 * @see #getBase()
	 * @generated
	 */
	EAttribute getBase_Id();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.PlayerProfile <em>Player Profile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Player Profile</em>'.
	 * @see com.playertour.backend.api.PlayerProfile
	 * @generated
	 */
	EClass getPlayerProfile();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.PlayerProfile#getUserHandle <em>User Handle</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>User Handle</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getUserHandle()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EAttribute getPlayerProfile_UserHandle();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.PlayerProfile#getProfilePictureUrl <em>Profile Picture Url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Profile Picture Url</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getProfilePictureUrl()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EAttribute getPlayerProfile_ProfilePictureUrl();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.PlayerProfile#getGender <em>Gender</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Gender</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getGender()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EAttribute getPlayerProfile_Gender();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.PlayerProfile#getCountry <em>Country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getCountry()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EAttribute getPlayerProfile_Country();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.PlayerProfile#getState <em>State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getState()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EAttribute getPlayerProfile_State();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.PlayerProfile#getRegion <em>Region</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Region</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getRegion()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EAttribute getPlayerProfile_Region();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.PlayerProfile#getCity <em>City</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>City</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getCity()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EAttribute getPlayerProfile_City();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.PlayerProfile#getSubscriptionStatus <em>Subscription Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Subscription Status</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getSubscriptionStatus()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EAttribute getPlayerProfile_SubscriptionStatus();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.PlayerProfile#getActive <em>Active</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Active</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getActive()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EAttribute getPlayerProfile_Active();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.PlayerProfile#getMeritPoints <em>Merit Points</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Merit Points</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getMeritPoints()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EAttribute getPlayerProfile_MeritPoints();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.api.PlayerProfile#getFavCourses <em>Fav Courses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Fav Courses</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getFavCourses()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EReference getPlayerProfile_FavCourses();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.api.PlayerProfile#getGolfCourseHistory <em>Golf Course History</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Golf Course History</em>'.
	 * @see com.playertour.backend.api.PlayerProfile#getGolfCourseHistory()
	 * @see #getPlayerProfile()
	 * @generated
	 */
	EReference getPlayerProfile_GolfCourseHistory();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.Stroke <em>Stroke</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Stroke</em>'.
	 * @see com.playertour.backend.api.Stroke
	 * @generated
	 */
	EClass getStroke();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.Stroke#getTimeStamp <em>Time Stamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Time Stamp</em>'.
	 * @see com.playertour.backend.api.Stroke#getTimeStamp()
	 * @see #getStroke()
	 * @generated
	 */
	EAttribute getStroke_TimeStamp();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.api.Stroke#getLocation <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Location</em>'.
	 * @see com.playertour.backend.api.Stroke#getLocation()
	 * @see #getStroke()
	 * @generated
	 */
	EReference getStroke_Location();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.Stroke#getGolfClubType <em>Golf Club Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Golf Club Type</em>'.
	 * @see com.playertour.backend.api.Stroke#getGolfClubType()
	 * @see #getStroke()
	 * @generated
	 */
	EAttribute getStroke_GolfClubType();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.Stroke#getPreviousStrokeId <em>Previous Stroke Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Previous Stroke Id</em>'.
	 * @see com.playertour.backend.api.Stroke#getPreviousStrokeId()
	 * @see #getStroke()
	 * @generated
	 */
	EAttribute getStroke_PreviousStrokeId();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.Stroke#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see com.playertour.backend.api.Stroke#getType()
	 * @see #getStroke()
	 * @generated
	 */
	EAttribute getStroke_Type();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.HoleScore <em>Hole Score</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hole Score</em>'.
	 * @see com.playertour.backend.api.HoleScore
	 * @generated
	 */
	EClass getHoleScore();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.HoleScore#getTimeStamp <em>Time Stamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Time Stamp</em>'.
	 * @see com.playertour.backend.api.HoleScore#getTimeStamp()
	 * @see #getHoleScore()
	 * @generated
	 */
	EAttribute getHoleScore_TimeStamp();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.HoleScore#getHoleNumber <em>Hole Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hole Number</em>'.
	 * @see com.playertour.backend.api.HoleScore#getHoleNumber()
	 * @see #getHoleScore()
	 * @generated
	 */
	EAttribute getHoleScore_HoleNumber();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.api.HoleScore#getStrokes <em>Strokes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Strokes</em>'.
	 * @see com.playertour.backend.api.HoleScore#getStrokes()
	 * @see #getHoleScore()
	 * @generated
	 */
	EReference getHoleScore_Strokes();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.HoleScore#getScore <em>Score</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Score</em>'.
	 * @see com.playertour.backend.api.HoleScore#getScore()
	 * @see #getHoleScore()
	 * @generated
	 */
	EAttribute getHoleScore_Score();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.HoleScore#getPuts <em>Puts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Puts</em>'.
	 * @see com.playertour.backend.api.HoleScore#getPuts()
	 * @see #getHoleScore()
	 * @generated
	 */
	EAttribute getHoleScore_Puts();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.ScoreCard <em>Score Card</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Score Card</em>'.
	 * @see com.playertour.backend.api.ScoreCard
	 * @generated
	 */
	EClass getScoreCard();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.ScoreCard#getStart <em>Start</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start</em>'.
	 * @see com.playertour.backend.api.ScoreCard#getStart()
	 * @see #getScoreCard()
	 * @generated
	 */
	EAttribute getScoreCard_Start();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.ScoreCard#getEnd <em>End</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End</em>'.
	 * @see com.playertour.backend.api.ScoreCard#getEnd()
	 * @see #getScoreCard()
	 * @generated
	 */
	EAttribute getScoreCard_End();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.ScoreCard#getCourseId <em>Course Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Course Id</em>'.
	 * @see com.playertour.backend.api.ScoreCard#getCourseId()
	 * @see #getScoreCard()
	 * @generated
	 */
	EAttribute getScoreCard_CourseId();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.ScoreCard#getFreeze <em>Freeze</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Freeze</em>'.
	 * @see com.playertour.backend.api.ScoreCard#getFreeze()
	 * @see #getScoreCard()
	 * @generated
	 */
	EAttribute getScoreCard_Freeze();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.api.ScoreCard#getHoleStats <em>Hole Stats</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Hole Stats</em>'.
	 * @see com.playertour.backend.api.ScoreCard#getHoleStats()
	 * @see #getScoreCard()
	 * @generated
	 */
	EReference getScoreCard_HoleStats();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.Location <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Location</em>'.
	 * @see com.playertour.backend.api.Location
	 * @generated
	 */
	EClass getLocation();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.Location#getLat <em>Lat</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lat</em>'.
	 * @see com.playertour.backend.api.Location#getLat()
	 * @see #getLocation()
	 * @generated
	 */
	EAttribute getLocation_Lat();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.Location#getLng <em>Lng</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lng</em>'.
	 * @see com.playertour.backend.api.Location#getLng()
	 * @see #getLocation()
	 * @generated
	 */
	EAttribute getLocation_Lng();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.ScoreCardResource <em>Score Card Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Score Card Resource</em>'.
	 * @see com.playertour.backend.api.ScoreCardResource
	 * @generated
	 */
	EClass getScoreCardResource();

	/**
	 * Returns the meta object for the '{@link com.playertour.backend.api.ScoreCardResource#saveScoreCard() <em>Save Score Card</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Save Score Card</em>' operation.
	 * @see com.playertour.backend.api.ScoreCardResource#saveScoreCard()
	 * @generated
	 */
	EOperation getScoreCardResource__SaveScoreCard();

	/**
	 * Returns the meta object for the '{@link com.playertour.backend.api.ScoreCardResource#getMyScorcards() <em>Get My Scorcards</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get My Scorcards</em>' operation.
	 * @see com.playertour.backend.api.ScoreCardResource#getMyScorcards()
	 * @generated
	 */
	EOperation getScoreCardResource__GetMyScorcards();

	/**
	 * Returns the meta object for the '{@link com.playertour.backend.api.ScoreCardResource#getScorecardsByCourse(java.lang.String) <em>Get Scorecards By Course</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Scorecards By Course</em>' operation.
	 * @see com.playertour.backend.api.ScoreCardResource#getScorecardsByCourse(java.lang.String)
	 * @generated
	 */
	EOperation getScoreCardResource__GetScorecardsByCourse__String();

	/**
	 * Returns the meta object for the '{@link com.playertour.backend.api.ScoreCardResource#openScoreCard(java.lang.String) <em>Open Score Card</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Open Score Card</em>' operation.
	 * @see com.playertour.backend.api.ScoreCardResource#openScoreCard(java.lang.String)
	 * @generated
	 */
	EOperation getScoreCardResource__OpenScoreCard__String();

	/**
	 * Returns the meta object for the '{@link com.playertour.backend.api.ScoreCardResource#submitStroke(java.lang.String, com.playertour.backend.api.Stroke) <em>Submit Stroke</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Submit Stroke</em>' operation.
	 * @see com.playertour.backend.api.ScoreCardResource#submitStroke(java.lang.String, com.playertour.backend.api.Stroke)
	 * @generated
	 */
	EOperation getScoreCardResource__SubmitStroke__String_Stroke();

	/**
	 * Returns the meta object for the '{@link com.playertour.backend.api.ScoreCardResource#closeHole(java.lang.String, com.playertour.backend.api.HoleScore) <em>Close Hole</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Close Hole</em>' operation.
	 * @see com.playertour.backend.api.ScoreCardResource#closeHole(java.lang.String, com.playertour.backend.api.HoleScore)
	 * @generated
	 */
	EOperation getScoreCardResource__CloseHole__String_HoleScore();

	/**
	 * Returns the meta object for the '{@link com.playertour.backend.api.ScoreCardResource#closeScoreCard(java.lang.String, com.playertour.backend.api.HoleScore) <em>Close Score Card</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Close Score Card</em>' operation.
	 * @see com.playertour.backend.api.ScoreCardResource#closeScoreCard(java.lang.String, com.playertour.backend.api.HoleScore)
	 * @generated
	 */
	EOperation getScoreCardResource__CloseScoreCard__String_HoleScore();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.GolfCourseResource <em>Golf Course Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Golf Course Resource</em>'.
	 * @see com.playertour.backend.api.GolfCourseResource
	 * @generated
	 */
	EClass getGolfCourseResource();

	/**
	 * Returns the meta object for the '{@link com.playertour.backend.api.GolfCourseResource#searchByName(java.lang.String) <em>Search By Name</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Search By Name</em>' operation.
	 * @see com.playertour.backend.api.GolfCourseResource#searchByName(java.lang.String)
	 * @generated
	 */
	EOperation getGolfCourseResource__SearchByName__String();

	/**
	 * Returns the meta object for the '{@link com.playertour.backend.api.GolfCourseResource#searchByLocation(double, double) <em>Search By Location</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Search By Location</em>' operation.
	 * @see com.playertour.backend.api.GolfCourseResource#searchByLocation(double, double)
	 * @generated
	 */
	EOperation getGolfCourseResource__SearchByLocation__double_double();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.GolfCourse <em>Golf Course</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Golf Course</em>'.
	 * @see com.playertour.backend.api.GolfCourse
	 * @generated
	 */
	EClass getGolfCourse();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.GolfCourse#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see com.playertour.backend.api.GolfCourse#getType()
	 * @see #getGolfCourse()
	 * @generated
	 */
	EAttribute getGolfCourse_Type();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.GolfCourse#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.playertour.backend.api.GolfCourse#getName()
	 * @see #getGolfCourse()
	 * @generated
	 */
	EAttribute getGolfCourse_Name();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.api.GolfCourse#getLocation <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Location</em>'.
	 * @see com.playertour.backend.api.GolfCourse#getLocation()
	 * @see #getGolfCourse()
	 * @generated
	 */
	EReference getGolfCourse_Location();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.GolfCourse#getCoursePictureUrl <em>Course Picture Url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Course Picture Url</em>'.
	 * @see com.playertour.backend.api.GolfCourse#getCoursePictureUrl()
	 * @see #getGolfCourse()
	 * @generated
	 */
	EAttribute getGolfCourse_CoursePictureUrl();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.GolfCourseSearchResult <em>Golf Course Search Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Golf Course Search Result</em>'.
	 * @see com.playertour.backend.api.GolfCourseSearchResult
	 * @generated
	 */
	EClass getGolfCourseSearchResult();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.api.GolfCourseSearchResult#getCourse <em>Course</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Course</em>'.
	 * @see com.playertour.backend.api.GolfCourseSearchResult#getCourse()
	 * @see #getGolfCourseSearchResult()
	 * @generated
	 */
	EReference getGolfCourseSearchResult_Course();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.api.GolfCourseSearchResult#getDistance <em>Distance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Distance</em>'.
	 * @see com.playertour.backend.api.GolfCourseSearchResult#getDistance()
	 * @see #getGolfCourseSearchResult()
	 * @generated
	 */
	EAttribute getGolfCourseSearchResult_Distance();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.GolfCourseSearchResults <em>Golf Course Search Results</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Golf Course Search Results</em>'.
	 * @see com.playertour.backend.api.GolfCourseSearchResults
	 * @generated
	 */
	EClass getGolfCourseSearchResults();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.api.GolfCourseSearchResults#getResults <em>Results</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Results</em>'.
	 * @see com.playertour.backend.api.GolfCourseSearchResults#getResults()
	 * @see #getGolfCourseSearchResults()
	 * @generated
	 */
	EReference getGolfCourseSearchResults_Results();

	/**
	 * Returns the meta object for class '{@link java.util.Map.Entry <em>String To String Map Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String To String Map Entry</em>'.
	 * @see java.util.Map.Entry
	 * @model keyDataType="org.eclipse.emf.ecore.EString"
	 *        valueDataType="org.eclipse.emf.ecore.EString"
	 * @generated
	 */
	EClass getStringToStringMapEntry();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see java.util.Map.Entry
	 * @see #getStringToStringMapEntry()
	 * @generated
	 */
	EAttribute getStringToStringMapEntry_Key();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see java.util.Map.Entry
	 * @see #getStringToStringMapEntry()
	 * @generated
	 */
	EAttribute getStringToStringMapEntry_Value();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.api.ScorecardSearchResults <em>Scorecard Search Results</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scorecard Search Results</em>'.
	 * @see com.playertour.backend.api.ScorecardSearchResults
	 * @generated
	 */
	EClass getScorecardSearchResults();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.api.ScorecardSearchResults#getResults <em>Results</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Results</em>'.
	 * @see com.playertour.backend.api.ScorecardSearchResults#getResults()
	 * @see #getScorecardSearchResults()
	 * @generated
	 */
	EReference getScorecardSearchResults_Results();

	/**
	 * Returns the meta object for enum '{@link com.playertour.backend.api.SubscriptionStatus <em>Subscription Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Subscription Status</em>'.
	 * @see com.playertour.backend.api.SubscriptionStatus
	 * @generated
	 */
	EEnum getSubscriptionStatus();

	/**
	 * Returns the meta object for enum '{@link com.playertour.backend.api.Gender <em>Gender</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Gender</em>'.
	 * @see com.playertour.backend.api.Gender
	 * @generated
	 */
	EEnum getGender();

	/**
	 * Returns the meta object for enum '{@link com.playertour.backend.api.CoursePreference <em>Course Preference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Course Preference</em>'.
	 * @see com.playertour.backend.api.CoursePreference
	 * @generated
	 */
	EEnum getCoursePreference();

	/**
	 * Returns the meta object for enum '{@link com.playertour.backend.api.StrokeType <em>Stroke Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Stroke Type</em>'.
	 * @see com.playertour.backend.api.StrokeType
	 * @generated
	 */
	EEnum getStrokeType();

	/**
	 * Returns the meta object for enum '{@link com.playertour.backend.api.CourseType <em>Course Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Course Type</em>'.
	 * @see com.playertour.backend.api.CourseType
	 * @generated
	 */
	EEnum getCourseType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	PlayerApiFactory getPlayerApiFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.Base <em>Base</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.Base
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getBase()
		 * @generated
		 */
		EClass BASE = eINSTANCE.getBase();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BASE__ID = eINSTANCE.getBase_Id();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.PlayerProfileImpl <em>Player Profile</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.PlayerProfileImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getPlayerProfile()
		 * @generated
		 */
		EClass PLAYER_PROFILE = eINSTANCE.getPlayerProfile();

		/**
		 * The meta object literal for the '<em><b>User Handle</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_PROFILE__USER_HANDLE = eINSTANCE.getPlayerProfile_UserHandle();

		/**
		 * The meta object literal for the '<em><b>Profile Picture Url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_PROFILE__PROFILE_PICTURE_URL = eINSTANCE.getPlayerProfile_ProfilePictureUrl();

		/**
		 * The meta object literal for the '<em><b>Gender</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_PROFILE__GENDER = eINSTANCE.getPlayerProfile_Gender();

		/**
		 * The meta object literal for the '<em><b>Country</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_PROFILE__COUNTRY = eINSTANCE.getPlayerProfile_Country();

		/**
		 * The meta object literal for the '<em><b>State</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_PROFILE__STATE = eINSTANCE.getPlayerProfile_State();

		/**
		 * The meta object literal for the '<em><b>Region</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_PROFILE__REGION = eINSTANCE.getPlayerProfile_Region();

		/**
		 * The meta object literal for the '<em><b>City</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_PROFILE__CITY = eINSTANCE.getPlayerProfile_City();

		/**
		 * The meta object literal for the '<em><b>Subscription Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_PROFILE__SUBSCRIPTION_STATUS = eINSTANCE.getPlayerProfile_SubscriptionStatus();

		/**
		 * The meta object literal for the '<em><b>Active</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_PROFILE__ACTIVE = eINSTANCE.getPlayerProfile_Active();

		/**
		 * The meta object literal for the '<em><b>Merit Points</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAYER_PROFILE__MERIT_POINTS = eINSTANCE.getPlayerProfile_MeritPoints();

		/**
		 * The meta object literal for the '<em><b>Fav Courses</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PLAYER_PROFILE__FAV_COURSES = eINSTANCE.getPlayerProfile_FavCourses();

		/**
		 * The meta object literal for the '<em><b>Golf Course History</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PLAYER_PROFILE__GOLF_COURSE_HISTORY = eINSTANCE.getPlayerProfile_GolfCourseHistory();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.StrokeImpl <em>Stroke</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.StrokeImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getStroke()
		 * @generated
		 */
		EClass STROKE = eINSTANCE.getStroke();

		/**
		 * The meta object literal for the '<em><b>Time Stamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STROKE__TIME_STAMP = eINSTANCE.getStroke_TimeStamp();

		/**
		 * The meta object literal for the '<em><b>Location</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STROKE__LOCATION = eINSTANCE.getStroke_Location();

		/**
		 * The meta object literal for the '<em><b>Golf Club Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STROKE__GOLF_CLUB_TYPE = eINSTANCE.getStroke_GolfClubType();

		/**
		 * The meta object literal for the '<em><b>Previous Stroke Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STROKE__PREVIOUS_STROKE_ID = eINSTANCE.getStroke_PreviousStrokeId();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STROKE__TYPE = eINSTANCE.getStroke_Type();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.HoleScoreImpl <em>Hole Score</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.HoleScoreImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getHoleScore()
		 * @generated
		 */
		EClass HOLE_SCORE = eINSTANCE.getHoleScore();

		/**
		 * The meta object literal for the '<em><b>Time Stamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOLE_SCORE__TIME_STAMP = eINSTANCE.getHoleScore_TimeStamp();

		/**
		 * The meta object literal for the '<em><b>Hole Number</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOLE_SCORE__HOLE_NUMBER = eINSTANCE.getHoleScore_HoleNumber();

		/**
		 * The meta object literal for the '<em><b>Strokes</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOLE_SCORE__STROKES = eINSTANCE.getHoleScore_Strokes();

		/**
		 * The meta object literal for the '<em><b>Score</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOLE_SCORE__SCORE = eINSTANCE.getHoleScore_Score();

		/**
		 * The meta object literal for the '<em><b>Puts</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOLE_SCORE__PUTS = eINSTANCE.getHoleScore_Puts();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.ScoreCardImpl <em>Score Card</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.ScoreCardImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getScoreCard()
		 * @generated
		 */
		EClass SCORE_CARD = eINSTANCE.getScoreCard();

		/**
		 * The meta object literal for the '<em><b>Start</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORE_CARD__START = eINSTANCE.getScoreCard_Start();

		/**
		 * The meta object literal for the '<em><b>End</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORE_CARD__END = eINSTANCE.getScoreCard_End();

		/**
		 * The meta object literal for the '<em><b>Course Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORE_CARD__COURSE_ID = eINSTANCE.getScoreCard_CourseId();

		/**
		 * The meta object literal for the '<em><b>Freeze</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORE_CARD__FREEZE = eINSTANCE.getScoreCard_Freeze();

		/**
		 * The meta object literal for the '<em><b>Hole Stats</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCORE_CARD__HOLE_STATS = eINSTANCE.getScoreCard_HoleStats();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.LocationImpl <em>Location</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.LocationImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getLocation()
		 * @generated
		 */
		EClass LOCATION = eINSTANCE.getLocation();

		/**
		 * The meta object literal for the '<em><b>Lat</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOCATION__LAT = eINSTANCE.getLocation_Lat();

		/**
		 * The meta object literal for the '<em><b>Lng</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOCATION__LNG = eINSTANCE.getLocation_Lng();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.ScoreCardResourceImpl <em>Score Card Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.ScoreCardResourceImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getScoreCardResource()
		 * @generated
		 */
		EClass SCORE_CARD_RESOURCE = eINSTANCE.getScoreCardResource();

		/**
		 * The meta object literal for the '<em><b>Save Score Card</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SCORE_CARD_RESOURCE___SAVE_SCORE_CARD = eINSTANCE.getScoreCardResource__SaveScoreCard();

		/**
		 * The meta object literal for the '<em><b>Get My Scorcards</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SCORE_CARD_RESOURCE___GET_MY_SCORCARDS = eINSTANCE.getScoreCardResource__GetMyScorcards();

		/**
		 * The meta object literal for the '<em><b>Get Scorecards By Course</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SCORE_CARD_RESOURCE___GET_SCORECARDS_BY_COURSE__STRING = eINSTANCE.getScoreCardResource__GetScorecardsByCourse__String();

		/**
		 * The meta object literal for the '<em><b>Open Score Card</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SCORE_CARD_RESOURCE___OPEN_SCORE_CARD__STRING = eINSTANCE.getScoreCardResource__OpenScoreCard__String();

		/**
		 * The meta object literal for the '<em><b>Submit Stroke</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SCORE_CARD_RESOURCE___SUBMIT_STROKE__STRING_STROKE = eINSTANCE.getScoreCardResource__SubmitStroke__String_Stroke();

		/**
		 * The meta object literal for the '<em><b>Close Hole</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SCORE_CARD_RESOURCE___CLOSE_HOLE__STRING_HOLESCORE = eINSTANCE.getScoreCardResource__CloseHole__String_HoleScore();

		/**
		 * The meta object literal for the '<em><b>Close Score Card</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SCORE_CARD_RESOURCE___CLOSE_SCORE_CARD__STRING_HOLESCORE = eINSTANCE.getScoreCardResource__CloseScoreCard__String_HoleScore();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.GolfCourseResourceImpl <em>Golf Course Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.GolfCourseResourceImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getGolfCourseResource()
		 * @generated
		 */
		EClass GOLF_COURSE_RESOURCE = eINSTANCE.getGolfCourseResource();

		/**
		 * The meta object literal for the '<em><b>Search By Name</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation GOLF_COURSE_RESOURCE___SEARCH_BY_NAME__STRING = eINSTANCE.getGolfCourseResource__SearchByName__String();

		/**
		 * The meta object literal for the '<em><b>Search By Location</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation GOLF_COURSE_RESOURCE___SEARCH_BY_LOCATION__DOUBLE_DOUBLE = eINSTANCE.getGolfCourseResource__SearchByLocation__double_double();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.GolfCourseImpl <em>Golf Course</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.GolfCourseImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getGolfCourse()
		 * @generated
		 */
		EClass GOLF_COURSE = eINSTANCE.getGolfCourse();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GOLF_COURSE__TYPE = eINSTANCE.getGolfCourse_Type();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GOLF_COURSE__NAME = eINSTANCE.getGolfCourse_Name();

		/**
		 * The meta object literal for the '<em><b>Location</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GOLF_COURSE__LOCATION = eINSTANCE.getGolfCourse_Location();

		/**
		 * The meta object literal for the '<em><b>Course Picture Url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GOLF_COURSE__COURSE_PICTURE_URL = eINSTANCE.getGolfCourse_CoursePictureUrl();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.GolfCourseSearchResultImpl <em>Golf Course Search Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.GolfCourseSearchResultImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getGolfCourseSearchResult()
		 * @generated
		 */
		EClass GOLF_COURSE_SEARCH_RESULT = eINSTANCE.getGolfCourseSearchResult();

		/**
		 * The meta object literal for the '<em><b>Course</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GOLF_COURSE_SEARCH_RESULT__COURSE = eINSTANCE.getGolfCourseSearchResult_Course();

		/**
		 * The meta object literal for the '<em><b>Distance</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GOLF_COURSE_SEARCH_RESULT__DISTANCE = eINSTANCE.getGolfCourseSearchResult_Distance();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.GolfCourseSearchResultsImpl <em>Golf Course Search Results</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.GolfCourseSearchResultsImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getGolfCourseSearchResults()
		 * @generated
		 */
		EClass GOLF_COURSE_SEARCH_RESULTS = eINSTANCE.getGolfCourseSearchResults();

		/**
		 * The meta object literal for the '<em><b>Results</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GOLF_COURSE_SEARCH_RESULTS__RESULTS = eINSTANCE.getGolfCourseSearchResults_Results();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.StringToStringMapEntryImpl <em>String To String Map Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.StringToStringMapEntryImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getStringToStringMapEntry()
		 * @generated
		 */
		EClass STRING_TO_STRING_MAP_ENTRY = eINSTANCE.getStringToStringMapEntry();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_TO_STRING_MAP_ENTRY__KEY = eINSTANCE.getStringToStringMapEntry_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_TO_STRING_MAP_ENTRY__VALUE = eINSTANCE.getStringToStringMapEntry_Value();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.impl.ScorecardSearchResultsImpl <em>Scorecard Search Results</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.impl.ScorecardSearchResultsImpl
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getScorecardSearchResults()
		 * @generated
		 */
		EClass SCORECARD_SEARCH_RESULTS = eINSTANCE.getScorecardSearchResults();

		/**
		 * The meta object literal for the '<em><b>Results</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCORECARD_SEARCH_RESULTS__RESULTS = eINSTANCE.getScorecardSearchResults_Results();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.SubscriptionStatus <em>Subscription Status</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.SubscriptionStatus
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getSubscriptionStatus()
		 * @generated
		 */
		EEnum SUBSCRIPTION_STATUS = eINSTANCE.getSubscriptionStatus();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.Gender <em>Gender</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.Gender
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getGender()
		 * @generated
		 */
		EEnum GENDER = eINSTANCE.getGender();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.CoursePreference <em>Course Preference</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.CoursePreference
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getCoursePreference()
		 * @generated
		 */
		EEnum COURSE_PREFERENCE = eINSTANCE.getCoursePreference();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.StrokeType <em>Stroke Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.StrokeType
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getStrokeType()
		 * @generated
		 */
		EEnum STROKE_TYPE = eINSTANCE.getStrokeType();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.api.CourseType <em>Course Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.api.CourseType
		 * @see com.playertour.backend.api.impl.PlayerApiPackageImpl#getCourseType()
		 * @generated
		 */
		EEnum COURSE_TYPE = eINSTANCE.getCourseType();

	}

} //PlayerApiPackage
