/**
 */
package com.playertour.backend.api.impl;

import com.playertour.backend.api.*;

import java.util.Map;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class PlayerApiFactoryImpl extends EFactoryImpl implements PlayerApiFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static PlayerApiFactory init() {
		try {
			PlayerApiFactory thePlayerApiFactory = (PlayerApiFactory)EPackage.Registry.INSTANCE.getEFactory(PlayerApiPackage.eNS_URI);
			if (thePlayerApiFactory != null) {
				return thePlayerApiFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new PlayerApiFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PlayerApiFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case PlayerApiPackage.PLAYER_PROFILE: return createPlayerProfile();
			case PlayerApiPackage.STROKE: return createStroke();
			case PlayerApiPackage.HOLE_SCORE: return createHoleScore();
			case PlayerApiPackage.SCORE_CARD: return createScoreCard();
			case PlayerApiPackage.LOCATION: return createLocation();
			case PlayerApiPackage.SCORE_CARD_RESOURCE: return createScoreCardResource();
			case PlayerApiPackage.GOLF_COURSE_RESOURCE: return createGolfCourseResource();
			case PlayerApiPackage.GOLF_COURSE: return createGolfCourse();
			case PlayerApiPackage.GOLF_COURSE_SEARCH_RESULT: return createGolfCourseSearchResult();
			case PlayerApiPackage.GOLF_COURSE_SEARCH_RESULTS: return createGolfCourseSearchResults();
			case PlayerApiPackage.STRING_TO_STRING_MAP_ENTRY: return (EObject)createStringToStringMapEntry();
			case PlayerApiPackage.SCORECARD_SEARCH_RESULTS: return createScorecardSearchResults();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case PlayerApiPackage.SUBSCRIPTION_STATUS:
				return createSubscriptionStatusFromString(eDataType, initialValue);
			case PlayerApiPackage.GENDER:
				return createGenderFromString(eDataType, initialValue);
			case PlayerApiPackage.COURSE_PREFERENCE:
				return createCoursePreferenceFromString(eDataType, initialValue);
			case PlayerApiPackage.STROKE_TYPE:
				return createStrokeTypeFromString(eDataType, initialValue);
			case PlayerApiPackage.COURSE_TYPE:
				return createCourseTypeFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case PlayerApiPackage.SUBSCRIPTION_STATUS:
				return convertSubscriptionStatusToString(eDataType, instanceValue);
			case PlayerApiPackage.GENDER:
				return convertGenderToString(eDataType, instanceValue);
			case PlayerApiPackage.COURSE_PREFERENCE:
				return convertCoursePreferenceToString(eDataType, instanceValue);
			case PlayerApiPackage.STROKE_TYPE:
				return convertStrokeTypeToString(eDataType, instanceValue);
			case PlayerApiPackage.COURSE_TYPE:
				return convertCourseTypeToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PlayerProfile createPlayerProfile() {
		PlayerProfileImpl playerProfile = new PlayerProfileImpl();
		return playerProfile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Stroke createStroke() {
		StrokeImpl stroke = new StrokeImpl();
		return stroke;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public HoleScore createHoleScore() {
		HoleScoreImpl holeScore = new HoleScoreImpl();
		return holeScore;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ScoreCard createScoreCard() {
		ScoreCardImpl scoreCard = new ScoreCardImpl();
		return scoreCard;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Location createLocation() {
		LocationImpl location = new LocationImpl();
		return location;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ScoreCardResource createScoreCardResource() {
		ScoreCardResourceImpl scoreCardResource = new ScoreCardResourceImpl();
		return scoreCardResource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GolfCourseResource createGolfCourseResource() {
		GolfCourseResourceImpl golfCourseResource = new GolfCourseResourceImpl();
		return golfCourseResource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GolfCourse createGolfCourse() {
		GolfCourseImpl golfCourse = new GolfCourseImpl();
		return golfCourse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GolfCourseSearchResult createGolfCourseSearchResult() {
		GolfCourseSearchResultImpl golfCourseSearchResult = new GolfCourseSearchResultImpl();
		return golfCourseSearchResult;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GolfCourseSearchResults createGolfCourseSearchResults() {
		GolfCourseSearchResultsImpl golfCourseSearchResults = new GolfCourseSearchResultsImpl();
		return golfCourseSearchResults;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Map.Entry<String, String> createStringToStringMapEntry() {
		StringToStringMapEntryImpl stringToStringMapEntry = new StringToStringMapEntryImpl();
		return stringToStringMapEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ScorecardSearchResults createScorecardSearchResults() {
		ScorecardSearchResultsImpl scorecardSearchResults = new ScorecardSearchResultsImpl();
		return scorecardSearchResults;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SubscriptionStatus createSubscriptionStatusFromString(EDataType eDataType, String initialValue) {
		SubscriptionStatus result = SubscriptionStatus.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertSubscriptionStatusToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Gender createGenderFromString(EDataType eDataType, String initialValue) {
		Gender result = Gender.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertGenderToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CoursePreference createCoursePreferenceFromString(EDataType eDataType, String initialValue) {
		CoursePreference result = CoursePreference.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCoursePreferenceToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StrokeType createStrokeTypeFromString(EDataType eDataType, String initialValue) {
		StrokeType result = StrokeType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertStrokeTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CourseType createCourseTypeFromString(EDataType eDataType, String initialValue) {
		CourseType result = CourseType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCourseTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PlayerApiPackage getPlayerApiPackage() {
		return (PlayerApiPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static PlayerApiPackage getPackage() {
		return PlayerApiPackage.eINSTANCE;
	}

} //PlayerApiFactoryImpl
