/**
 */
package com.playertour.backend.api.impl;

import com.playertour.backend.api.Gender;
import com.playertour.backend.api.GolfCourse;
import com.playertour.backend.api.PlayerApiPackage;
import com.playertour.backend.api.PlayerProfile;
import com.playertour.backend.api.SubscriptionStatus;

import java.math.BigInteger;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Player Profile</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getId <em>Id</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getUserHandle <em>User Handle</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getProfilePictureUrl <em>Profile Picture Url</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getGender <em>Gender</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getCountry <em>Country</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getState <em>State</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getRegion <em>Region</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getCity <em>City</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getSubscriptionStatus <em>Subscription Status</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getActive <em>Active</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getMeritPoints <em>Merit Points</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getFavCourses <em>Fav Courses</em>}</li>
 *   <li>{@link com.playertour.backend.api.impl.PlayerProfileImpl#getGolfCourseHistory <em>Golf Course History</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PlayerProfileImpl extends MinimalEObjectImpl.Container implements PlayerProfile {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getUserHandle() <em>User Handle</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUserHandle()
	 * @generated
	 * @ordered
	 */
	protected static final String USER_HANDLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUserHandle() <em>User Handle</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUserHandle()
	 * @generated
	 * @ordered
	 */
	protected String userHandle = USER_HANDLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getProfilePictureUrl() <em>Profile Picture Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProfilePictureUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String PROFILE_PICTURE_URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProfilePictureUrl() <em>Profile Picture Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProfilePictureUrl()
	 * @generated
	 * @ordered
	 */
	protected String profilePictureUrl = PROFILE_PICTURE_URL_EDEFAULT;

	/**
	 * The default value of the '{@link #getGender() <em>Gender</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGender()
	 * @generated
	 * @ordered
	 */
	protected static final Gender GENDER_EDEFAULT = Gender.OTHER;

	/**
	 * The cached value of the '{@link #getGender() <em>Gender</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGender()
	 * @generated
	 * @ordered
	 */
	protected Gender gender = GENDER_EDEFAULT;

	/**
	 * The default value of the '{@link #getCountry() <em>Country</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountry()
	 * @generated
	 * @ordered
	 */
	protected static final String COUNTRY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCountry() <em>Country</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountry()
	 * @generated
	 * @ordered
	 */
	protected String country = COUNTRY_EDEFAULT;

	/**
	 * The default value of the '{@link #getState() <em>State</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getState()
	 * @generated
	 * @ordered
	 */
	protected static final String STATE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getState() <em>State</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getState()
	 * @generated
	 * @ordered
	 */
	protected String state = STATE_EDEFAULT;

	/**
	 * The default value of the '{@link #getRegion() <em>Region</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRegion()
	 * @generated
	 * @ordered
	 */
	protected static final String REGION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRegion() <em>Region</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRegion()
	 * @generated
	 * @ordered
	 */
	protected String region = REGION_EDEFAULT;

	/**
	 * The default value of the '{@link #getCity() <em>City</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCity()
	 * @generated
	 * @ordered
	 */
	protected static final String CITY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCity() <em>City</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCity()
	 * @generated
	 * @ordered
	 */
	protected String city = CITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getSubscriptionStatus() <em>Subscription Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubscriptionStatus()
	 * @generated
	 * @ordered
	 */
	protected static final SubscriptionStatus SUBSCRIPTION_STATUS_EDEFAULT = SubscriptionStatus.FREE;

	/**
	 * The cached value of the '{@link #getSubscriptionStatus() <em>Subscription Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubscriptionStatus()
	 * @generated
	 * @ordered
	 */
	protected SubscriptionStatus subscriptionStatus = SUBSCRIPTION_STATUS_EDEFAULT;

	/**
	 * The default value of the '{@link #getActive() <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getActive()
	 * @generated
	 * @ordered
	 */
	protected static final Boolean ACTIVE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getActive() <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getActive()
	 * @generated
	 * @ordered
	 */
	protected Boolean active = ACTIVE_EDEFAULT;

	/**
	 * The default value of the '{@link #getMeritPoints() <em>Merit Points</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMeritPoints()
	 * @generated
	 * @ordered
	 */
	protected static final BigInteger MERIT_POINTS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMeritPoints() <em>Merit Points</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMeritPoints()
	 * @generated
	 * @ordered
	 */
	protected BigInteger meritPoints = MERIT_POINTS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getFavCourses() <em>Fav Courses</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFavCourses()
	 * @generated
	 * @ordered
	 */
	protected EList<GolfCourse> favCourses;

	/**
	 * The cached value of the '{@link #getGolfCourseHistory() <em>Golf Course History</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGolfCourseHistory()
	 * @generated
	 * @ordered
	 */
	protected EList<GolfCourse> golfCourseHistory;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlayerProfileImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return PlayerApiPackage.Literals.PLAYER_PROFILE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUserHandle() {
		return userHandle;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUserHandle(String newUserHandle) {
		String oldUserHandle = userHandle;
		userHandle = newUserHandle;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__USER_HANDLE, oldUserHandle, userHandle));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getProfilePictureUrl() {
		return profilePictureUrl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setProfilePictureUrl(String newProfilePictureUrl) {
		String oldProfilePictureUrl = profilePictureUrl;
		profilePictureUrl = newProfilePictureUrl;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__PROFILE_PICTURE_URL, oldProfilePictureUrl, profilePictureUrl));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Gender getGender() {
		return gender;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGender(Gender newGender) {
		Gender oldGender = gender;
		gender = newGender == null ? GENDER_EDEFAULT : newGender;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__GENDER, oldGender, gender));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCountry() {
		return country;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCountry(String newCountry) {
		String oldCountry = country;
		country = newCountry;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__COUNTRY, oldCountry, country));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getState() {
		return state;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setState(String newState) {
		String oldState = state;
		state = newState;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__STATE, oldState, state));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRegion() {
		return region;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRegion(String newRegion) {
		String oldRegion = region;
		region = newRegion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__REGION, oldRegion, region));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCity() {
		return city;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCity(String newCity) {
		String oldCity = city;
		city = newCity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__CITY, oldCity, city));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SubscriptionStatus getSubscriptionStatus() {
		return subscriptionStatus;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSubscriptionStatus(SubscriptionStatus newSubscriptionStatus) {
		SubscriptionStatus oldSubscriptionStatus = subscriptionStatus;
		subscriptionStatus = newSubscriptionStatus == null ? SUBSCRIPTION_STATUS_EDEFAULT : newSubscriptionStatus;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__SUBSCRIPTION_STATUS, oldSubscriptionStatus, subscriptionStatus));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Boolean getActive() {
		return active;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setActive(Boolean newActive) {
		Boolean oldActive = active;
		active = newActive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__ACTIVE, oldActive, active));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BigInteger getMeritPoints() {
		return meritPoints;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMeritPoints(BigInteger newMeritPoints) {
		BigInteger oldMeritPoints = meritPoints;
		meritPoints = newMeritPoints;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PlayerApiPackage.PLAYER_PROFILE__MERIT_POINTS, oldMeritPoints, meritPoints));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<GolfCourse> getFavCourses() {
		if (favCourses == null) {
			favCourses = new EObjectContainmentEList<GolfCourse>(GolfCourse.class, this, PlayerApiPackage.PLAYER_PROFILE__FAV_COURSES);
		}
		return favCourses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<GolfCourse> getGolfCourseHistory() {
		if (golfCourseHistory == null) {
			golfCourseHistory = new EObjectContainmentEList<GolfCourse>(GolfCourse.class, this, PlayerApiPackage.PLAYER_PROFILE__GOLF_COURSE_HISTORY);
		}
		return golfCourseHistory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case PlayerApiPackage.PLAYER_PROFILE__FAV_COURSES:
				return ((InternalEList<?>)getFavCourses()).basicRemove(otherEnd, msgs);
			case PlayerApiPackage.PLAYER_PROFILE__GOLF_COURSE_HISTORY:
				return ((InternalEList<?>)getGolfCourseHistory()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case PlayerApiPackage.PLAYER_PROFILE__ID:
				return getId();
			case PlayerApiPackage.PLAYER_PROFILE__USER_HANDLE:
				return getUserHandle();
			case PlayerApiPackage.PLAYER_PROFILE__PROFILE_PICTURE_URL:
				return getProfilePictureUrl();
			case PlayerApiPackage.PLAYER_PROFILE__GENDER:
				return getGender();
			case PlayerApiPackage.PLAYER_PROFILE__COUNTRY:
				return getCountry();
			case PlayerApiPackage.PLAYER_PROFILE__STATE:
				return getState();
			case PlayerApiPackage.PLAYER_PROFILE__REGION:
				return getRegion();
			case PlayerApiPackage.PLAYER_PROFILE__CITY:
				return getCity();
			case PlayerApiPackage.PLAYER_PROFILE__SUBSCRIPTION_STATUS:
				return getSubscriptionStatus();
			case PlayerApiPackage.PLAYER_PROFILE__ACTIVE:
				return getActive();
			case PlayerApiPackage.PLAYER_PROFILE__MERIT_POINTS:
				return getMeritPoints();
			case PlayerApiPackage.PLAYER_PROFILE__FAV_COURSES:
				return getFavCourses();
			case PlayerApiPackage.PLAYER_PROFILE__GOLF_COURSE_HISTORY:
				return getGolfCourseHistory();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case PlayerApiPackage.PLAYER_PROFILE__ID:
				setId((String)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__USER_HANDLE:
				setUserHandle((String)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__PROFILE_PICTURE_URL:
				setProfilePictureUrl((String)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__GENDER:
				setGender((Gender)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__COUNTRY:
				setCountry((String)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__STATE:
				setState((String)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__REGION:
				setRegion((String)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__CITY:
				setCity((String)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__SUBSCRIPTION_STATUS:
				setSubscriptionStatus((SubscriptionStatus)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__ACTIVE:
				setActive((Boolean)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__MERIT_POINTS:
				setMeritPoints((BigInteger)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__FAV_COURSES:
				getFavCourses().clear();
				getFavCourses().addAll((Collection<? extends GolfCourse>)newValue);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__GOLF_COURSE_HISTORY:
				getGolfCourseHistory().clear();
				getGolfCourseHistory().addAll((Collection<? extends GolfCourse>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case PlayerApiPackage.PLAYER_PROFILE__ID:
				setId(ID_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__USER_HANDLE:
				setUserHandle(USER_HANDLE_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__PROFILE_PICTURE_URL:
				setProfilePictureUrl(PROFILE_PICTURE_URL_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__GENDER:
				setGender(GENDER_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__COUNTRY:
				setCountry(COUNTRY_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__STATE:
				setState(STATE_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__REGION:
				setRegion(REGION_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__CITY:
				setCity(CITY_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__SUBSCRIPTION_STATUS:
				setSubscriptionStatus(SUBSCRIPTION_STATUS_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__ACTIVE:
				setActive(ACTIVE_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__MERIT_POINTS:
				setMeritPoints(MERIT_POINTS_EDEFAULT);
				return;
			case PlayerApiPackage.PLAYER_PROFILE__FAV_COURSES:
				getFavCourses().clear();
				return;
			case PlayerApiPackage.PLAYER_PROFILE__GOLF_COURSE_HISTORY:
				getGolfCourseHistory().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case PlayerApiPackage.PLAYER_PROFILE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case PlayerApiPackage.PLAYER_PROFILE__USER_HANDLE:
				return USER_HANDLE_EDEFAULT == null ? userHandle != null : !USER_HANDLE_EDEFAULT.equals(userHandle);
			case PlayerApiPackage.PLAYER_PROFILE__PROFILE_PICTURE_URL:
				return PROFILE_PICTURE_URL_EDEFAULT == null ? profilePictureUrl != null : !PROFILE_PICTURE_URL_EDEFAULT.equals(profilePictureUrl);
			case PlayerApiPackage.PLAYER_PROFILE__GENDER:
				return gender != GENDER_EDEFAULT;
			case PlayerApiPackage.PLAYER_PROFILE__COUNTRY:
				return COUNTRY_EDEFAULT == null ? country != null : !COUNTRY_EDEFAULT.equals(country);
			case PlayerApiPackage.PLAYER_PROFILE__STATE:
				return STATE_EDEFAULT == null ? state != null : !STATE_EDEFAULT.equals(state);
			case PlayerApiPackage.PLAYER_PROFILE__REGION:
				return REGION_EDEFAULT == null ? region != null : !REGION_EDEFAULT.equals(region);
			case PlayerApiPackage.PLAYER_PROFILE__CITY:
				return CITY_EDEFAULT == null ? city != null : !CITY_EDEFAULT.equals(city);
			case PlayerApiPackage.PLAYER_PROFILE__SUBSCRIPTION_STATUS:
				return subscriptionStatus != SUBSCRIPTION_STATUS_EDEFAULT;
			case PlayerApiPackage.PLAYER_PROFILE__ACTIVE:
				return ACTIVE_EDEFAULT == null ? active != null : !ACTIVE_EDEFAULT.equals(active);
			case PlayerApiPackage.PLAYER_PROFILE__MERIT_POINTS:
				return MERIT_POINTS_EDEFAULT == null ? meritPoints != null : !MERIT_POINTS_EDEFAULT.equals(meritPoints);
			case PlayerApiPackage.PLAYER_PROFILE__FAV_COURSES:
				return favCourses != null && !favCourses.isEmpty();
			case PlayerApiPackage.PLAYER_PROFILE__GOLF_COURSE_HISTORY:
				return golfCourseHistory != null && !golfCourseHistory.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", userHandle: ");
		result.append(userHandle);
		result.append(", profilePictureUrl: ");
		result.append(profilePictureUrl);
		result.append(", gender: ");
		result.append(gender);
		result.append(", country: ");
		result.append(country);
		result.append(", state: ");
		result.append(state);
		result.append(", region: ");
		result.append(region);
		result.append(", city: ");
		result.append(city);
		result.append(", subscriptionStatus: ");
		result.append(subscriptionStatus);
		result.append(", active: ");
		result.append(active);
		result.append(", meritPoints: ");
		result.append(meritPoints);
		result.append(')');
		return result.toString();
	}

} //PlayerProfileImpl
