/**
 */
package com.playertour.backend.api.impl;

import com.playertour.backend.api.Base;
import com.playertour.backend.api.CoursePreference;
import com.playertour.backend.api.CourseType;
import com.playertour.backend.api.Gender;
import com.playertour.backend.api.GolfCourse;
import com.playertour.backend.api.GolfCourseResource;
import com.playertour.backend.api.GolfCourseSearchResult;
import com.playertour.backend.api.GolfCourseSearchResults;
import com.playertour.backend.api.HoleScore;
import com.playertour.backend.api.Location;
import com.playertour.backend.api.PlayerApiFactory;
import com.playertour.backend.api.PlayerApiPackage;
import com.playertour.backend.api.PlayerProfile;
import com.playertour.backend.api.ScoreCard;
import com.playertour.backend.api.ScoreCardResource;
import com.playertour.backend.api.ScorecardSearchResults;
import com.playertour.backend.api.Stroke;
import com.playertour.backend.api.StrokeType;
import com.playertour.backend.api.SubscriptionStatus;

import java.util.Map;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class PlayerApiPackageImpl extends EPackageImpl implements PlayerApiPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass baseEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass playerProfileEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass strokeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass holeScoreEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass scoreCardEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass locationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass scoreCardResourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass golfCourseResourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass golfCourseEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass golfCourseSearchResultEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass golfCourseSearchResultsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stringToStringMapEntryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass scorecardSearchResultsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum subscriptionStatusEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum genderEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum coursePreferenceEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum strokeTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum courseTypeEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see com.playertour.backend.api.PlayerApiPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private PlayerApiPackageImpl() {
		super(eNS_URI, PlayerApiFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link PlayerApiPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static PlayerApiPackage init() {
		if (isInited) return (PlayerApiPackage)EPackage.Registry.INSTANCE.getEPackage(PlayerApiPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredPlayerApiPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		PlayerApiPackageImpl thePlayerApiPackage = registeredPlayerApiPackage instanceof PlayerApiPackageImpl ? (PlayerApiPackageImpl)registeredPlayerApiPackage : new PlayerApiPackageImpl();

		isInited = true;

		// Create package meta-data objects
		thePlayerApiPackage.createPackageContents();

		// Initialize created meta-data
		thePlayerApiPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		thePlayerApiPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(PlayerApiPackage.eNS_URI, thePlayerApiPackage);
		return thePlayerApiPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getBase() {
		return baseEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getBase_Id() {
		return (EAttribute)baseEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPlayerProfile() {
		return playerProfileEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlayerProfile_UserHandle() {
		return (EAttribute)playerProfileEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlayerProfile_ProfilePictureUrl() {
		return (EAttribute)playerProfileEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlayerProfile_Gender() {
		return (EAttribute)playerProfileEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlayerProfile_Country() {
		return (EAttribute)playerProfileEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlayerProfile_State() {
		return (EAttribute)playerProfileEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlayerProfile_Region() {
		return (EAttribute)playerProfileEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlayerProfile_City() {
		return (EAttribute)playerProfileEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlayerProfile_SubscriptionStatus() {
		return (EAttribute)playerProfileEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlayerProfile_Active() {
		return (EAttribute)playerProfileEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlayerProfile_MeritPoints() {
		return (EAttribute)playerProfileEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPlayerProfile_FavCourses() {
		return (EReference)playerProfileEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPlayerProfile_GolfCourseHistory() {
		return (EReference)playerProfileEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getStroke() {
		return strokeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStroke_TimeStamp() {
		return (EAttribute)strokeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getStroke_Location() {
		return (EReference)strokeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStroke_GolfClubType() {
		return (EAttribute)strokeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStroke_PreviousStrokeId() {
		return (EAttribute)strokeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStroke_Type() {
		return (EAttribute)strokeEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getHoleScore() {
		return holeScoreEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHoleScore_TimeStamp() {
		return (EAttribute)holeScoreEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHoleScore_HoleNumber() {
		return (EAttribute)holeScoreEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHoleScore_Strokes() {
		return (EReference)holeScoreEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHoleScore_Score() {
		return (EAttribute)holeScoreEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHoleScore_Puts() {
		return (EAttribute)holeScoreEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getScoreCard() {
		return scoreCardEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScoreCard_Start() {
		return (EAttribute)scoreCardEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScoreCard_End() {
		return (EAttribute)scoreCardEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScoreCard_CourseId() {
		return (EAttribute)scoreCardEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getScoreCard_Freeze() {
		return (EAttribute)scoreCardEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getScoreCard_HoleStats() {
		return (EReference)scoreCardEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getLocation() {
		return locationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getLocation_Lat() {
		return (EAttribute)locationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getLocation_Lng() {
		return (EAttribute)locationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getScoreCardResource() {
		return scoreCardResourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getScoreCardResource__SaveScoreCard() {
		return scoreCardResourceEClass.getEOperations().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getScoreCardResource__GetMyScorcards() {
		return scoreCardResourceEClass.getEOperations().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getScoreCardResource__GetScorecardsByCourse__String() {
		return scoreCardResourceEClass.getEOperations().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getScoreCardResource__OpenScoreCard__String() {
		return scoreCardResourceEClass.getEOperations().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getScoreCardResource__SubmitStroke__String_Stroke() {
		return scoreCardResourceEClass.getEOperations().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getScoreCardResource__CloseHole__String_HoleScore() {
		return scoreCardResourceEClass.getEOperations().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getScoreCardResource__CloseScoreCard__String_HoleScore() {
		return scoreCardResourceEClass.getEOperations().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGolfCourseResource() {
		return golfCourseResourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getGolfCourseResource__SearchByName__String() {
		return golfCourseResourceEClass.getEOperations().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getGolfCourseResource__SearchByLocation__double_double() {
		return golfCourseResourceEClass.getEOperations().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGolfCourse() {
		return golfCourseEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_Type() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_Name() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGolfCourse_Location() {
		return (EReference)golfCourseEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_CoursePictureUrl() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGolfCourseSearchResult() {
		return golfCourseSearchResultEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGolfCourseSearchResult_Course() {
		return (EReference)golfCourseSearchResultEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourseSearchResult_Distance() {
		return (EAttribute)golfCourseSearchResultEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGolfCourseSearchResults() {
		return golfCourseSearchResultsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGolfCourseSearchResults_Results() {
		return (EReference)golfCourseSearchResultsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getStringToStringMapEntry() {
		return stringToStringMapEntryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStringToStringMapEntry_Key() {
		return (EAttribute)stringToStringMapEntryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStringToStringMapEntry_Value() {
		return (EAttribute)stringToStringMapEntryEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getScorecardSearchResults() {
		return scorecardSearchResultsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getScorecardSearchResults_Results() {
		return (EReference)scorecardSearchResultsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getSubscriptionStatus() {
		return subscriptionStatusEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getGender() {
		return genderEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getCoursePreference() {
		return coursePreferenceEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getStrokeType() {
		return strokeTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getCourseType() {
		return courseTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PlayerApiFactory getPlayerApiFactory() {
		return (PlayerApiFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		baseEClass = createEClass(BASE);
		createEAttribute(baseEClass, BASE__ID);

		playerProfileEClass = createEClass(PLAYER_PROFILE);
		createEAttribute(playerProfileEClass, PLAYER_PROFILE__USER_HANDLE);
		createEAttribute(playerProfileEClass, PLAYER_PROFILE__PROFILE_PICTURE_URL);
		createEAttribute(playerProfileEClass, PLAYER_PROFILE__GENDER);
		createEAttribute(playerProfileEClass, PLAYER_PROFILE__COUNTRY);
		createEAttribute(playerProfileEClass, PLAYER_PROFILE__STATE);
		createEAttribute(playerProfileEClass, PLAYER_PROFILE__REGION);
		createEAttribute(playerProfileEClass, PLAYER_PROFILE__CITY);
		createEAttribute(playerProfileEClass, PLAYER_PROFILE__SUBSCRIPTION_STATUS);
		createEAttribute(playerProfileEClass, PLAYER_PROFILE__ACTIVE);
		createEAttribute(playerProfileEClass, PLAYER_PROFILE__MERIT_POINTS);
		createEReference(playerProfileEClass, PLAYER_PROFILE__FAV_COURSES);
		createEReference(playerProfileEClass, PLAYER_PROFILE__GOLF_COURSE_HISTORY);

		strokeEClass = createEClass(STROKE);
		createEAttribute(strokeEClass, STROKE__TIME_STAMP);
		createEReference(strokeEClass, STROKE__LOCATION);
		createEAttribute(strokeEClass, STROKE__GOLF_CLUB_TYPE);
		createEAttribute(strokeEClass, STROKE__PREVIOUS_STROKE_ID);
		createEAttribute(strokeEClass, STROKE__TYPE);

		holeScoreEClass = createEClass(HOLE_SCORE);
		createEAttribute(holeScoreEClass, HOLE_SCORE__TIME_STAMP);
		createEAttribute(holeScoreEClass, HOLE_SCORE__HOLE_NUMBER);
		createEReference(holeScoreEClass, HOLE_SCORE__STROKES);
		createEAttribute(holeScoreEClass, HOLE_SCORE__SCORE);
		createEAttribute(holeScoreEClass, HOLE_SCORE__PUTS);

		scoreCardEClass = createEClass(SCORE_CARD);
		createEAttribute(scoreCardEClass, SCORE_CARD__START);
		createEAttribute(scoreCardEClass, SCORE_CARD__END);
		createEAttribute(scoreCardEClass, SCORE_CARD__COURSE_ID);
		createEAttribute(scoreCardEClass, SCORE_CARD__FREEZE);
		createEReference(scoreCardEClass, SCORE_CARD__HOLE_STATS);

		locationEClass = createEClass(LOCATION);
		createEAttribute(locationEClass, LOCATION__LAT);
		createEAttribute(locationEClass, LOCATION__LNG);

		scoreCardResourceEClass = createEClass(SCORE_CARD_RESOURCE);
		createEOperation(scoreCardResourceEClass, SCORE_CARD_RESOURCE___SAVE_SCORE_CARD);
		createEOperation(scoreCardResourceEClass, SCORE_CARD_RESOURCE___GET_MY_SCORCARDS);
		createEOperation(scoreCardResourceEClass, SCORE_CARD_RESOURCE___GET_SCORECARDS_BY_COURSE__STRING);
		createEOperation(scoreCardResourceEClass, SCORE_CARD_RESOURCE___OPEN_SCORE_CARD__STRING);
		createEOperation(scoreCardResourceEClass, SCORE_CARD_RESOURCE___SUBMIT_STROKE__STRING_STROKE);
		createEOperation(scoreCardResourceEClass, SCORE_CARD_RESOURCE___CLOSE_HOLE__STRING_HOLESCORE);
		createEOperation(scoreCardResourceEClass, SCORE_CARD_RESOURCE___CLOSE_SCORE_CARD__STRING_HOLESCORE);

		golfCourseResourceEClass = createEClass(GOLF_COURSE_RESOURCE);
		createEOperation(golfCourseResourceEClass, GOLF_COURSE_RESOURCE___SEARCH_BY_NAME__STRING);
		createEOperation(golfCourseResourceEClass, GOLF_COURSE_RESOURCE___SEARCH_BY_LOCATION__DOUBLE_DOUBLE);

		golfCourseEClass = createEClass(GOLF_COURSE);
		createEAttribute(golfCourseEClass, GOLF_COURSE__TYPE);
		createEAttribute(golfCourseEClass, GOLF_COURSE__NAME);
		createEReference(golfCourseEClass, GOLF_COURSE__LOCATION);
		createEAttribute(golfCourseEClass, GOLF_COURSE__COURSE_PICTURE_URL);

		golfCourseSearchResultEClass = createEClass(GOLF_COURSE_SEARCH_RESULT);
		createEReference(golfCourseSearchResultEClass, GOLF_COURSE_SEARCH_RESULT__COURSE);
		createEAttribute(golfCourseSearchResultEClass, GOLF_COURSE_SEARCH_RESULT__DISTANCE);

		golfCourseSearchResultsEClass = createEClass(GOLF_COURSE_SEARCH_RESULTS);
		createEReference(golfCourseSearchResultsEClass, GOLF_COURSE_SEARCH_RESULTS__RESULTS);

		stringToStringMapEntryEClass = createEClass(STRING_TO_STRING_MAP_ENTRY);
		createEAttribute(stringToStringMapEntryEClass, STRING_TO_STRING_MAP_ENTRY__KEY);
		createEAttribute(stringToStringMapEntryEClass, STRING_TO_STRING_MAP_ENTRY__VALUE);

		scorecardSearchResultsEClass = createEClass(SCORECARD_SEARCH_RESULTS);
		createEReference(scorecardSearchResultsEClass, SCORECARD_SEARCH_RESULTS__RESULTS);

		// Create enums
		subscriptionStatusEEnum = createEEnum(SUBSCRIPTION_STATUS);
		genderEEnum = createEEnum(GENDER);
		coursePreferenceEEnum = createEEnum(COURSE_PREFERENCE);
		strokeTypeEEnum = createEEnum(STROKE_TYPE);
		courseTypeEEnum = createEEnum(COURSE_TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		playerProfileEClass.getESuperTypes().add(this.getBase());
		strokeEClass.getESuperTypes().add(this.getBase());
		holeScoreEClass.getESuperTypes().add(this.getBase());
		scoreCardEClass.getESuperTypes().add(this.getBase());
		golfCourseEClass.getESuperTypes().add(this.getBase());

		// Initialize classes, features, and operations; add parameters
		initEClass(baseEClass, Base.class, "Base", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getBase_Id(), ecorePackage.getEString(), "id", null, 1, 1, Base.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(playerProfileEClass, PlayerProfile.class, "PlayerProfile", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPlayerProfile_UserHandle(), ecorePackage.getEString(), "userHandle", null, 0, 1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPlayerProfile_ProfilePictureUrl(), ecorePackage.getEString(), "profilePictureUrl", null, 0, 1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPlayerProfile_Gender(), this.getGender(), "gender", null, 0, 1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPlayerProfile_Country(), ecorePackage.getEString(), "country", null, 0, 1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPlayerProfile_State(), ecorePackage.getEString(), "state", null, 0, 1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPlayerProfile_Region(), ecorePackage.getEString(), "region", null, 0, 1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPlayerProfile_City(), ecorePackage.getEString(), "city", null, 0, 1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPlayerProfile_SubscriptionStatus(), this.getSubscriptionStatus(), "subscriptionStatus", null, 0, 1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPlayerProfile_Active(), ecorePackage.getEBooleanObject(), "active", null, 0, 1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPlayerProfile_MeritPoints(), ecorePackage.getEBigInteger(), "meritPoints", null, 0, 1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPlayerProfile_FavCourses(), this.getGolfCourse(), null, "favCourses", null, 0, -1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getPlayerProfile_GolfCourseHistory(), this.getGolfCourse(), null, "golfCourseHistory", null, 0, -1, PlayerProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(strokeEClass, Stroke.class, "Stroke", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStroke_TimeStamp(), ecorePackage.getEDate(), "timeStamp", null, 1, 1, Stroke.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getStroke_Location(), this.getLocation(), null, "location", null, 0, 1, Stroke.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStroke_GolfClubType(), ecorePackage.getEString(), "golfClubType", null, 0, 1, Stroke.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStroke_PreviousStrokeId(), ecorePackage.getEString(), "previousStrokeId", null, 0, 1, Stroke.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStroke_Type(), this.getStrokeType(), "type", null, 0, 1, Stroke.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(holeScoreEClass, HoleScore.class, "HoleScore", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getHoleScore_TimeStamp(), ecorePackage.getEDate(), "timeStamp", null, 1, 1, HoleScore.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHoleScore_HoleNumber(), ecorePackage.getEBigInteger(), "holeNumber", null, 1, 1, HoleScore.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHoleScore_Strokes(), this.getStroke(), null, "strokes", null, 0, 1, HoleScore.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHoleScore_Score(), ecorePackage.getEBigInteger(), "score", null, 1, 1, HoleScore.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getHoleScore_Puts(), ecorePackage.getEBigInteger(), "puts", null, 0, 1, HoleScore.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(scoreCardEClass, ScoreCard.class, "ScoreCard", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getScoreCard_Start(), ecorePackage.getEDate(), "start", null, 1, 1, ScoreCard.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScoreCard_End(), ecorePackage.getEDate(), "end", null, 0, 1, ScoreCard.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScoreCard_CourseId(), ecorePackage.getEString(), "courseId", null, 1, 1, ScoreCard.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getScoreCard_Freeze(), ecorePackage.getEBooleanObject(), "freeze", null, 0, 1, ScoreCard.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getScoreCard_HoleStats(), this.getHoleScore(), null, "holeStats", null, 0, 1, ScoreCard.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(locationEClass, Location.class, "Location", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLocation_Lat(), ecorePackage.getEDouble(), "lat", null, 1, 1, Location.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLocation_Lng(), ecorePackage.getEDouble(), "lng", null, 1, 1, Location.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(scoreCardResourceEClass, ScoreCardResource.class, "ScoreCardResource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEOperation(getScoreCardResource__SaveScoreCard(), null, "saveScoreCard", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getScoreCardResource__GetMyScorcards(), null, "getMyScorcards", 0, 1, IS_UNIQUE, IS_ORDERED);

		EOperation op = initEOperation(getScoreCardResource__GetScorecardsByCourse__String(), null, "getScorecardsByCourse", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "courseId", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getScoreCardResource__OpenScoreCard__String(), null, "openScoreCard", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "courseId", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getScoreCardResource__SubmitStroke__String_Stroke(), null, "submitStroke", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "scorecardId", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getStroke(), "stroke", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getScoreCardResource__CloseHole__String_HoleScore(), null, "closeHole", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "scorecardId", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getHoleScore(), "holescore", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getScoreCardResource__CloseScoreCard__String_HoleScore(), null, "closeScoreCard", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "scorecardId", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getHoleScore(), "holescore", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(golfCourseResourceEClass, GolfCourseResource.class, "GolfCourseResource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		op = initEOperation(getGolfCourseResource__SearchByName__String(), null, "searchByName", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "name", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getGolfCourseResource__SearchByLocation__double_double(), null, "searchByLocation", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEDouble(), "lat", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEDouble(), "lng", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(golfCourseEClass, GolfCourse.class, "GolfCourse", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getGolfCourse_Type(), this.getCourseType(), "type", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGolfCourse_Name(), ecorePackage.getEString(), "name", null, 1, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGolfCourse_Location(), this.getLocation(), null, "location", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGolfCourse_CoursePictureUrl(), ecorePackage.getEString(), "coursePictureUrl", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(golfCourseSearchResultEClass, GolfCourseSearchResult.class, "GolfCourseSearchResult", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getGolfCourseSearchResult_Course(), this.getGolfCourse(), null, "course", null, 0, 1, GolfCourseSearchResult.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGolfCourseSearchResult_Distance(), ecorePackage.getEDoubleObject(), "distance", null, 0, 1, GolfCourseSearchResult.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(golfCourseSearchResultsEClass, GolfCourseSearchResults.class, "GolfCourseSearchResults", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getGolfCourseSearchResults_Results(), this.getGolfCourseSearchResult(), null, "results", null, 0, -1, GolfCourseSearchResults.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(stringToStringMapEntryEClass, Map.Entry.class, "StringToStringMapEntry", !IS_ABSTRACT, !IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStringToStringMapEntry_Key(), ecorePackage.getEString(), "key", null, 0, 1, Map.Entry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStringToStringMapEntry_Value(), ecorePackage.getEString(), "value", null, 0, 1, Map.Entry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(scorecardSearchResultsEClass, ScorecardSearchResults.class, "ScorecardSearchResults", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getScorecardSearchResults_Results(), this.getScoreCard(), null, "results", null, 0, -1, ScorecardSearchResults.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(subscriptionStatusEEnum, SubscriptionStatus.class, "SubscriptionStatus");
		addEEnumLiteral(subscriptionStatusEEnum, SubscriptionStatus.FREE);
		addEEnumLiteral(subscriptionStatusEEnum, SubscriptionStatus.PREMIUM);

		initEEnum(genderEEnum, Gender.class, "Gender");
		addEEnumLiteral(genderEEnum, Gender.OTHER);
		addEEnumLiteral(genderEEnum, Gender.FEMALE);
		addEEnumLiteral(genderEEnum, Gender.MALE);

		initEEnum(coursePreferenceEEnum, CoursePreference.class, "CoursePreference");
		addEEnumLiteral(coursePreferenceEEnum, CoursePreference.NONE);
		addEEnumLiteral(coursePreferenceEEnum, CoursePreference.BLUE);
		addEEnumLiteral(coursePreferenceEEnum, CoursePreference.RED);

		initEEnum(strokeTypeEEnum, StrokeType.class, "StrokeType");
		addEEnumLiteral(strokeTypeEEnum, StrokeType.DEFAULT);
		addEEnumLiteral(strokeTypeEEnum, StrokeType.PUT);

		initEEnum(courseTypeEEnum, CourseType.class, "CourseType");
		addEEnumLiteral(courseTypeEEnum, CourseType.NINE);
		addEEnumLiteral(courseTypeEEnum, CourseType.EIGHTEEN);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/OCL/Import
		createImportAnnotations();
		// http://www.eclipse.org/OCL/Collection
		createCollectionAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/OCL/Import</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createImportAnnotations() {
		String source = "http://www.eclipse.org/OCL/Import";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "ecore", "http://www.eclipse.org/emf/2002/Ecore"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/OCL/Collection</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createCollectionAnnotations() {
		String source = "http://www.eclipse.org/OCL/Collection";
		addAnnotation
		  (getPlayerProfile_FavCourses(),
		   source,
		   new String[] {
			   "nullFree", "false"
		   });
		addAnnotation
		  (getPlayerProfile_GolfCourseHistory(),
		   source,
		   new String[] {
			   "nullFree", "false"
		   });
		addAnnotation
		  (getGolfCourseSearchResults_Results(),
		   source,
		   new String[] {
			   "nullFree", "false"
		   });
		addAnnotation
		  (getScorecardSearchResults_Results(),
		   source,
		   new String[] {
			   "nullFree", "false"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (getGolfCourseSearchResult_Distance(),
		   source,
		   new String[] {
			   "documentation", "If a Location was given, this is the distance to you position in km"
		   });
	}

} //PlayerApiPackageImpl
