/**
 */
package com.playertour.backend.api.util;

import com.playertour.backend.api.*;

import java.util.Map;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see com.playertour.backend.api.PlayerApiPackage
 * @generated
 */
public class PlayerApiAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static PlayerApiPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PlayerApiAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = PlayerApiPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlayerApiSwitch<Adapter> modelSwitch =
		new PlayerApiSwitch<Adapter>() {
			@Override
			public Adapter caseBase(Base object) {
				return createBaseAdapter();
			}
			@Override
			public Adapter casePlayerProfile(PlayerProfile object) {
				return createPlayerProfileAdapter();
			}
			@Override
			public Adapter caseStroke(Stroke object) {
				return createStrokeAdapter();
			}
			@Override
			public Adapter caseHoleScore(HoleScore object) {
				return createHoleScoreAdapter();
			}
			@Override
			public Adapter caseScoreCard(ScoreCard object) {
				return createScoreCardAdapter();
			}
			@Override
			public Adapter caseLocation(Location object) {
				return createLocationAdapter();
			}
			@Override
			public Adapter caseScoreCardResource(ScoreCardResource object) {
				return createScoreCardResourceAdapter();
			}
			@Override
			public Adapter caseGolfCourseResource(GolfCourseResource object) {
				return createGolfCourseResourceAdapter();
			}
			@Override
			public Adapter caseGolfCourse(GolfCourse object) {
				return createGolfCourseAdapter();
			}
			@Override
			public Adapter caseGolfCourseSearchResult(GolfCourseSearchResult object) {
				return createGolfCourseSearchResultAdapter();
			}
			@Override
			public Adapter caseGolfCourseSearchResults(GolfCourseSearchResults object) {
				return createGolfCourseSearchResultsAdapter();
			}
			@Override
			public Adapter caseStringToStringMapEntry(Map.Entry<String, String> object) {
				return createStringToStringMapEntryAdapter();
			}
			@Override
			public Adapter caseScorecardSearchResults(ScorecardSearchResults object) {
				return createScorecardSearchResultsAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.Base <em>Base</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.Base
	 * @generated
	 */
	public Adapter createBaseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.PlayerProfile <em>Player Profile</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.PlayerProfile
	 * @generated
	 */
	public Adapter createPlayerProfileAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.Stroke <em>Stroke</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.Stroke
	 * @generated
	 */
	public Adapter createStrokeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.HoleScore <em>Hole Score</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.HoleScore
	 * @generated
	 */
	public Adapter createHoleScoreAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.ScoreCard <em>Score Card</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.ScoreCard
	 * @generated
	 */
	public Adapter createScoreCardAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.Location <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.Location
	 * @generated
	 */
	public Adapter createLocationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.ScoreCardResource <em>Score Card Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.ScoreCardResource
	 * @generated
	 */
	public Adapter createScoreCardResourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.GolfCourseResource <em>Golf Course Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.GolfCourseResource
	 * @generated
	 */
	public Adapter createGolfCourseResourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.GolfCourse <em>Golf Course</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.GolfCourse
	 * @generated
	 */
	public Adapter createGolfCourseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.GolfCourseSearchResult <em>Golf Course Search Result</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.GolfCourseSearchResult
	 * @generated
	 */
	public Adapter createGolfCourseSearchResultAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.GolfCourseSearchResults <em>Golf Course Search Results</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.GolfCourseSearchResults
	 * @generated
	 */
	public Adapter createGolfCourseSearchResultsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link java.util.Map.Entry <em>String To String Map Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see java.util.Map.Entry
	 * @generated
	 */
	public Adapter createStringToStringMapEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.api.ScorecardSearchResults <em>Scorecard Search Results</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.api.ScorecardSearchResults
	 * @generated
	 */
	public Adapter createScorecardSearchResultsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //PlayerApiAdapterFactory
