package com.playertour.backend.apis.common;

import org.gecko.search.document.CommitCallback;
import org.gecko.search.document.DocumentIndexContextObject;
import org.osgi.util.promise.Deferred;

public class DeferredCommitCallback implements CommitCallback {

	private Deferred<Boolean> deferred;

	/**
	 * Creates a new instance.
	 * @param deferred
	 */
	public DeferredCommitCallback(Deferred<Boolean> deferred) {
		this.deferred = deferred;
	}

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.search.document.CommitCallback#commited(org.gecko.search.document.DocumentIndexContextObject)
	 */
	@Override
	public void commited(DocumentIndexContextObject ctx) {
		deferred.resolve(true);
	}

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.search.document.CommitCallback#error(org.gecko.search.document.DocumentIndexContextObject, java.lang.Throwable)
	 */
	@Override
	public void error(DocumentIndexContextObject ctx, Throwable t) {
		deferred.fail(t);
	}


}
