package com.playertour.backend.apis.country;

import java.util.List;

import com.playertour.backend.apis.mmt.common.UnknownTransformationException;
import com.playertour.backend.country.model.country.Country;
import com.playertour.backend.country.model.country.State;
import com.playertour.backend.igolf.model.igolf.CountryInfo;
import com.playertour.backend.igolf.model.igolf.StateInfo;

/**
 * API to handle communications with our db to retrieve Country objects, and to save them after receiving the info from 
 * the IGolf API
 * 
 * @author ilenia
 *
 */
public interface CountryService {
	
	public Country saveCountry(CountryInfo iGolfCountry) throws UnknownTransformationException;
	
	public List<Country> saveCountries(List<CountryInfo> iGolfCountries) throws UnknownTransformationException;
	
	public List<State> saveStates(List<StateInfo> iGolfStates, String countryId) throws UnknownTransformationException;

}
