/**
 * 
 */
package com.playertour.backend.apis.player;

import java.util.List;

import com.playertour.backend.api.GolfCourseSearchResult;
import com.playertour.backend.api.PlayerProfile;

/**
 * @author ungei
 *
 */
public interface PlayerService {

	/**
	 * Retrieve the Users {@link PlayerProfile} profile for the login ID. 
	 * If the User does not exist, a new Profile is created on the fly.  
	 * @param userId
	 * @return the Users PlayerProfile or null
	 */
	PlayerProfile getPlayerProfile(String userId);

	PlayerProfile saveProfile(PlayerProfile profile, String userId);

	/**
	 * @param userId what user are we looking for
	 * @return a List of visited courses. Will never be <code>null</code>;
	 */
	List<GolfCourseSearchResult> visitedGolfCourses(String userId);
	
}
