package com.playertour.backend.apis.course;

import java.util.List;
import java.util.Map;

import com.playertour.backend.golfcourse.model.golfcourse.GolfCourse;

public interface CourseSearchService {

	public List<GolfCourse> getCoursesByName(String query, int maxResults);
	
	public GolfCourse getCourseByCourseId(String courseId);
	
	/**
	 * @return a map with the GoolfCourse as key and the distance (in km) from the provided lat and long
	 */
	public Map<GolfCourse, Double> getCoursesWithinDist(double latitude, double longitude, double maxDistInMeters);
	
	
}
