package com.playertour.backend.apis.igolf;

import java.util.List;

import com.playertour.backend.apis.igolf.exceptions.IGolfUpdateException;
import com.playertour.backend.igolf.model.igolf.CountryInfo;
import com.playertour.backend.igolf.model.igolf.StateInfo;

/**
 * API to use to call the IGolf API periodically in order to update our db with the info about the countries
 * @author ilenia
 *
 */
public interface CountryUpdateService {
	
	public List<CountryInfo> updateCountryList(String continentId) throws IGolfUpdateException;
		
	public List<StateInfo> updateStateList(String countryId) throws IGolfUpdateException;
	
	public Integer getRequestCounter();

}
