package com.playertour.backend.apis.igolf;

import java.util.List;

import com.playertour.backend.apis.igolf.exceptions.IGolfUpdateException;
import com.playertour.backend.igolf.model.igolf.CourseCompleteResponse;

/**
 * API to use to call the IGolf API periodically in order to update our db with the info about the golf courses
 * @author ilenia
 *
 */
public interface CourseUpdateService {
	
	public List<CourseCompleteResponse> updateCoursesPerContinent(String continentId) throws IGolfUpdateException;
	
	public List<CourseCompleteResponse> updateCoursesPerCountry(String countryId) throws IGolfUpdateException;
	
	public List<CourseCompleteResponse> updateCoursesPerState(String stateId) throws IGolfUpdateException;
	
	public List<CourseCompleteResponse> updateCoursesNearMe(Double latitude, Double longitude, Integer radiusInMiles) throws IGolfUpdateException;
	
	public CourseCompleteResponse updateCourse(String courseId) throws IGolfUpdateException;
	
	public Integer getRequestCounter();

}
