package com.playertour.backend.apis.mmt.common;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public interface PlayertourModelTransformator {
	
	/**
	 * Transforms any given Object
	 * @param source the source Object to transform
	 * @param to the EClass to transform into
	 * @return the transformed Object
	 * @throws UnknownTransformationException
	 */
	public <T extends EObject> T transform(EObject source, EClass to) throws UnknownTransformationException;

	/**
	 * Transforms any given Object
	 * @param source the source Object to transform
	 * @param to the EClass to transform into
	 * @param sourceEClass the sourceEClass to transform
	 * @return the transformed Object
	 * @throws UnknownTransformationException
	 */
	public <T extends EObject> T transform(EObject source, EClass sourceEClass, EClass to) throws UnknownTransformationException;

	/**
	 * Transforms any given Object
	 * @param source
	 * @param to
	 * @return
	 * @throws UnknownTransformationException
	 */
	public <T extends EObject> List<T> transform(List<? extends EObject> source, EClass to) throws UnknownTransformationException;

}
