/**
 */
package com.playertour.backend.challenges.model.challenges;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Challenge Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see com.playertour.backend.challenges.model.challenges.ChallengesPackage#getChallengeType()
 * @model
 * @generated
 */
public enum ChallengeType implements Enumerator {
	/**
	 * The '<em><b>DEFAULT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Consists in challenging a Player to complete a certain hole in less than a certain number of strokes.
	 * <!-- end-model-doc -->
	 * @see #DEFAULT_VALUE
	 * @generated
	 * @ordered
	 */
	DEFAULT(0, "DEFAULT", "DEFAULT"),

	/**
	 * The '<em><b>NASSAU</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Is a three-part challenge with the same stake wagered on the first nine holes, the second nine, and the total for the round. If you’re playing a $5 Nassau and you win all three parts, you’re up $15.
	 * <!-- end-model-doc -->
	 * @see #NASSAU_VALUE
	 * @generated
	 * @ordered
	 */
	NASSAU(1, "NASSAU", "NASSAU"),

	/**
	 * The '<em><b>SKINS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Is the format in which each hole is worth a certain amount — but if two players tie, all tie, and the money goes into the pot for the next hole (and sometimes the next and the next).
	 * <!-- end-model-doc -->
	 * @see #SKINS_VALUE
	 * @generated
	 * @ordered
	 */
	SKINS(2, "SKINS", "SKINS"),

	/**
	 * The '<em><b>WOLF</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * To play wolf, one player takes on everyone else in the group. For a set price, the lone wolf can choose one of the others as his or her partner.
	 * <!-- end-model-doc -->
	 * @see #WOLF_VALUE
	 * @generated
	 * @ordered
	 */
	WOLF(3, "WOLF", "WOLF"),

	/**
	 * The '<em><b>SNAKE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Snake is a side challenge: The first player to three-putt a hole gets stuck with a “snake” that costs a predetermined sum each hole until someone else three-putts.
	 * <!-- end-model-doc -->
	 * @see #SNAKE_VALUE
	 * @generated
	 * @ordered
	 */
	SNAKE(4, "SNAKE", "SNAKE"),

	/**
	 * The '<em><b>BINGO BANGO BONGO</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * In Bingo Bango Bongo, the first player on the green earns a point (bingo), as does the one closest to the hole when everybody’s safely on (bango) and the first to hole a putt (bongo).
	 * <!-- end-model-doc -->
	 * @see #BINGO_BANGO_BONGO_VALUE
	 * @generated
	 * @ordered
	 */
	BINGO_BANGO_BONGO(5, "BINGO_BANGO_BONGO", "BINGO_BANGO_BONGO");

	/**
	 * The '<em><b>DEFAULT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Consists in challenging a Player to complete a certain hole in less than a certain number of strokes.
	 * <!-- end-model-doc -->
	 * @see #DEFAULT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEFAULT_VALUE = 0;

	/**
	 * The '<em><b>NASSAU</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Is a three-part challenge with the same stake wagered on the first nine holes, the second nine, and the total for the round. If you’re playing a $5 Nassau and you win all three parts, you’re up $15.
	 * <!-- end-model-doc -->
	 * @see #NASSAU
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NASSAU_VALUE = 1;

	/**
	 * The '<em><b>SKINS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Is the format in which each hole is worth a certain amount — but if two players tie, all tie, and the money goes into the pot for the next hole (and sometimes the next and the next).
	 * <!-- end-model-doc -->
	 * @see #SKINS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SKINS_VALUE = 2;

	/**
	 * The '<em><b>WOLF</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * To play wolf, one player takes on everyone else in the group. For a set price, the lone wolf can choose one of the others as his or her partner.
	 * <!-- end-model-doc -->
	 * @see #WOLF
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WOLF_VALUE = 3;

	/**
	 * The '<em><b>SNAKE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Snake is a side challenge: The first player to three-putt a hole gets stuck with a “snake” that costs a predetermined sum each hole until someone else three-putts.
	 * <!-- end-model-doc -->
	 * @see #SNAKE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SNAKE_VALUE = 4;

	/**
	 * The '<em><b>BINGO BANGO BONGO</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * In Bingo Bango Bongo, the first player on the green earns a point (bingo), as does the one closest to the hole when everybody’s safely on (bango) and the first to hole a putt (bongo).
	 * <!-- end-model-doc -->
	 * @see #BINGO_BANGO_BONGO
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BINGO_BANGO_BONGO_VALUE = 5;

	/**
	 * An array of all the '<em><b>Challenge Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ChallengeType[] VALUES_ARRAY =
		new ChallengeType[] {
			DEFAULT,
			NASSAU,
			SKINS,
			WOLF,
			SNAKE,
			BINGO_BANGO_BONGO,
		};

	/**
	 * A public read-only list of all the '<em><b>Challenge Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ChallengeType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Challenge Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ChallengeType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ChallengeType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Challenge Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ChallengeType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ChallengeType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Challenge Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ChallengeType get(int value) {
		switch (value) {
			case DEFAULT_VALUE: return DEFAULT;
			case NASSAU_VALUE: return NASSAU;
			case SKINS_VALUE: return SKINS;
			case WOLF_VALUE: return WOLF;
			case SNAKE_VALUE: return SNAKE;
			case BINGO_BANGO_BONGO_VALUE: return BINGO_BANGO_BONGO;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ChallengeType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ChallengeType
