/**
 */
package com.playertour.backend.challenges.model.challenges;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.playertour.backend.challenges.model.challenges.ChallengesFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/OCL/Import ecore='http://www.eclipse.org/emf/2002/Ecore'"
 * @generated
 */
public interface ChallengesPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "challenges";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://theplayertour.com/backend/challenges/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Challenges";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ChallengesPackage eINSTANCE = com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl.init();

	/**
	 * The meta object id for the '{@link com.playertour.backend.challenges.model.challenges.impl.ChallengeImpl <em>Challenge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengeImpl
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallenge()
	 * @generated
	 */
	int CHALLENGE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE__ID = 0;

	/**
	 * The feature id for the '<em><b>Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE__DATE = 1;

	/**
	 * The feature id for the '<em><b>Participants</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE__PARTICIPANTS = 2;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE__STATUS = 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE__TYPE = 4;

	/**
	 * The feature id for the '<em><b>Content</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE__CONTENT = 5;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE__RESULT = 6;

	/**
	 * The number of structural features of the '<em>Challenge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>Challenge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.challenges.model.challenges.impl.ChallengeContentImpl <em>Challenge Content</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengeContentImpl
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeContent()
	 * @generated
	 */
	int CHALLENGE_CONTENT = 1;

	/**
	 * The feature id for the '<em><b>Course Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_CONTENT__COURSE_ID = 0;

	/**
	 * The feature id for the '<em><b>Course Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_CONTENT__COURSE_NAME = 1;

	/**
	 * The feature id for the '<em><b>Challenged Player Login Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_CONTENT__CHALLENGED_PLAYER_LOGIN_ID = 2;

	/**
	 * The feature id for the '<em><b>Hole Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_CONTENT__HOLE_NUMBER = 3;

	/**
	 * The feature id for the '<em><b>Min Strokes Needed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_CONTENT__MIN_STROKES_NEEDED = 4;

	/**
	 * The feature id for the '<em><b>Merit Points</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_CONTENT__MERIT_POINTS = 5;

	/**
	 * The number of structural features of the '<em>Challenge Content</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_CONTENT_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Challenge Content</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_CONTENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.challenges.model.challenges.impl.ChallengeParticipantImpl <em>Challenge Participant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengeParticipantImpl
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeParticipant()
	 * @generated
	 */
	int CHALLENGE_PARTICIPANT = 2;

	/**
	 * The feature id for the '<em><b>Player Login Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_PARTICIPANT__PLAYER_LOGIN_ID = 0;

	/**
	 * The feature id for the '<em><b>Player Login Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_PARTICIPANT__PLAYER_LOGIN_NAME = 1;

	/**
	 * The feature id for the '<em><b>Player Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_PARTICIPANT__PLAYER_NAME = 2;

	/**
	 * The feature id for the '<em><b>Against</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_PARTICIPANT__AGAINST = 3;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_PARTICIPANT__ROLE = 4;

	/**
	 * The number of structural features of the '<em>Challenge Participant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_PARTICIPANT_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Challenge Participant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_PARTICIPANT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.challenges.model.challenges.impl.ChallengeResultImpl <em>Challenge Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengeResultImpl
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeResult()
	 * @generated
	 */
	int CHALLENGE_RESULT = 3;

	/**
	 * The feature id for the '<em><b>Winners</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_RESULT__WINNERS = 0;

	/**
	 * The feature id for the '<em><b>Losers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_RESULT__LOSERS = 1;

	/**
	 * The number of structural features of the '<em>Challenge Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_RESULT_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Challenge Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_RESULT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.challenges.model.challenges.impl.ChallengeSearchResultImpl <em>Challenge Search Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengeSearchResultImpl
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeSearchResult()
	 * @generated
	 */
	int CHALLENGE_SEARCH_RESULT = 4;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_SEARCH_RESULT__RESULT = 0;

	/**
	 * The number of structural features of the '<em>Challenge Search Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_SEARCH_RESULT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Challenge Search Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHALLENGE_SEARCH_RESULT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.challenges.model.challenges.impl.PossibleChallengeParticipantImpl <em>Possible Challenge Participant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.challenges.model.challenges.impl.PossibleChallengeParticipantImpl
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getPossibleChallengeParticipant()
	 * @generated
	 */
	int POSSIBLE_CHALLENGE_PARTICIPANT = 5;

	/**
	 * The feature id for the '<em><b>Player Login Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSSIBLE_CHALLENGE_PARTICIPANT__PLAYER_LOGIN_ID = 0;

	/**
	 * The feature id for the '<em><b>Player Login Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSSIBLE_CHALLENGE_PARTICIPANT__PLAYER_LOGIN_NAME = 1;

	/**
	 * The feature id for the '<em><b>Player Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSSIBLE_CHALLENGE_PARTICIPANT__PLAYER_NAME = 2;

	/**
	 * The number of structural features of the '<em>Possible Challenge Participant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSSIBLE_CHALLENGE_PARTICIPANT_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Possible Challenge Participant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSSIBLE_CHALLENGE_PARTICIPANT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.challenges.model.challenges.impl.PossibleChallengeParticipantResultImpl <em>Possible Challenge Participant Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.challenges.model.challenges.impl.PossibleChallengeParticipantResultImpl
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getPossibleChallengeParticipantResult()
	 * @generated
	 */
	int POSSIBLE_CHALLENGE_PARTICIPANT_RESULT = 6;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSSIBLE_CHALLENGE_PARTICIPANT_RESULT__RESULT = 0;

	/**
	 * The number of structural features of the '<em>Possible Challenge Participant Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSSIBLE_CHALLENGE_PARTICIPANT_RESULT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Possible Challenge Participant Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSSIBLE_CHALLENGE_PARTICIPANT_RESULT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.challenges.model.challenges.ChallengeParticipantRole <em>Challenge Participant Role</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeParticipantRole
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeParticipantRole()
	 * @generated
	 */
	int CHALLENGE_PARTICIPANT_ROLE = 7;

	/**
	 * The meta object id for the '{@link com.playertour.backend.challenges.model.challenges.ChallengeStatusType <em>Challenge Status Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeStatusType
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeStatusType()
	 * @generated
	 */
	int CHALLENGE_STATUS_TYPE = 8;

	/**
	 * The meta object id for the '{@link com.playertour.backend.challenges.model.challenges.ChallengeType <em>Challenge Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeType
	 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeType()
	 * @generated
	 */
	int CHALLENGE_TYPE = 9;


	/**
	 * Returns the meta object for class '{@link com.playertour.backend.challenges.model.challenges.Challenge <em>Challenge</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Challenge</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.Challenge
	 * @generated
	 */
	EClass getChallenge();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.Challenge#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.Challenge#getId()
	 * @see #getChallenge()
	 * @generated
	 */
	EAttribute getChallenge_Id();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.Challenge#getDate <em>Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Date</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.Challenge#getDate()
	 * @see #getChallenge()
	 * @generated
	 */
	EAttribute getChallenge_Date();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.challenges.model.challenges.Challenge#getParticipants <em>Participants</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Participants</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.Challenge#getParticipants()
	 * @see #getChallenge()
	 * @generated
	 */
	EReference getChallenge_Participants();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.Challenge#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.Challenge#getStatus()
	 * @see #getChallenge()
	 * @generated
	 */
	EAttribute getChallenge_Status();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.Challenge#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.Challenge#getType()
	 * @see #getChallenge()
	 * @generated
	 */
	EAttribute getChallenge_Type();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.challenges.model.challenges.Challenge#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Content</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.Challenge#getContent()
	 * @see #getChallenge()
	 * @generated
	 */
	EReference getChallenge_Content();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.challenges.model.challenges.Challenge#getResult <em>Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Result</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.Challenge#getResult()
	 * @see #getChallenge()
	 * @generated
	 */
	EReference getChallenge_Result();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.challenges.model.challenges.ChallengeContent <em>Challenge Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Challenge Content</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeContent
	 * @generated
	 */
	EClass getChallengeContent();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeContent#getCourseId <em>Course Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Course Id</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeContent#getCourseId()
	 * @see #getChallengeContent()
	 * @generated
	 */
	EAttribute getChallengeContent_CourseId();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeContent#getCourseName <em>Course Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Course Name</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeContent#getCourseName()
	 * @see #getChallengeContent()
	 * @generated
	 */
	EAttribute getChallengeContent_CourseName();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeContent#getChallengedPlayerLoginId <em>Challenged Player Login Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Challenged Player Login Id</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeContent#getChallengedPlayerLoginId()
	 * @see #getChallengeContent()
	 * @generated
	 */
	EAttribute getChallengeContent_ChallengedPlayerLoginId();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeContent#getHoleNumber <em>Hole Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hole Number</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeContent#getHoleNumber()
	 * @see #getChallengeContent()
	 * @generated
	 */
	EAttribute getChallengeContent_HoleNumber();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeContent#getMinStrokesNeeded <em>Min Strokes Needed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Min Strokes Needed</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeContent#getMinStrokesNeeded()
	 * @see #getChallengeContent()
	 * @generated
	 */
	EAttribute getChallengeContent_MinStrokesNeeded();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeContent#getMeritPoints <em>Merit Points</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Merit Points</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeContent#getMeritPoints()
	 * @see #getChallengeContent()
	 * @generated
	 */
	EAttribute getChallengeContent_MeritPoints();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.challenges.model.challenges.ChallengeParticipant <em>Challenge Participant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Challenge Participant</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeParticipant
	 * @generated
	 */
	EClass getChallengeParticipant();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeParticipant#getPlayerLoginId <em>Player Login Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Player Login Id</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeParticipant#getPlayerLoginId()
	 * @see #getChallengeParticipant()
	 * @generated
	 */
	EAttribute getChallengeParticipant_PlayerLoginId();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeParticipant#getPlayerLoginName <em>Player Login Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Player Login Name</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeParticipant#getPlayerLoginName()
	 * @see #getChallengeParticipant()
	 * @generated
	 */
	EAttribute getChallengeParticipant_PlayerLoginName();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeParticipant#getPlayerName <em>Player Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Player Name</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeParticipant#getPlayerName()
	 * @see #getChallengeParticipant()
	 * @generated
	 */
	EAttribute getChallengeParticipant_PlayerName();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeParticipant#isAgainst <em>Against</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Against</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeParticipant#isAgainst()
	 * @see #getChallengeParticipant()
	 * @generated
	 */
	EAttribute getChallengeParticipant_Against();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.ChallengeParticipant#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeParticipant#getRole()
	 * @see #getChallengeParticipant()
	 * @generated
	 */
	EAttribute getChallengeParticipant_Role();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.challenges.model.challenges.ChallengeResult <em>Challenge Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Challenge Result</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeResult
	 * @generated
	 */
	EClass getChallengeResult();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.challenges.model.challenges.ChallengeResult#getWinners <em>Winners</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Winners</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeResult#getWinners()
	 * @see #getChallengeResult()
	 * @generated
	 */
	EReference getChallengeResult_Winners();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.challenges.model.challenges.ChallengeResult#getLosers <em>Losers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Losers</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeResult#getLosers()
	 * @see #getChallengeResult()
	 * @generated
	 */
	EReference getChallengeResult_Losers();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.challenges.model.challenges.ChallengeSearchResult <em>Challenge Search Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Challenge Search Result</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeSearchResult
	 * @generated
	 */
	EClass getChallengeSearchResult();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.challenges.model.challenges.ChallengeSearchResult#getResult <em>Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Result</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeSearchResult#getResult()
	 * @see #getChallengeSearchResult()
	 * @generated
	 */
	EReference getChallengeSearchResult_Result();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipant <em>Possible Challenge Participant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Possible Challenge Participant</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipant
	 * @generated
	 */
	EClass getPossibleChallengeParticipant();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipant#getPlayerLoginId <em>Player Login Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Player Login Id</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipant#getPlayerLoginId()
	 * @see #getPossibleChallengeParticipant()
	 * @generated
	 */
	EAttribute getPossibleChallengeParticipant_PlayerLoginId();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipant#getPlayerLoginName <em>Player Login Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Player Login Name</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipant#getPlayerLoginName()
	 * @see #getPossibleChallengeParticipant()
	 * @generated
	 */
	EAttribute getPossibleChallengeParticipant_PlayerLoginName();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipant#getPlayerName <em>Player Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Player Name</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipant#getPlayerName()
	 * @see #getPossibleChallengeParticipant()
	 * @generated
	 */
	EAttribute getPossibleChallengeParticipant_PlayerName();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipantResult <em>Possible Challenge Participant Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Possible Challenge Participant Result</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipantResult
	 * @generated
	 */
	EClass getPossibleChallengeParticipantResult();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipantResult#getResult <em>Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Result</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipantResult#getResult()
	 * @see #getPossibleChallengeParticipantResult()
	 * @generated
	 */
	EReference getPossibleChallengeParticipantResult_Result();

	/**
	 * Returns the meta object for enum '{@link com.playertour.backend.challenges.model.challenges.ChallengeParticipantRole <em>Challenge Participant Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Challenge Participant Role</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeParticipantRole
	 * @generated
	 */
	EEnum getChallengeParticipantRole();

	/**
	 * Returns the meta object for enum '{@link com.playertour.backend.challenges.model.challenges.ChallengeStatusType <em>Challenge Status Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Challenge Status Type</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeStatusType
	 * @generated
	 */
	EEnum getChallengeStatusType();

	/**
	 * Returns the meta object for enum '{@link com.playertour.backend.challenges.model.challenges.ChallengeType <em>Challenge Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Challenge Type</em>'.
	 * @see com.playertour.backend.challenges.model.challenges.ChallengeType
	 * @generated
	 */
	EEnum getChallengeType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ChallengesFactory getChallengesFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link com.playertour.backend.challenges.model.challenges.impl.ChallengeImpl <em>Challenge</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengeImpl
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallenge()
		 * @generated
		 */
		EClass CHALLENGE = eINSTANCE.getChallenge();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE__ID = eINSTANCE.getChallenge_Id();

		/**
		 * The meta object literal for the '<em><b>Date</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE__DATE = eINSTANCE.getChallenge_Date();

		/**
		 * The meta object literal for the '<em><b>Participants</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHALLENGE__PARTICIPANTS = eINSTANCE.getChallenge_Participants();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE__STATUS = eINSTANCE.getChallenge_Status();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE__TYPE = eINSTANCE.getChallenge_Type();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHALLENGE__CONTENT = eINSTANCE.getChallenge_Content();

		/**
		 * The meta object literal for the '<em><b>Result</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHALLENGE__RESULT = eINSTANCE.getChallenge_Result();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.challenges.model.challenges.impl.ChallengeContentImpl <em>Challenge Content</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengeContentImpl
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeContent()
		 * @generated
		 */
		EClass CHALLENGE_CONTENT = eINSTANCE.getChallengeContent();

		/**
		 * The meta object literal for the '<em><b>Course Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_CONTENT__COURSE_ID = eINSTANCE.getChallengeContent_CourseId();

		/**
		 * The meta object literal for the '<em><b>Course Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_CONTENT__COURSE_NAME = eINSTANCE.getChallengeContent_CourseName();

		/**
		 * The meta object literal for the '<em><b>Challenged Player Login Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_CONTENT__CHALLENGED_PLAYER_LOGIN_ID = eINSTANCE.getChallengeContent_ChallengedPlayerLoginId();

		/**
		 * The meta object literal for the '<em><b>Hole Number</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_CONTENT__HOLE_NUMBER = eINSTANCE.getChallengeContent_HoleNumber();

		/**
		 * The meta object literal for the '<em><b>Min Strokes Needed</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_CONTENT__MIN_STROKES_NEEDED = eINSTANCE.getChallengeContent_MinStrokesNeeded();

		/**
		 * The meta object literal for the '<em><b>Merit Points</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_CONTENT__MERIT_POINTS = eINSTANCE.getChallengeContent_MeritPoints();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.challenges.model.challenges.impl.ChallengeParticipantImpl <em>Challenge Participant</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengeParticipantImpl
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeParticipant()
		 * @generated
		 */
		EClass CHALLENGE_PARTICIPANT = eINSTANCE.getChallengeParticipant();

		/**
		 * The meta object literal for the '<em><b>Player Login Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_PARTICIPANT__PLAYER_LOGIN_ID = eINSTANCE.getChallengeParticipant_PlayerLoginId();

		/**
		 * The meta object literal for the '<em><b>Player Login Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_PARTICIPANT__PLAYER_LOGIN_NAME = eINSTANCE.getChallengeParticipant_PlayerLoginName();

		/**
		 * The meta object literal for the '<em><b>Player Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_PARTICIPANT__PLAYER_NAME = eINSTANCE.getChallengeParticipant_PlayerName();

		/**
		 * The meta object literal for the '<em><b>Against</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_PARTICIPANT__AGAINST = eINSTANCE.getChallengeParticipant_Against();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHALLENGE_PARTICIPANT__ROLE = eINSTANCE.getChallengeParticipant_Role();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.challenges.model.challenges.impl.ChallengeResultImpl <em>Challenge Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengeResultImpl
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeResult()
		 * @generated
		 */
		EClass CHALLENGE_RESULT = eINSTANCE.getChallengeResult();

		/**
		 * The meta object literal for the '<em><b>Winners</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHALLENGE_RESULT__WINNERS = eINSTANCE.getChallengeResult_Winners();

		/**
		 * The meta object literal for the '<em><b>Losers</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHALLENGE_RESULT__LOSERS = eINSTANCE.getChallengeResult_Losers();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.challenges.model.challenges.impl.ChallengeSearchResultImpl <em>Challenge Search Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengeSearchResultImpl
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeSearchResult()
		 * @generated
		 */
		EClass CHALLENGE_SEARCH_RESULT = eINSTANCE.getChallengeSearchResult();

		/**
		 * The meta object literal for the '<em><b>Result</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHALLENGE_SEARCH_RESULT__RESULT = eINSTANCE.getChallengeSearchResult_Result();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.challenges.model.challenges.impl.PossibleChallengeParticipantImpl <em>Possible Challenge Participant</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.challenges.model.challenges.impl.PossibleChallengeParticipantImpl
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getPossibleChallengeParticipant()
		 * @generated
		 */
		EClass POSSIBLE_CHALLENGE_PARTICIPANT = eINSTANCE.getPossibleChallengeParticipant();

		/**
		 * The meta object literal for the '<em><b>Player Login Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POSSIBLE_CHALLENGE_PARTICIPANT__PLAYER_LOGIN_ID = eINSTANCE.getPossibleChallengeParticipant_PlayerLoginId();

		/**
		 * The meta object literal for the '<em><b>Player Login Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POSSIBLE_CHALLENGE_PARTICIPANT__PLAYER_LOGIN_NAME = eINSTANCE.getPossibleChallengeParticipant_PlayerLoginName();

		/**
		 * The meta object literal for the '<em><b>Player Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POSSIBLE_CHALLENGE_PARTICIPANT__PLAYER_NAME = eINSTANCE.getPossibleChallengeParticipant_PlayerName();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.challenges.model.challenges.impl.PossibleChallengeParticipantResultImpl <em>Possible Challenge Participant Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.challenges.model.challenges.impl.PossibleChallengeParticipantResultImpl
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getPossibleChallengeParticipantResult()
		 * @generated
		 */
		EClass POSSIBLE_CHALLENGE_PARTICIPANT_RESULT = eINSTANCE.getPossibleChallengeParticipantResult();

		/**
		 * The meta object literal for the '<em><b>Result</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference POSSIBLE_CHALLENGE_PARTICIPANT_RESULT__RESULT = eINSTANCE.getPossibleChallengeParticipantResult_Result();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.challenges.model.challenges.ChallengeParticipantRole <em>Challenge Participant Role</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.challenges.model.challenges.ChallengeParticipantRole
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeParticipantRole()
		 * @generated
		 */
		EEnum CHALLENGE_PARTICIPANT_ROLE = eINSTANCE.getChallengeParticipantRole();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.challenges.model.challenges.ChallengeStatusType <em>Challenge Status Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.challenges.model.challenges.ChallengeStatusType
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeStatusType()
		 * @generated
		 */
		EEnum CHALLENGE_STATUS_TYPE = eINSTANCE.getChallengeStatusType();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.challenges.model.challenges.ChallengeType <em>Challenge Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.challenges.model.challenges.ChallengeType
		 * @see com.playertour.backend.challenges.model.challenges.impl.ChallengesPackageImpl#getChallengeType()
		 * @generated
		 */
		EEnum CHALLENGE_TYPE = eINSTANCE.getChallengeType();

	}

} //ChallengesPackage
