/**
 */
package com.playertour.backend.challenges.model.challenges.impl;

import com.playertour.backend.challenges.model.challenges.Challenge;
import com.playertour.backend.challenges.model.challenges.ChallengeContent;
import com.playertour.backend.challenges.model.challenges.ChallengeParticipant;
import com.playertour.backend.challenges.model.challenges.ChallengeParticipantRole;
import com.playertour.backend.challenges.model.challenges.ChallengeResult;
import com.playertour.backend.challenges.model.challenges.ChallengeSearchResult;
import com.playertour.backend.challenges.model.challenges.ChallengeStatusType;
import com.playertour.backend.challenges.model.challenges.ChallengeType;
import com.playertour.backend.challenges.model.challenges.ChallengesFactory;
import com.playertour.backend.challenges.model.challenges.ChallengesPackage;
import com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipant;
import com.playertour.backend.challenges.model.challenges.PossibleChallengeParticipantResult;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ChallengesPackageImpl extends EPackageImpl implements ChallengesPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass challengeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass challengeContentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass challengeParticipantEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass challengeResultEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass challengeSearchResultEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass possibleChallengeParticipantEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass possibleChallengeParticipantResultEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum challengeParticipantRoleEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum challengeStatusTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum challengeTypeEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see com.playertour.backend.challenges.model.challenges.ChallengesPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ChallengesPackageImpl() {
		super(eNS_URI, ChallengesFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link ChallengesPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ChallengesPackage init() {
		if (isInited) return (ChallengesPackage)EPackage.Registry.INSTANCE.getEPackage(ChallengesPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredChallengesPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		ChallengesPackageImpl theChallengesPackage = registeredChallengesPackage instanceof ChallengesPackageImpl ? (ChallengesPackageImpl)registeredChallengesPackage : new ChallengesPackageImpl();

		isInited = true;

		// Create package meta-data objects
		theChallengesPackage.createPackageContents();

		// Initialize created meta-data
		theChallengesPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theChallengesPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(ChallengesPackage.eNS_URI, theChallengesPackage);
		return theChallengesPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getChallenge() {
		return challengeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallenge_Id() {
		return (EAttribute)challengeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallenge_Date() {
		return (EAttribute)challengeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChallenge_Participants() {
		return (EReference)challengeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallenge_Status() {
		return (EAttribute)challengeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallenge_Type() {
		return (EAttribute)challengeEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChallenge_Content() {
		return (EReference)challengeEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChallenge_Result() {
		return (EReference)challengeEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getChallengeContent() {
		return challengeContentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeContent_CourseId() {
		return (EAttribute)challengeContentEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeContent_CourseName() {
		return (EAttribute)challengeContentEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeContent_ChallengedPlayerLoginId() {
		return (EAttribute)challengeContentEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeContent_HoleNumber() {
		return (EAttribute)challengeContentEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeContent_MinStrokesNeeded() {
		return (EAttribute)challengeContentEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeContent_MeritPoints() {
		return (EAttribute)challengeContentEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getChallengeParticipant() {
		return challengeParticipantEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeParticipant_PlayerLoginId() {
		return (EAttribute)challengeParticipantEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeParticipant_PlayerLoginName() {
		return (EAttribute)challengeParticipantEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeParticipant_PlayerName() {
		return (EAttribute)challengeParticipantEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeParticipant_Against() {
		return (EAttribute)challengeParticipantEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getChallengeParticipant_Role() {
		return (EAttribute)challengeParticipantEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getChallengeResult() {
		return challengeResultEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChallengeResult_Winners() {
		return (EReference)challengeResultEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChallengeResult_Losers() {
		return (EReference)challengeResultEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getChallengeSearchResult() {
		return challengeSearchResultEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getChallengeSearchResult_Result() {
		return (EReference)challengeSearchResultEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPossibleChallengeParticipant() {
		return possibleChallengeParticipantEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPossibleChallengeParticipant_PlayerLoginId() {
		return (EAttribute)possibleChallengeParticipantEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPossibleChallengeParticipant_PlayerLoginName() {
		return (EAttribute)possibleChallengeParticipantEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPossibleChallengeParticipant_PlayerName() {
		return (EAttribute)possibleChallengeParticipantEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPossibleChallengeParticipantResult() {
		return possibleChallengeParticipantResultEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPossibleChallengeParticipantResult_Result() {
		return (EReference)possibleChallengeParticipantResultEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getChallengeParticipantRole() {
		return challengeParticipantRoleEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getChallengeStatusType() {
		return challengeStatusTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getChallengeType() {
		return challengeTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ChallengesFactory getChallengesFactory() {
		return (ChallengesFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		challengeEClass = createEClass(CHALLENGE);
		createEAttribute(challengeEClass, CHALLENGE__ID);
		createEAttribute(challengeEClass, CHALLENGE__DATE);
		createEReference(challengeEClass, CHALLENGE__PARTICIPANTS);
		createEAttribute(challengeEClass, CHALLENGE__STATUS);
		createEAttribute(challengeEClass, CHALLENGE__TYPE);
		createEReference(challengeEClass, CHALLENGE__CONTENT);
		createEReference(challengeEClass, CHALLENGE__RESULT);

		challengeContentEClass = createEClass(CHALLENGE_CONTENT);
		createEAttribute(challengeContentEClass, CHALLENGE_CONTENT__COURSE_ID);
		createEAttribute(challengeContentEClass, CHALLENGE_CONTENT__COURSE_NAME);
		createEAttribute(challengeContentEClass, CHALLENGE_CONTENT__CHALLENGED_PLAYER_LOGIN_ID);
		createEAttribute(challengeContentEClass, CHALLENGE_CONTENT__HOLE_NUMBER);
		createEAttribute(challengeContentEClass, CHALLENGE_CONTENT__MIN_STROKES_NEEDED);
		createEAttribute(challengeContentEClass, CHALLENGE_CONTENT__MERIT_POINTS);

		challengeParticipantEClass = createEClass(CHALLENGE_PARTICIPANT);
		createEAttribute(challengeParticipantEClass, CHALLENGE_PARTICIPANT__PLAYER_LOGIN_ID);
		createEAttribute(challengeParticipantEClass, CHALLENGE_PARTICIPANT__PLAYER_LOGIN_NAME);
		createEAttribute(challengeParticipantEClass, CHALLENGE_PARTICIPANT__PLAYER_NAME);
		createEAttribute(challengeParticipantEClass, CHALLENGE_PARTICIPANT__AGAINST);
		createEAttribute(challengeParticipantEClass, CHALLENGE_PARTICIPANT__ROLE);

		challengeResultEClass = createEClass(CHALLENGE_RESULT);
		createEReference(challengeResultEClass, CHALLENGE_RESULT__WINNERS);
		createEReference(challengeResultEClass, CHALLENGE_RESULT__LOSERS);

		challengeSearchResultEClass = createEClass(CHALLENGE_SEARCH_RESULT);
		createEReference(challengeSearchResultEClass, CHALLENGE_SEARCH_RESULT__RESULT);

		possibleChallengeParticipantEClass = createEClass(POSSIBLE_CHALLENGE_PARTICIPANT);
		createEAttribute(possibleChallengeParticipantEClass, POSSIBLE_CHALLENGE_PARTICIPANT__PLAYER_LOGIN_ID);
		createEAttribute(possibleChallengeParticipantEClass, POSSIBLE_CHALLENGE_PARTICIPANT__PLAYER_LOGIN_NAME);
		createEAttribute(possibleChallengeParticipantEClass, POSSIBLE_CHALLENGE_PARTICIPANT__PLAYER_NAME);

		possibleChallengeParticipantResultEClass = createEClass(POSSIBLE_CHALLENGE_PARTICIPANT_RESULT);
		createEReference(possibleChallengeParticipantResultEClass, POSSIBLE_CHALLENGE_PARTICIPANT_RESULT__RESULT);

		// Create enums
		challengeParticipantRoleEEnum = createEEnum(CHALLENGE_PARTICIPANT_ROLE);
		challengeStatusTypeEEnum = createEEnum(CHALLENGE_STATUS_TYPE);
		challengeTypeEEnum = createEEnum(CHALLENGE_TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes, features, and operations; add parameters
		initEClass(challengeEClass, Challenge.class, "Challenge", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getChallenge_Id(), ecorePackage.getEString(), "id", null, 1, 1, Challenge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallenge_Date(), ecorePackage.getEDate(), "date", null, 0, 1, Challenge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getChallenge_Participants(), this.getChallengeParticipant(), null, "participants", null, 0, -1, Challenge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallenge_Status(), this.getChallengeStatusType(), "status", null, 0, 1, Challenge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallenge_Type(), this.getChallengeType(), "type", null, 0, 1, Challenge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getChallenge_Content(), this.getChallengeContent(), null, "content", null, 0, 1, Challenge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getChallenge_Result(), this.getChallengeResult(), null, "result", null, 0, 1, Challenge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(challengeContentEClass, ChallengeContent.class, "ChallengeContent", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getChallengeContent_CourseId(), ecorePackage.getEString(), "courseId", null, 1, 1, ChallengeContent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallengeContent_CourseName(), ecorePackage.getEString(), "courseName", null, 0, 1, ChallengeContent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallengeContent_ChallengedPlayerLoginId(), ecorePackage.getEString(), "challengedPlayerLoginId", null, 1, 1, ChallengeContent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallengeContent_HoleNumber(), ecorePackage.getEInt(), "holeNumber", null, 1, 1, ChallengeContent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallengeContent_MinStrokesNeeded(), ecorePackage.getEInt(), "minStrokesNeeded", null, 1, 1, ChallengeContent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallengeContent_MeritPoints(), ecorePackage.getEInt(), "meritPoints", null, 1, 1, ChallengeContent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(challengeParticipantEClass, ChallengeParticipant.class, "ChallengeParticipant", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getChallengeParticipant_PlayerLoginId(), ecorePackage.getEString(), "playerLoginId", null, 1, 1, ChallengeParticipant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallengeParticipant_PlayerLoginName(), ecorePackage.getEString(), "playerLoginName", null, 0, 1, ChallengeParticipant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallengeParticipant_PlayerName(), ecorePackage.getEString(), "playerName", null, 0, 1, ChallengeParticipant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallengeParticipant_Against(), ecorePackage.getEBoolean(), "against", null, 0, 1, ChallengeParticipant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getChallengeParticipant_Role(), this.getChallengeParticipantRole(), "role", null, 1, 1, ChallengeParticipant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(challengeResultEClass, ChallengeResult.class, "ChallengeResult", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getChallengeResult_Winners(), this.getChallengeParticipant(), null, "winners", null, 0, -1, ChallengeResult.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getChallengeResult_Losers(), this.getChallengeParticipant(), null, "losers", null, 0, -1, ChallengeResult.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(challengeSearchResultEClass, ChallengeSearchResult.class, "ChallengeSearchResult", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getChallengeSearchResult_Result(), this.getChallenge(), null, "result", null, 0, -1, ChallengeSearchResult.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(possibleChallengeParticipantEClass, PossibleChallengeParticipant.class, "PossibleChallengeParticipant", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPossibleChallengeParticipant_PlayerLoginId(), ecorePackage.getEString(), "playerLoginId", null, 1, 1, PossibleChallengeParticipant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPossibleChallengeParticipant_PlayerLoginName(), ecorePackage.getEString(), "playerLoginName", null, 0, 1, PossibleChallengeParticipant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPossibleChallengeParticipant_PlayerName(), ecorePackage.getEString(), "playerName", null, 0, 1, PossibleChallengeParticipant.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(possibleChallengeParticipantResultEClass, PossibleChallengeParticipantResult.class, "PossibleChallengeParticipantResult", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPossibleChallengeParticipantResult_Result(), this.getPossibleChallengeParticipant(), null, "result", null, 0, -1, PossibleChallengeParticipantResult.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(challengeParticipantRoleEEnum, ChallengeParticipantRole.class, "ChallengeParticipantRole");
		addEEnumLiteral(challengeParticipantRoleEEnum, ChallengeParticipantRole.UNKNOWN);
		addEEnumLiteral(challengeParticipantRoleEEnum, ChallengeParticipantRole.CHALLENGER);
		addEEnumLiteral(challengeParticipantRoleEEnum, ChallengeParticipantRole.CHALLENGED);
		addEEnumLiteral(challengeParticipantRoleEEnum, ChallengeParticipantRole.INVITED);

		initEEnum(challengeStatusTypeEEnum, ChallengeStatusType.class, "ChallengeStatusType");
		addEEnumLiteral(challengeStatusTypeEEnum, ChallengeStatusType.OPEN);
		addEEnumLiteral(challengeStatusTypeEEnum, ChallengeStatusType.ACCEPTED);
		addEEnumLiteral(challengeStatusTypeEEnum, ChallengeStatusType.DECLINED);
		addEEnumLiteral(challengeStatusTypeEEnum, ChallengeStatusType.CLOSED);

		initEEnum(challengeTypeEEnum, ChallengeType.class, "ChallengeType");
		addEEnumLiteral(challengeTypeEEnum, ChallengeType.DEFAULT);
		addEEnumLiteral(challengeTypeEEnum, ChallengeType.NASSAU);
		addEEnumLiteral(challengeTypeEEnum, ChallengeType.SKINS);
		addEEnumLiteral(challengeTypeEEnum, ChallengeType.WOLF);
		addEEnumLiteral(challengeTypeEEnum, ChallengeType.SNAKE);
		addEEnumLiteral(challengeTypeEEnum, ChallengeType.BINGO_BANGO_BONGO);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/OCL/Import
		createImportAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/OCL/Import</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createImportAnnotations() {
		String source = "http://www.eclipse.org/OCL/Import";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "ecore", "http://www.eclipse.org/emf/2002/Ecore"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (getChallengeContent_ChallengedPlayerLoginId(),
		   source,
		   new String[] {
			   "documentation", "The login id of the Player who has been challenged."
		   });
		addAnnotation
		  (getChallengeParticipant_Against(),
		   source,
		   new String[] {
			   "documentation", "If set to true, it means that challenge participant is against the challenge content. Otherwise challenge participant is for the challenge content."
		   });
		addAnnotation
		  (challengeTypeEEnum.getELiterals().get(0),
		   source,
		   new String[] {
			   "documentation", "Consists in challenging a Player to complete a certain hole in less than a certain number of strokes."
		   });
		addAnnotation
		  (challengeTypeEEnum.getELiterals().get(1),
		   source,
		   new String[] {
			   "documentation", "Is a three-part challenge with the same stake wagered on the first nine holes, the second nine, and the total for the round. If you\u2019re playing a $5 Nassau and you win all three parts, you\u2019re up $15."
		   });
		addAnnotation
		  (challengeTypeEEnum.getELiterals().get(2),
		   source,
		   new String[] {
			   "documentation", "Is the format in which each hole is worth a certain amount \u2014 but if two players tie, all tie, and the money goes into the pot for the next hole (and sometimes the next and the next)."
		   });
		addAnnotation
		  (challengeTypeEEnum.getELiterals().get(3),
		   source,
		   new String[] {
			   "documentation", "To play wolf, one player takes on everyone else in the group. For a set price, the lone wolf can choose one of the others as his or her partner."
		   });
		addAnnotation
		  (challengeTypeEEnum.getELiterals().get(4),
		   source,
		   new String[] {
			   "documentation", "Snake is a side challenge: The first player to three-putt a hole gets stuck with a \u201csnake\u201d that costs a predetermined sum each hole until someone else three-putts."
		   });
		addAnnotation
		  (challengeTypeEEnum.getELiterals().get(5),
		   source,
		   new String[] {
			   "documentation", "In Bingo Bango Bongo, the first player on the green earns a point (bingo), as does the one closest to the hole when everybody\u2019s safely on (bango) and the first to hole a putt (bongo)."
		   });
	}

} //ChallengesPackageImpl
