/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.challenges.service.api;

import com.playertour.backend.apis.events.PlayerTourEvents;

public interface ChallengesEvents {
	
	static final String TOPIC_BASE = PlayerTourEvents.TOPIC_BASE + "ChallengeEvents/";
	
	static final String TOPIC_ISSUED_SELF = ChallengesEvents.TOPIC_BASE + "ISSUED_SELF";

	static final String TOPIC_ISSUED_OTHER = ChallengesEvents.TOPIC_BASE + "ISSUED_OTHER";

	static final String TOPIC_ACCEPTED_SELF = ChallengesEvents.TOPIC_BASE + "ACCEPTED_SELF";

	static final String TOPIC_ACCEPTED_OTHER = ChallengesEvents.TOPIC_BASE + "ACCEPTED_OTHER";

	static final String TOPIC_DECLINED_SELF = ChallengesEvents.TOPIC_BASE + "DECLINED_SELF";

	static final String TOPIC_DECLINED_OTHER = ChallengesEvents.TOPIC_BASE + "DECLINED_OTHER";

	static final String TOPIC_CLOSED_SELF = ChallengesEvents.TOPIC_BASE + "CLOSED_SELF";

	static final String TOPIC_CLOSED_OTHER = ChallengesEvents.TOPIC_BASE + "CLOSED_OTHER";

	static final String TOPIC_INVITE_SELF = ChallengesEvents.TOPIC_BASE + "INVITE_SELF";

	static final String TOPIC_INVITE_OTHER = ChallengesEvents.TOPIC_BASE + "INVITE_OTHER";

	static final String TOPIC_INVITE_ACCEPTED_SELF = ChallengesEvents.TOPIC_BASE + "INVITE_ACCEPTED_SELF";

	static final String TOPIC_INVITE_ACCEPTED_OTHER_FOR = ChallengesEvents.TOPIC_BASE + "INVITE_ACCEPTED_OTHER_FOR";

	static final String TOPIC_INVITE_ACCEPTED_OTHER_AGAINST = ChallengesEvents.TOPIC_BASE + "INVITE_ACCEPTED_OTHER_AGAINST";

	static final String TOPIC_INVITE_DECLINED_SELF = ChallengesEvents.TOPIC_BASE + "INVITE_DECLINED_SELF";

	static final String TOPIC_INVITE_DECLINED_OTHER = ChallengesEvents.TOPIC_BASE + "INVITE_DECLINED_OTHER";

	static final String TOPIC_WON = ChallengesEvents.TOPIC_BASE + "WON";

	static final String TOPIC_LOST = ChallengesEvents.TOPIC_BASE + "LOST";
	
	static final String TOPIC_ALL = ChallengesEvents.TOPIC_BASE + "*";
	
	static final String PROPERTY_KEY_EVENT_ID = PlayerTourEvents.PROPERTY_KEY_EVENT_ID;
	
	static final String PROPERTY_KEY_LOGIN_ID = PlayerTourEvents.PROPERTY_KEY_LOGIN_ID;
	
	static final String PROPERTY_KEY_LOGIN_NAME = "loginName";
	
	static final String PROPERTY_KEY_MERIT_POINTS = "meritPoints";
	
	static final String PROPERTY_KEY_CHALLENGE_ID = "challengeId";
	
	static final String PROPERTY_KEY_CHALLENGE_DATE = "challengeDate";
	
}
