/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.challenges.service.impl.events.publishers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventProperties;

import com.playertour.backend.challenges.service.api.ChallengesEvents;

public class ChallengesEventPublisher {
	
	public static void publishChallengeIssuedSelfEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_ISSUED_SELF, constructEventProperties(loginId, playerName, challengeId, challengeDate)));	
	}
	
	public static void publishChallengeIssuedOtherEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_ISSUED_OTHER, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}

	public static void publishChallengeAcceptedSelfEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_ACCEPTED_SELF, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}
	
	public static void publishChallengeAcceptedOtherEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_ACCEPTED_OTHER, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}	
	
	public static void publishChallengeDeclinedSelfEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_DECLINED_SELF, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}
	
	public static void publishChallengeDeclinedOtherEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_DECLINED_OTHER, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}
	
	public static void publishChallengeClosedSelfEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_CLOSED_SELF, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}
	
	public static void publishChallengeClosedOtherEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_CLOSED_OTHER, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}
	
	public static void publishChallengeInviteSelfEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_INVITE_SELF, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}	
	
	public static void publishChallengeInviteOtherEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_INVITE_OTHER, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}	
	
	public static void publishChallengeInviteAcceptedSelfEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_INVITE_ACCEPTED_SELF, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}	
	
	public static void publishChallengeInviteAcceptedOtherForEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_INVITE_ACCEPTED_OTHER_FOR, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}	
	
	public static void publishChallengeInviteAcceptedOtherAgainstEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_INVITE_ACCEPTED_OTHER_AGAINST, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}	
	
	public static void publishChallengeInviteDeclinedSelfEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_INVITE_DECLINED_SELF, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}
	
	public static void publishChallengeInviteDeclinedOtherEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_INVITE_DECLINED_OTHER, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}
	
	public static void publishChallengeWonEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_WON, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}	
	
	public static void publishChallengeLostEvent(EventAdmin eventAdmin, String loginId, String playerName, String challengeId, String challengeDate) {
		eventAdmin.postEvent(new Event(ChallengesEvents.TOPIC_LOST, constructEventProperties(loginId, playerName, challengeId, challengeDate)));
	}
	
	private static EventProperties constructEventProperties(String loginId, String playerName, String challengeId, String challengeDate) {
		Map<String, Object> properties = new HashMap<String, Object>();
		properties.put(ChallengesEvents.PROPERTY_KEY_EVENT_ID, UUID.randomUUID().toString());
		properties.put(ChallengesEvents.PROPERTY_KEY_LOGIN_ID, loginId);
		properties.put(ChallengesEvents.PROPERTY_KEY_LOGIN_NAME, playerName);
		properties.put(ChallengesEvents.PROPERTY_KEY_CHALLENGE_ID, challengeId);
		properties.put(ChallengesEvents.PROPERTY_KEY_CHALLENGE_DATE, challengeDate);
		
		return new EventProperties(properties);
	}
}
