/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.challenges.service.tests.helper;

import java.util.List;

import com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo;
import com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourse;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourseFactory;

public class ChallengesTestHelper {

	public static GolfCourse createTestGolfCourse(String courseId) {
		CourseScorecardInfo scorecardInfo = GolfCourseFactory.eINSTANCE.createCourseScorecardInfo();
		scorecardInfo.setParIn(7);
		scorecardInfo.setParOut(8);
		scorecardInfo.setParTotal(15);
		scorecardInfo.getHcpHole().addAll(List.of(9, 8, 7, 6, 5, 4, 3, 2, 1));
		scorecardInfo.getParHole().addAll(List.of(9, 8, 7, 6, 5, 4, 3, 2, 1));

		CourseScorecards courseScorecards = GolfCourseFactory.eINSTANCE.createCourseScorecards();
		courseScorecards.getMenScorecard().add(scorecardInfo);
		courseScorecards.getWmnScorecard().add(scorecardInfo);

		GolfCourse golfCourse = GolfCourseFactory.eINSTANCE.createGolfCourse();
		golfCourse.setCourseId(courseId);
		golfCourse.setScorecards(courseScorecards);
		return golfCourse;
	}
}
